/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Cancellable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.raft.RaftActor;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.TimedRunnable;
import org.opendaylight.controller.cluster.raft.base.messages.LeaderTransitioning;
import org.opendaylight.controller.cluster.raft.behaviors.Leader;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class RaftActorLeadershipTransferCohort {
    private static final Logger LOG = LoggerFactory.getLogger(RaftActorLeadershipTransferCohort.class);
    static final long USE_DEFAULT_LEADER_TIMEOUT = -1L;
    private final List<OnComplete> onCompleteCallbacks = new ArrayList<OnComplete>();
    private final Stopwatch transferTimer = Stopwatch.createUnstarted();
    private final RaftActor raftActor;
    private final String requestedFollowerId;
    private long newLeaderTimeoutInMillis = 2000L;
    private Cancellable newLeaderTimer;
    private boolean isTransferring;

    RaftActorLeadershipTransferCohort(RaftActor raftActor) {
        this(raftActor, null);
    }

    RaftActorLeadershipTransferCohort(RaftActor raftActor, @Nullable String requestedFollowerId) {
        this.raftActor = raftActor;
        this.requestedFollowerId = requestedFollowerId;
        long electionTimeout = raftActor.getRaftActorContext().getConfigParams().getElectionTimeOutInterval().toMillis();
        int variance = raftActor.getRaftActorContext().getConfigParams().getElectionTimeVariance();
        this.newLeaderTimeoutInMillis = 2L * (electionTimeout + (long)variance);
    }

    void init() {
        RaftActorContext context = this.raftActor.getRaftActorContext();
        RaftActorBehavior currentBehavior = this.raftActor.getCurrentBehavior();
        this.transferTimer.start();
        Optional<ActorRef> roleChangeNotifier = this.raftActor.getRoleChangeNotifier();
        if (roleChangeNotifier.isPresent()) {
            roleChangeNotifier.get().tell((Object)this.raftActor.newLeaderStateChanged(context.getId(), null, currentBehavior.getLeaderPayloadVersion()), this.raftActor.self());
        }
        for (String peerId : context.getPeerIds()) {
            ActorSelection followerActor = context.getPeerActorSelection(peerId);
            if (followerActor == null) continue;
            followerActor.tell((Object)new LeaderTransitioning(context.getId()), context.getActor());
        }
        this.raftActor.pauseLeader(new TimedRunnable(context.getConfigParams().getElectionTimeOutInterval(), this.raftActor){

            @Override
            protected void doRun() {
                LOG.debug("{}: pauseLeader successfully completed - doing transfer", (Object)RaftActorLeadershipTransferCohort.this.raftActor.persistenceId());
                RaftActorLeadershipTransferCohort.this.doTransfer();
            }

            @Override
            protected void doCancel() {
                LOG.debug("{}: pauseLeader timed out - continuing with transfer", (Object)RaftActorLeadershipTransferCohort.this.raftActor.persistenceId());
                RaftActorLeadershipTransferCohort.this.doTransfer();
            }
        });
    }

    @VisibleForTesting
    void doTransfer() {
        RaftActorBehavior behavior = this.raftActor.getCurrentBehavior();
        if (behavior instanceof Leader) {
            Leader leader = (Leader)behavior;
            this.isTransferring = true;
            leader.transferLeadership(this);
        } else {
            LOG.debug("{}: No longer the leader - skipping transfer", (Object)this.raftActor.persistenceId());
            this.finish(true);
        }
    }

    public void abortTransfer() {
        LOG.debug("{}: leader transfer aborted", (Object)this.raftActor.persistenceId());
        this.finish(false);
    }

    public void transferComplete() {
        LOG.debug("{}: leader transfer complete - waiting for new leader", (Object)this.raftActor.persistenceId());
        FiniteDuration timeout = FiniteDuration.create((long)this.newLeaderTimeoutInMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        this.newLeaderTimer = this.raftActor.getContext().system().scheduler().scheduleOnce(timeout, this.raftActor.self(), () -> {
            LOG.debug("{}: leader not elected in time", (Object)this.raftActor.persistenceId());
            this.finish(true);
        }, (ExecutionContext)this.raftActor.getContext().system().dispatcher(), this.raftActor.self());
    }

    void onNewLeader(String newLeader) {
        if (newLeader != null && this.newLeaderTimer != null) {
            LOG.debug("{}: leader changed to {}", (Object)this.raftActor.persistenceId(), (Object)newLeader);
            this.newLeaderTimer.cancel();
            this.finish(true);
        }
    }

    private void finish(boolean success) {
        this.isTransferring = false;
        if (this.transferTimer.isRunning()) {
            this.transferTimer.stop();
            if (success) {
                LOG.info("{}: Successfully transferred leadership to {} in {}", new Object[]{this.raftActor.persistenceId(), this.raftActor.getLeaderId(), this.transferTimer});
            } else {
                LOG.warn("{}: Failed to transfer leadership in {}", (Object)this.raftActor.persistenceId(), (Object)this.transferTimer);
                this.raftActor.unpauseLeader();
            }
        }
        for (OnComplete onComplete : this.onCompleteCallbacks) {
            if (success) {
                onComplete.onSuccess(this.raftActor.self());
                continue;
            }
            onComplete.onFailure(this.raftActor.self());
        }
    }

    void addOnComplete(OnComplete onComplete) {
        this.onCompleteCallbacks.add(onComplete);
    }

    boolean isTransferring() {
        return this.isTransferring;
    }

    void setNewLeaderTimeoutInMillis(long newLeaderTimeoutInMillis) {
        if (newLeaderTimeoutInMillis != -1L) {
            this.newLeaderTimeoutInMillis = newLeaderTimeoutInMillis;
        }
    }

    public Optional<String> getRequestedFollowerId() {
        return Optional.ofNullable(this.requestedFollowerId);
    }

    static interface OnComplete {
        public void onSuccess(ActorRef var1);

        public void onFailure(ActorRef var1);
    }
}

