/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.behaviors;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.FiniteDuration;

public final class LeaderInstallSnapshotState
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderInstallSnapshotState.class);
    static final int FIRST_CHUNK_INDEX = 1;
    static final int INVALID_CHUNK_INDEX = -1;
    static final int INITIAL_OFFSET = -1;
    static final int INITIAL_LAST_CHUNK_HASH_CODE = -1;
    private final int snapshotChunkSize;
    private final String logName;
    private ByteSource snapshotBytes;
    private int offset = -1;
    private int replyReceivedForOffset = -1;
    private boolean replyStatus = false;
    private int chunkIndex = 1;
    private int totalChunks;
    private int lastChunkHashCode = -1;
    private int nextChunkHashCode = -1;
    private long snapshotSize;
    private InputStream snapshotInputStream;
    private final Stopwatch chunkTimer = Stopwatch.createUnstarted();
    private byte[] currentChunk = null;

    LeaderInstallSnapshotState(int snapshotChunkSize, String logName) {
        this.snapshotChunkSize = snapshotChunkSize;
        this.logName = logName;
    }

    void setSnapshotBytes(ByteSource snapshotBytes) throws IOException {
        if (this.snapshotBytes != null) {
            return;
        }
        this.snapshotSize = snapshotBytes.size();
        this.snapshotInputStream = snapshotBytes.openStream();
        this.snapshotBytes = snapshotBytes;
        this.totalChunks = (int)(this.snapshotSize / (long)this.snapshotChunkSize + (long)(this.snapshotSize % (long)this.snapshotChunkSize > 0L ? 1 : 0));
        LOG.debug("{}: Snapshot {} bytes, total chunks to send: {}", new Object[]{this.logName, this.snapshotSize, this.totalChunks});
        this.replyReceivedForOffset = -1;
        this.chunkIndex = 1;
    }

    int incrementOffset() {
        this.offset = this.offset == -1 ? 0 : (this.offset += this.snapshotChunkSize);
        return this.offset;
    }

    int incrementChunkIndex() {
        if (this.replyStatus) {
            ++this.chunkIndex;
        }
        return this.chunkIndex;
    }

    void startChunkTimer() {
        this.chunkTimer.start();
    }

    void resetChunkTimer() {
        this.chunkTimer.reset();
    }

    boolean isChunkTimedOut(FiniteDuration timeout) {
        return this.chunkTimer.elapsed(TimeUnit.SECONDS) > timeout.toSeconds();
    }

    int getChunkIndex() {
        return this.chunkIndex;
    }

    int getTotalChunks() {
        return this.totalChunks;
    }

    boolean canSendNextChunk() {
        return this.snapshotBytes != null && (this.nextChunkHashCode == -1 || this.replyReceivedForOffset == this.offset);
    }

    boolean isLastChunk(int index) {
        return this.totalChunks == index;
    }

    void markSendStatus(boolean success) {
        if (success) {
            this.replyReceivedForOffset = this.offset;
            this.replyStatus = true;
            this.lastChunkHashCode = this.nextChunkHashCode;
        } else {
            this.offset = this.replyReceivedForOffset;
            this.replyStatus = false;
        }
    }

    byte[] getNextChunk() throws IOException {
        int start = this.incrementOffset();
        if (this.replyStatus || this.currentChunk == null) {
            int size = this.snapshotChunkSize;
            if ((long)this.snapshotChunkSize > this.snapshotSize) {
                size = (int)this.snapshotSize;
            } else if ((long)(start + this.snapshotChunkSize) > this.snapshotSize) {
                size = (int)(this.snapshotSize - (long)start);
            }
            this.currentChunk = new byte[size];
            int numRead = this.snapshotInputStream.read(this.currentChunk);
            if (numRead != size) {
                throw new IOException(String.format("The # of bytes read from the input stream, %d,does not match the expected # %d", numRead, size));
            }
            this.nextChunkHashCode = Arrays.hashCode(this.currentChunk);
            LOG.debug("{}: Next chunk: total length={}, offset={}, size={}, hashCode={}", new Object[]{this.logName, this.snapshotSize, start, size, this.nextChunkHashCode});
        }
        return this.currentChunk;
    }

    void reset() {
        this.closeStream();
        this.chunkTimer.reset();
        this.offset = -1;
        this.replyStatus = false;
        this.replyReceivedForOffset = -1;
        this.chunkIndex = 1;
        this.currentChunk = null;
        this.lastChunkHashCode = -1;
        this.nextChunkHashCode = -1;
        try {
            this.snapshotInputStream = this.snapshotBytes.openStream();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        this.closeStream();
        this.snapshotBytes = null;
    }

    private void closeStream() {
        if (this.snapshotInputStream != null) {
            try {
                this.snapshotInputStream.close();
            }
            catch (IOException e) {
                LOG.warn("{}: Error closing snapshot stream", (Object)this.logName, (Object)e);
            }
            this.snapshotInputStream = null;
        }
    }

    int getLastChunkHashCode() {
        return this.lastChunkHashCode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("snapshotChunkSize", this.snapshotChunkSize).add("offset", this.offset).add("replyReceivedForOffset", this.replyReceivedForOffset).add("replyStatus", this.replyStatus).add("chunkIndex", this.chunkIndex).add("totalChunks", this.totalChunks).add("lastChunkHashCode", this.lastChunkHashCode).add("nextChunkHashCode", this.nextChunkHashCode).add("snapshotSize", this.snapshotSize).add("chunkTimer", (Object)this.chunkTimer).toString();
    }
}

