/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.raft.messages.AbstractRaftRPC;
import org.opendaylight.controller.cluster.raft.messages.IR;

public final class InstallSnapshotReply
extends AbstractRaftRPC {
    private static final long serialVersionUID = 642227896390779503L;
    private final String followerId;
    private final int chunkIndex;
    private final boolean success;

    public InstallSnapshotReply(long term, String followerId, int chunkIndex, boolean success) {
        super(term);
        this.followerId = followerId;
        this.chunkIndex = chunkIndex;
        this.success = success;
    }

    public String getFollowerId() {
        return this.followerId;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String toString() {
        return "InstallSnapshotReply [term=" + this.getTerm() + ", followerId=" + this.followerId + ", chunkIndex=" + this.chunkIndex + ", success=" + this.success + "]";
    }

    @Override
    Object writeReplace() {
        return new IR(this);
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private InstallSnapshotReply installSnapshotReply;

        public Proxy() {
        }

        Proxy(InstallSnapshotReply installSnapshotReply) {
            this.installSnapshotReply = installSnapshotReply;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.installSnapshotReply.getTerm());
            out.writeObject(this.installSnapshotReply.followerId);
            out.writeInt(this.installSnapshotReply.chunkIndex);
            out.writeBoolean(this.installSnapshotReply.success);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            long term = in.readLong();
            String followerId = (String)in.readObject();
            int chunkIndex = in.readInt();
            boolean success = in.readBoolean();
            this.installSnapshotReply = new InstallSnapshotReply(term, followerId, chunkIndex, success);
        }

        private Object readResolve() {
            return this.installSnapshotReply;
        }
    }
}

