/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public final class ServerInfo {
    private final @NonNull String id;
    private final boolean isVoting;

    public ServerInfo(@NonNull String id, boolean isVoting) {
        this.id = Objects.requireNonNull(id);
        this.isVoting = isVoting;
    }

    public @NonNull String getId() {
        return this.id;
    }

    public boolean isVoting() {
        return this.isVoting;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Boolean.hashCode(this.isVoting);
        result = 31 * result + this.id.hashCode();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ServerInfo)) return false;
        ServerInfo other = (ServerInfo)obj;
        if (this.isVoting != other.isVoting) return false;
        if (!this.id.equals(other.id)) return false;
        return true;
    }

    public String toString() {
        return "ServerInfo [id=" + this.id + ", isVoting=" + this.isVoting + "]";
    }
}

