/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.opendaylight.controller.cluster.raft.persisted.LegacySerializable;
import org.opendaylight.controller.cluster.raft.persisted.UT;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class UpdateElectionTerm
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long currentTerm;
    private final String votedFor;

    public UpdateElectionTerm(long currentTerm, String votedFor) {
        this.currentTerm = currentTerm;
        this.votedFor = votedFor;
    }

    public final long getCurrentTerm() {
        return this.currentTerm;
    }

    public final String getVotedFor() {
        return this.votedFor;
    }

    public final Object writeReplace() {
        return new UT(this);
    }

    public final String toString() {
        return "UpdateElectionTerm [currentTerm=" + this.currentTerm + ", votedFor=" + this.votedFor + "]";
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private UpdateElectionTerm updateElectionTerm = null;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.updateElectionTerm.currentTerm);
            out.writeObject(this.updateElectionTerm.votedFor);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.updateElectionTerm = new Legacy(in.readLong(), (String)in.readObject());
        }

        private Object readResolve() {
            return this.updateElectionTerm;
        }
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static final class Legacy
    extends UpdateElectionTerm
    implements LegacySerializable {
        private static final long serialVersionUID = 1L;

        Legacy(long currentTerm, String votedFor) {
            super(currentTerm, votedFor);
        }
    }
}

