/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FluentFuture;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractIdentifiable;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactoryConfiguration;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangIRSchemaSource;
import org.opendaylight.yangtools.yang.parser.api.YangParser;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.repo.DependencyResolver;
import org.opendaylight.yangtools.yang.parser.repo.RevisionDependencyResolver;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangModelDependencyInfo;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AssembleSources
implements AsyncFunction<List<YangIRSchemaSource>, EffectiveModelContext> {
    private static final Logger LOG = LoggerFactory.getLogger(AssembleSources.class);
    private final @NonNull Function<YangIRSchemaSource, SourceIdentifier> getIdentifier;
    private final @NonNull SchemaContextFactoryConfiguration config;
    private final @NonNull YangParserFactory parserFactory;

    AssembleSources(@NonNull YangParserFactory parserFactory, @NonNull SchemaContextFactoryConfiguration config) {
        this.parserFactory = parserFactory;
        this.config = config;
        switch (config.getStatementParserMode()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DEFAULT_MODE: 
        }
        this.getIdentifier = AbstractIdentifiable::getIdentifier;
    }

    public FluentFuture<EffectiveModelContext> apply(List<YangIRSchemaSource> sources) throws SchemaResolutionException, ReactorException {
        EffectiveModelContext schemaContext;
        ImmutableMap srcs = Maps.uniqueIndex(sources, this.getIdentifier);
        Map deps = Maps.transformValues((Map)srcs, YangModelDependencyInfo::forIR);
        LOG.debug("Resolving dependency reactor {}", (Object)deps);
        switch (this.config.getStatementParserMode()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DEFAULT_MODE: 
        }
        RevisionDependencyResolver res = RevisionDependencyResolver.create(deps);
        if (!res.getUnresolvedSources().isEmpty()) {
            LOG.debug("Omitting models {} due to unsatisfied imports {}", res.getUnresolvedSources(), res.getUnsatisfiedImports());
            throw new SchemaResolutionException("Failed to resolve required models", res.getResolvedSources(), res.getUnsatisfiedImports());
        }
        YangParser parser = this.parserFactory.createParser(((DependencyResolver)res).parserConfig());
        this.config.getSupportedFeatures().ifPresent(arg_0 -> ((YangParser)parser).setSupportedFeatures(arg_0));
        this.config.getModulesDeviatedByModules().ifPresent(arg_0 -> ((YangParser)parser).setModulesWithSupportedDeviations(arg_0));
        for (Map.Entry entry : srcs.entrySet()) {
            try {
                parser.addSource((SchemaSourceRepresentation)entry.getValue());
            }
            catch (IOException | YangSyntaxErrorException e) {
                throw new SchemaResolutionException("Failed to add source " + entry.getKey(), e);
            }
        }
        try {
            schemaContext = parser.buildEffectiveModel();
        }
        catch (YangParserException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ReactorException) {
                ReactorException re = (ReactorException)throwable;
                throw new SchemaResolutionException("Failed to resolve required models", re.getSourceIdentifier(), (Throwable)e);
            }
            throw new SchemaResolutionException("Failed to resolve required models", (Throwable)e);
        }
        return FluentFutures.immediateFluentFuture((Object)schemaContext);
    }
}

