/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReactorStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OriginalStmtCtx<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends StatementContextBase<A, D, E> {
    private static final Logger LOG = LoggerFactory.getLogger(OriginalStmtCtx.class);
    private final @NonNull StatementSourceReference ref;
    private List<ReactorStmtCtx<?, ?, ?>> effective = ImmutableList.of();

    OriginalStmtCtx(OriginalStmtCtx<A, D, E> original) {
        super(original);
        this.ref = original.ref;
    }

    OriginalStmtCtx(StatementDefinitionContext<A, D, E> def, StatementSourceReference ref) {
        super(def);
        this.ref = Objects.requireNonNull(ref);
    }

    OriginalStmtCtx(StatementDefinitionContext<A, D, E> def, StatementSourceReference ref, CopyType copyType) {
        super(def, copyType);
        this.ref = Objects.requireNonNull(ref);
    }

    public final StatementSourceReference sourceReference() {
        return this.ref;
    }

    public final Optional<StmtContext<A, D, E>> getOriginalCtx() {
        return Optional.empty();
    }

    public final Optional<StmtContext<A, D, E>> getPreviousCopyCtx() {
        return Optional.empty();
    }

    public final Collection<? extends StmtContext.Mutable<?, ?, ?>> mutableEffectiveSubstatements() {
        return OriginalStmtCtx.mutableEffectiveSubstatements(this.effective);
    }

    public final void removeStatementFromEffectiveSubstatements(StatementDefinition statementDef) {
        this.effective = OriginalStmtCtx.removeStatementFromEffectiveSubstatements(this.effective, statementDef);
    }

    public final void removeStatementFromEffectiveSubstatements(StatementDefinition statementDef, String statementArg) {
        this.effective = OriginalStmtCtx.removeStatementFromEffectiveSubstatements(this.effective, statementDef, statementArg);
    }

    public final void addEffectiveSubstatement(StmtContext.Mutable<?, ?, ?> substatement) {
        this.effective = this.addEffectiveSubstatement(this.effective, substatement);
        OriginalStmtCtx.afterAddEffectiveSubstatement(substatement);
    }

    @Override
    final void addEffectiveSubstatementsImpl(Collection<? extends StmtContext.Mutable<?, ?, ?>> statements) {
        this.effective = this.addEffectiveSubstatementsImpl(this.effective, statements);
    }

    @Override
    final Iterator<ReactorStmtCtx<?, ?, ?>> effectiveChildrenToComplete() {
        return this.effective.iterator();
    }

    @Override
    final Stream<? extends @NonNull ReactorStmtCtx<?, ?, ?>> streamEffective() {
        return this.effective.stream().filter(StmtContext::isSupportedToBuildEffective);
    }

    @Override
    final OriginalStmtCtx<A, D, E> unmodifiedEffectiveSource() {
        return this;
    }

    @Override
    final boolean hasEmptySubstatements() {
        return this.effective.isEmpty() && this.mutableDeclaredSubstatements().isEmpty();
    }

    @Override
    final boolean noSensitiveSubstatements() {
        return this.hasEmptySubstatements() || OriginalStmtCtx.noSensitiveSubstatements(this.effective) && OriginalStmtCtx.noSensitiveSubstatements(this.mutableDeclaredSubstatements());
    }

    @Override
    final void markNoParentRef() {
        OriginalStmtCtx.markNoParentRef(this.mutableDeclaredSubstatements());
        OriginalStmtCtx.markNoParentRef(this.effective);
    }

    @Override
    final int sweepSubstatements() {
        Collection<StatementContextBase<?, ?, ?>> declared = this.mutableDeclaredSubstatements();
        OriginalStmtCtx.sweep(declared);
        OriginalStmtCtx.sweep(this.effective);
        int count = OriginalStmtCtx.countUnswept(declared) + OriginalStmtCtx.countUnswept(this.effective);
        if (count != 0) {
            LOG.debug("{} children left to sweep from {}", (Object)count, (Object)this);
        }
        this.effective = null;
        this.dropDeclaredSubstatements();
        return count;
    }

    abstract void dropDeclaredSubstatements();

    void declarationFinished(ModelProcessingPhase phase) {
        this.finishDeclaration(phase);
    }

    final void finishDeclaration(ModelProcessingPhase phase) {
        this.definition().onDeclarationFinished(this, phase);
    }

    final OriginalStmtCtx<?, ?, ?> getResumedSubstatement() {
        List local = (List)Verify.verifyNotNull(this.effective);
        Verify.verify((!local.isEmpty() ? 1 : 0) != 0, (String)"Unexpected empty statements", (Object[])new Object[0]);
        ReactorStmtCtx ret = (ReactorStmtCtx)local.get(0);
        Verify.verify((boolean)(ret instanceof OriginalStmtCtx), (String)"Unexpected statement %s", (Object)ret);
        return (OriginalStmtCtx)ret;
    }
}

