/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import java.util.List;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeSchemaTreeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.KeyGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ListGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.rt.DefaultNotificationRuntimeType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.NotificationRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class NotificationGenerator
extends CompositeSchemaTreeGenerator<NotificationEffectiveStatement, NotificationRuntimeType> {
    NotificationGenerator(NotificationEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterSchemaTree((QName)((NotificationEffectiveStatement)this.statement()).argument());
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.addImplementsType((Type)BindingTypes.DATA_OBJECT);
        builder.addImplementsType(this.notificationType(builder, builderFactory));
        NotificationGenerator.addAugmentable(builder);
        this.addUsesInterfaces(builder, builderFactory);
        NotificationGenerator.addConcreteInterfaceMethods(builder);
        this.addGetterMethods(builder, builderFactory);
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, this.localName());
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        return builder.build();
    }

    @Override
    void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }

    @Override
    CompositeRuntimeTypeBuilder<NotificationEffectiveStatement, NotificationRuntimeType> createBuilder(NotificationEffectiveStatement statement) {
        return new CompositeRuntimeTypeBuilder<NotificationEffectiveStatement, NotificationRuntimeType>(statement){

            @Override
            NotificationRuntimeType build(GeneratedType type, NotificationEffectiveStatement statement, List<RuntimeType> children, List<AugmentRuntimeType> augments) {
                return new DefaultNotificationRuntimeType(type, statement, children, augments);
            }
        };
    }

    private Type notificationType(GeneratedTypeBuilder builder, TypeBuilderFactory builderFactory) {
        KeyGenerator keyGen;
        AbstractCompositeGenerator<?, ?> parent = this.getParent();
        if (parent instanceof ModuleGenerator) {
            return BindingTypes.notification((Type)builder);
        }
        Type parentType = Type.of((JavaTypeName)parent.typeName());
        if (parent instanceof ListGenerator && (keyGen = ((ListGenerator)parent).keyGenerator()) != null) {
            return BindingTypes.keyedListNotification((Type)builder, (Type)parentType, (Type)keyGen.getGeneratedType(builderFactory));
        }
        return BindingTypes.instanceNotification((Type)builder, (Type)parentType);
    }
}

