/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementOrigin;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;

final class TargetAugmentEffectiveStatement
implements AugmentEffectiveStatement,
AugmentationSchemaNode {
    private final @NonNull List<EffectiveStatement<?, ?>> substatements;
    private final @NonNull AugmentEffectiveStatement delegate;
    private final @NonNull AugmentationSchemaNode schemaDelegate;

    TargetAugmentEffectiveStatement(AugmentEffectiveStatement augment, SchemaTreeAwareEffectiveStatement<?, ?> target, ImmutableList<EffectiveStatement<?, ?>> substatements) {
        this.delegate = Objects.requireNonNull(augment);
        Verify.verify((boolean)(augment instanceof AugmentationSchemaNode), (String)"Unsupported augment implementation %s", (Object)augment);
        this.schemaDelegate = (AugmentationSchemaNode)augment;
        this.substatements = (List)Objects.requireNonNull(substatements);
    }

    @NonNull AugmentEffectiveStatement delegate() {
        return this.delegate;
    }

    public AugmentStatement getDeclared() {
        return (AugmentStatement)this.delegate.getDeclared();
    }

    public SchemaNodeIdentifier argument() {
        return (SchemaNodeIdentifier)this.delegate.argument();
    }

    public StatementOrigin statementOrigin() {
        return this.delegate.statementOrigin();
    }

    public List<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return this.substatements;
    }

    public Collection<SchemaTreeEffectiveStatement<?>> schemaTreeNodes() {
        return this.collectEffectiveSubstatements(SchemaTreeEffectiveStatement.class);
    }

    public Optional<SchemaTreeEffectiveStatement<?>> findSchemaTreeNode(QName qname) {
        return this.streamEffectiveSubstatements(SchemaTreeEffectiveStatement.class).filter(stmt -> qname.equals(stmt.argument())).findAny();
    }

    public Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
        return this.schemaDelegate.getTypeDefinitions();
    }

    public Collection<? extends DataSchemaNode> getChildNodes() {
        return Collections2.filter(this.substatements, DataSchemaNode.class::isInstance);
    }

    public Collection<? extends GroupingDefinition> getGroupings() {
        return this.schemaDelegate.getGroupings();
    }

    public DataSchemaNode dataChildByName(QName name) {
        return this.getChildNodes().stream().filter(child -> name.equals((Object)child.getQName())).findFirst().orElse(null);
    }

    public Collection<? extends UsesNode> getUses() {
        return this.schemaDelegate.getUses();
    }

    public Collection<? extends NotificationDefinition> getNotifications() {
        return Collections2.filter(this.substatements, NotificationDefinition.class::isInstance);
    }

    public Collection<? extends ActionDefinition> getActions() {
        return Collections2.filter(this.substatements, ActionDefinition.class::isInstance);
    }

    public Optional<? extends YangXPathExpression.QualifiedBound> getWhenCondition() {
        return this.schemaDelegate.getWhenCondition();
    }

    public @NonNull Status getStatus() {
        return this.schemaDelegate.getStatus();
    }

    public Optional<String> getDescription() {
        return this.schemaDelegate.getDescription();
    }

    public Optional<String> getReference() {
        return this.schemaDelegate.getReference();
    }

    public AugmentEffectiveStatement asEffectiveStatement() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("delegate", (Object)this.delegate).add("substatements", this.substatements.size()).toString();
    }
}

