/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.stream;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;

public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static Optional<NormalizedNode> readNormalizedNode(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(NormalizedNodeDataInput.newDataInput((DataInput)in).readNormalizedNode());
    }

    public static void writeNormalizedNode(DataOutput out, @Nullable NormalizedNode node) throws IOException {
        SerializationUtils.writeNormalizedNode(out, NormalizedNodeStreamVersion.MAGNESIUM, node);
    }

    public static void writeNormalizedNode(DataOutput out, NormalizedNodeStreamVersion version, @Nullable NormalizedNode node) throws IOException {
        if (node != null) {
            out.writeBoolean(true);
            try (NormalizedNodeDataOutput stream = version.newDataOutput(out);){
                stream.writeNormalizedNode(node);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public static YangInstanceIdentifier readPath(DataInput in) throws IOException {
        return NormalizedNodeDataInput.newDataInput((DataInput)in).readYangInstanceIdentifier();
    }

    public static void writePath(DataOutput out, @NonNull YangInstanceIdentifier path) throws IOException {
        SerializationUtils.writePath(out, NormalizedNodeStreamVersion.MAGNESIUM, path);
    }

    public static void writePath(DataOutput out, NormalizedNodeStreamVersion version, @NonNull YangInstanceIdentifier path) throws IOException {
        try (NormalizedNodeDataOutput stream = version.newDataOutput(out);){
            stream.writeYangInstanceIdentifier(path);
        }
    }

    public static <T> void readNodeAndPath(DataInput in, T instance, Applier<T> applier) throws IOException {
        NormalizedNodeDataInput stream = NormalizedNodeDataInput.newDataInput((DataInput)in);
        NormalizedNode node = stream.readNormalizedNode();
        YangInstanceIdentifier path = stream.readYangInstanceIdentifier();
        applier.apply(instance, path, node);
    }

    public static void writeNodeAndPath(DataOutput out, NormalizedNodeStreamVersion version, YangInstanceIdentifier path, NormalizedNode node) throws IOException {
        try (NormalizedNodeDataOutput stream = version.newDataOutput(out);){
            stream.writeNormalizedNode(node);
            stream.writeYangInstanceIdentifier(path);
        }
    }

    public static void writeNodeAndPath(DataOutput out, YangInstanceIdentifier path, NormalizedNode node) throws IOException {
        SerializationUtils.writeNodeAndPath(out, NormalizedNodeStreamVersion.MAGNESIUM, path, node);
    }

    public static <T> void readPathAndNode(DataInput in, T instance, Applier<T> applier) throws IOException {
        NormalizedNodeDataInput stream = NormalizedNodeDataInput.newDataInput((DataInput)in);
        YangInstanceIdentifier path = stream.readYangInstanceIdentifier();
        NormalizedNode node = stream.readNormalizedNode();
        applier.apply(instance, path, node);
    }

    public static void writePathAndNode(DataOutput out, NormalizedNodeStreamVersion version, YangInstanceIdentifier path, NormalizedNode node) throws IOException {
        try (NormalizedNodeDataOutput stream = version.newDataOutput(out);){
            stream.writeYangInstanceIdentifier(path);
            stream.writeNormalizedNode(node);
        }
    }

    public static void writePathAndNode(DataOutput out, YangInstanceIdentifier path, NormalizedNode node) throws IOException {
        SerializationUtils.writePathAndNode(out, NormalizedNodeStreamVersion.MAGNESIUM, path, node);
    }

    @FunctionalInterface
    public static interface Applier<T> {
        public void apply(T var1, YangInstanceIdentifier var2, NormalizedNode var3);
    }
}

