/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.io.DirectByteBufferPool$;
import akka.remote.artery.ArteryTransport$;
import akka.remote.artery.EnvelopeBuffer$;
import akka.remote.artery.HeaderBuilder;
import akka.remote.artery.HeaderBuilderImpl;
import akka.remote.artery.OutboundEnvelope;
import akka.util.OptionVal$;
import akka.util.Unsafe;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005mvAB\u001c9\u0011\u0003QdH\u0002\u0004Aq!\u0005!(\u0011\u0005\u0006\u0011\u0006!\tA\u0013\u0005\b\u0017\u0006\u0011\r\u0011\"\u0001M\u0011\u0019\u0001\u0016\u0001)A\u0005\u001b\"9\u0011+\u0001b\u0001\n\u0003a\u0005B\u0002*\u0002A\u0003%Q\nC\u0004T\u0003\t\u0007I\u0011\u0001+\t\ra\u000b\u0001\u0015!\u0003V\u0011\u001dI\u0016A1A\u0005\u00021CaAW\u0001!\u0002\u0013i\u0005bB.\u0002\u0005\u0004%\t\u0001\u0014\u0005\u00079\u0006\u0001\u000b\u0011B'\t\u000fu\u000b!\u0019!C\u0001\u0019\"1a,\u0001Q\u0001\n5CqaX\u0001C\u0002\u0013\u0005A\n\u0003\u0004a\u0003\u0001\u0006I!\u0014\u0005\bC\u0006\u0011\r\u0011\"\u0001M\u0011\u0019\u0011\u0017\u0001)A\u0005\u001b\"91-\u0001b\u0001\n\u0003a\u0005B\u00023\u0002A\u0003%Q\nC\u0004f\u0003\t\u0007I\u0011\u0001'\t\r\u0019\f\u0001\u0015!\u0003N\u0011\u001d9\u0017A1A\u0005\u00021Ca\u0001[\u0001!\u0002\u0013i\u0005bB5\u0002\u0005\u0004%\t\u0001\u0014\u0005\u0007U\u0006\u0001\u000b\u0011B'\t\u000f-\f!\u0019!C\u0001\u0019\"1A.\u0001Q\u0001\n53Q\u0001\u0011\u001d\u0003u5D\u0001B\\\u000f\u0003\u0006\u0004%\ta\u001c\u0005\tqv\u0011\t\u0011)A\u0005a\")\u0001*\bC\u0001s\"9A0\bb\u0001\n\u0003i\bbBA\t;\u0001\u0006IA \u0005\n\u0003'i\u0002\u0019!C\u0005\u0003+A\u0011\"a\t\u001e\u0001\u0004%I!!\n\t\u0011\u0005ER\u0004)Q\u0005\u0003/A\u0011\"a\r\u001e\u0001\u0004%I!!\u000e\t\u0013\u0005}R\u00041A\u0005\n\u0005\u0005\u0003\u0002CA#;\u0001\u0006K!a\u000e\t\u0011\u0005\u001dS\u00041A\u0005\n1C\u0011\"!\u0013\u001e\u0001\u0004%I!a\u0013\t\u000f\u0005=S\u0004)Q\u0005\u001b\"1\u0011\u0011K\u000f\u0005\u00021Cq!a\u0015\u001e\t\u0003\t)\u0006C\u0004\u0002\\u!\t!!\u0018\t\u000f\u0005mS\u0004\"\u0001\u0002j!9\u0011qO\u000f\u0005\u0002\u0005e\u0004bBA?;\u0011%\u0011q\u0010\u0005\b\u00037kB\u0011BAO\u0011\u001d\ty*\bC\u0005\u0003CCq!a+\u001e\t\u0013\ti\u000bC\u0004\u00024v!\t!!.\t\u000f\u0005]V\u0004\"\u0001\u0002:\u0006qQI\u001c<fY>\u0004XMQ;gM\u0016\u0014(BA\u001d;\u0003\u0019\t'\u000f^3ss*\u00111\bP\u0001\u0007e\u0016lw\u000e^3\u000b\u0003u\nA!Y6lCB\u0011q(A\u0007\u0002q\tqQI\u001c<fY>\u0004XMQ;gM\u0016\u00148CA\u0001C!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001?\u0003-!\u0016m\u001a+za\u0016l\u0015m]6\u0016\u00035\u0003\"a\u0011(\n\u0005=#%aA%oi\u0006aA+Y4UsB,W*Y:lA\u0005aA+Y4WC2,X-T1tW\u0006iA+Y4WC2,X-T1tW\u0002\n1#T3uC\u0012\fG/\u0019)sKN,g\u000e\u001e$mC\u001e,\u0012!\u0016\t\u0003\u007fYK!a\u0016\u001d\u0003\u0011\tKH/\u001a$mC\u001e\fA#T3uC\u0012\fG/\u0019)sKN,g\u000e\u001e$mC\u001e\u0004\u0013!\u0004,feNLwN\\(gMN,G/\u0001\bWKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\u0002\u0017\u0019c\u0017mZ:PM\u001a\u001cX\r^\u0001\r\r2\fwm](gMN,G\u000fI\u0001&\u0003\u000e$xN\u001d*fM\u000e{W\u000e\u001d:fgNLwN\u001c+bE2,g+\u001a:tS>twJ\u001a4tKR\fa%Q2u_J\u0014VMZ\"p[B\u0014Xm]:j_:$\u0016M\u00197f-\u0016\u00148/[8o\u001f\u001a47/\u001a;!\u0003)\u001aE.Y:t\u001b\u0006t\u0017NZ3ti\u000e{W\u000e\u001d:fgNLwN\u001c+bE2,g+\u001a:tS>twJ\u001a4tKR\f1f\u00117bgNl\u0015M\\5gKN$8i\\7qe\u0016\u001c8/[8o)\u0006\u0014G.\u001a,feNLwN\\(gMN,G\u000fI\u0001\n+&$wJ\u001a4tKR\f!\"V5e\u001f\u001a47/\u001a;!\u0003A\u0019VM]5bY&TXM](gMN,G/A\tTKJL\u0017\r\\5{KJ|eMZ:fi\u0002\nqcU3oI\u0016\u0014\u0018i\u0019;peJ+g\rV1h\u001f\u001a47/\u001a;\u00021M+g\u000eZ3s\u0003\u000e$xN\u001d*fMR\u000bwm\u00144gg\u0016$\b%\u0001\u000eSK\u000eL\u0007/[3oi\u0006\u001bGo\u001c:SK\u001a$\u0016mZ(gMN,G/A\u000eSK\u000eL\u0007/[3oi\u0006\u001bGo\u001c:SK\u001a$\u0016mZ(gMN,G\u000fI\u0001\u0017\u00072\f7o]'b]&4Wm\u001d;UC\u001e|eMZ:fi\u000692\t\\1tg6\u000bg.\u001b4fgR$\u0016mZ(gMN,G\u000fI\u0001)\u001b\u0016$\u0018\rZ1uC\u000e{g\u000e^1j]\u0016\u0014\u0018I\u001c3MSR,'/\u00197TK\u000e$\u0018n\u001c8PM\u001a\u001cX\r^\u0001*\u001b\u0016$\u0018\rZ1uC\u000e{g\u000e^1j]\u0016\u0014\u0018I\u001c3MSR,'/\u00197TK\u000e$\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\u0014\u0005u\u0011\u0015A\u00032zi\u0016\u0014UO\u001a4feV\t\u0001\u000f\u0005\u0002rm6\t!O\u0003\u0002ti\u0006\u0019a.[8\u000b\u0003U\fAA[1wC&\u0011qO\u001d\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018a\u00032zi\u0016\u0014UO\u001a4fe\u0002\"\"A_>\u0011\u0005}j\u0002\"\u00028!\u0001\u0004\u0001\u0018aC1fe>t')\u001e4gKJ,\u0012A \t\u0004\u007f\u00065QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\b\u0005%\u0011AB1he>t\u0017M\u0003\u0002\u0002\f\u0005\u0019qN]4\n\t\u0005=\u0011\u0011\u0001\u0002\r+:\u001c\u0018MZ3Ck\u001a4WM]\u0001\rC\u0016\u0014xN\u001c\"vM\u001a,'\u000fI\u0001\rY&$XM]1m\u0007\"\f'o]\u000b\u0003\u0003/\u0001RaQA\r\u0003;I1!a\u0007E\u0005\u0015\t%O]1z!\r\u0019\u0015qD\u0005\u0004\u0003C!%\u0001B\"iCJ\f\u0001\u0003\\5uKJ\fGn\u00115beN|F%Z9\u0015\t\u0005\u001d\u0012Q\u0006\t\u0004\u0007\u0006%\u0012bAA\u0016\t\n!QK\\5u\u0011%\ty\u0003JA\u0001\u0002\u0004\t9\"A\u0002yIE\nQ\u0002\\5uKJ\fGn\u00115beN\u0004\u0013\u0001\u00047ji\u0016\u0014\u0018\r\u001c\"zi\u0016\u001cXCAA\u001c!\u0015\u0019\u0015\u0011DA\u001d!\r\u0019\u00151H\u0005\u0004\u0003{!%\u0001\u0002\"zi\u0016\f\u0001\u0003\\5uKJ\fGNQ=uKN|F%Z9\u0015\t\u0005\u001d\u00121\t\u0005\n\u0003_9\u0013\u0011!a\u0001\u0003o\tQ\u0002\\5uKJ\fGNQ=uKN\u0004\u0013!C0tiJ,\u0017-\\%e\u00035y6\u000f\u001e:fC6LEm\u0018\u0013fcR!\u0011qEA'\u0011!\tyCKA\u0001\u0002\u0004i\u0015AC0tiJ,\u0017-\\%eA\u0005A1\u000f\u001e:fC6LE-A\u0006tKR\u001cFO]3b[&#G\u0003BA\u0014\u0003/Ba!!\u0017.\u0001\u0004i\u0015a\u00038foN#(/Z1n\u0013\u0012\f1b\u001e:ji\u0016DU-\u00193feR!\u0011qEA0\u0011\u001d\t\tG\fa\u0001\u0003G\n\u0011\u0001\u001b\t\u0004\u007f\u0005\u0015\u0014bAA4q\ti\u0001*Z1eKJ\u0014U/\u001b7eKJ$b!a\n\u0002l\u00055\u0004bBA1_\u0001\u0007\u00111\r\u0005\b\u0003_z\u0003\u0019AA9\u0003\tyW\rE\u0002@\u0003gJ1!!\u001e9\u0005AyU\u000f\u001e2pk:$WI\u001c<fY>\u0004X-A\u0006qCJ\u001cX\rS3bI\u0016\u0014H\u0003BA\u0014\u0003wBq!!\u00191\u0001\u0004\t\u0019'A\u0006f[B$\u00180Q:Ok2dG\u0003BAA\u0003/\u0003B!a!\u0002\u0012:!\u0011QQAG!\r\t9\tR\u0007\u0003\u0003\u0013S1!a#J\u0003\u0019a$o\\8u}%\u0019\u0011q\u0012#\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019*!&\u0003\rM#(/\u001b8h\u0015\r\ty\t\u0012\u0005\b\u00033\u000b\u0004\u0019AAA\u0003\u0005\u0019\u0018a\u0003:fC\u0012d\u0015\u000e^3sC2$\"!!!\u0002\u0019]\u0014\u0018\u000e^3MSR,'/\u00197\u0015\r\u0005\u001d\u00121UAT\u0011\u0019\t)k\ra\u0001\u001b\u0006IA/Y4PM\u001a\u001cX\r\u001e\u0005\b\u0003S\u001b\u0004\u0019AAA\u0003\u001da\u0017\u000e^3sC2\f\u0001$\u001a8tkJ,G*\u001b;fe\u0006d7\t[1sg2+gn\u001a;i)\u0011\t9#a,\t\r\u0005EF\u00071\u0001N\u0003\u0019aWM\\4uQ\u0006ABO]=DY\u0016\fg\u000eR5sK\u000e$()\u001f;f\u0005V4g-\u001a:\u0015\u0005\u0005\u001d\u0012\u0001B2paf$\u0012A\u001f")
public final class EnvelopeBuffer {
    private final ByteBuffer byteBuffer;
    private final UnsafeBuffer aeronBuffer;
    private char[] literalChars;
    private byte[] literalBytes;
    private int _streamId;

    public static int MetadataContainerAndLiteralSectionOffset() {
        return EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset();
    }

    public static int ClassManifestTagOffset() {
        return EnvelopeBuffer$.MODULE$.ClassManifestTagOffset();
    }

    public static int RecipientActorRefTagOffset() {
        return EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset();
    }

    public static int SenderActorRefTagOffset() {
        return EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset();
    }

    public static int SerializerOffset() {
        return EnvelopeBuffer$.MODULE$.SerializerOffset();
    }

    public static int UidOffset() {
        return EnvelopeBuffer$.MODULE$.UidOffset();
    }

    public static int ClassManifestCompressionTableVersionOffset() {
        return EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset();
    }

    public static int ActorRefCompressionTableVersionOffset() {
        return EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset();
    }

    public static int FlagsOffset() {
        return EnvelopeBuffer$.MODULE$.FlagsOffset();
    }

    public static int VersionOffset() {
        return EnvelopeBuffer$.MODULE$.VersionOffset();
    }

    public static byte MetadataPresentFlag() {
        return EnvelopeBuffer$.MODULE$.MetadataPresentFlag();
    }

    public static int TagValueMask() {
        return EnvelopeBuffer$.MODULE$.TagValueMask();
    }

    public static int TagTypeMask() {
        return EnvelopeBuffer$.MODULE$.TagTypeMask();
    }

    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    public UnsafeBuffer aeronBuffer() {
        return this.aeronBuffer;
    }

    private char[] literalChars() {
        return this.literalChars;
    }

    private void literalChars_$eq(char[] x$1) {
        this.literalChars = x$1;
    }

    private byte[] literalBytes() {
        return this.literalBytes;
    }

    private void literalBytes_$eq(byte[] x$1) {
        this.literalBytes = x$1;
    }

    private int _streamId() {
        return this._streamId;
    }

    private void _streamId_$eq(int x$1) {
        this._streamId = x$1;
    }

    public int streamId() {
        if (this._streamId() == -1) {
            throw new IllegalStateException("StreamId was not set");
        }
        return this._streamId();
    }

    public void setStreamId(int newStreamId) {
        this._streamId_$eq(newStreamId);
    }

    public void writeHeader(HeaderBuilder h) {
        this.writeHeader(h, null);
    }

    public void writeHeader(HeaderBuilder h, OutboundEnvelope oe) {
        Object object;
        Object object2;
        Object object3;
        HeaderBuilderImpl header = (HeaderBuilderImpl)h;
        this.byteBuffer().clear();
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.VersionOffset(), header.version());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.FlagsOffset(), header.flags());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset(), header.outboundActorRefCompression().version());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset(), header.outboundClassManifestCompression().version());
        this.byteBuffer().putLong(EnvelopeBuffer$.MODULE$.UidOffset(), header.uid());
        this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.SerializerOffset(), header.serializer());
        this.byteBuffer().position(EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset());
        if (OptionVal$.MODULE$.isDefined$extension(header._remoteInstruments())) {
            OptionVal$.MODULE$.get$extension(header._remoteInstruments()).serialize(OptionVal$.MODULE$.apply(oe), this.byteBuffer());
            if (this.byteBuffer().position() != EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset()) {
                header.setFlag(EnvelopeBuffer$.MODULE$.MetadataPresentFlag());
                object3 = this.byteBuffer().put(EnvelopeBuffer$.MODULE$.FlagsOffset(), header.flags());
            } else {
                object3 = BoxedUnit.UNIT;
            }
        } else {
            object3 = BoxedUnit.UNIT;
        }
        if (header._senderActorRefIdx() != -1) {
            object2 = this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset(), header._senderActorRefIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
        } else {
            this.writeLiteral(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset(), header._senderActorRef());
            object2 = BoxedUnit.UNIT;
        }
        if (header._recipientActorRefIdx() != -1) {
            object = this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset(), header._recipientActorRefIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
        } else {
            this.writeLiteral(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset(), header._recipientActorRef());
            object = BoxedUnit.UNIT;
        }
        if (header._manifestIdx() != -1) {
            this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset(), header._manifestIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
        } else {
            this.writeLiteral(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset(), header._manifest());
        }
    }

    public void parseHeader(HeaderBuilder h) {
        Object object;
        HeaderBuilderImpl header = (HeaderBuilderImpl)h;
        header.setVersion(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.VersionOffset()));
        if (header.version() > ArteryTransport$.MODULE$.HighestVersion()) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(34).append("Incompatible protocol version [").append(header.version()).append("], ").toString()).append(new StringBuilder(41).append("highest known version for this node is [").append(ArteryTransport$.MODULE$.HighestVersion()).append("]").toString()).toString());
        }
        header.setFlags(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.FlagsOffset()));
        header._inboundActorRefCompressionTableVersion_$eq(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset()));
        header._inboundClassManifestCompressionTableVersion_$eq(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset()));
        header.setUid(this.byteBuffer().getLong(EnvelopeBuffer$.MODULE$.UidOffset()));
        header.setSerializer(this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.SerializerOffset()));
        this.byteBuffer().position(EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset());
        if (header.flag(EnvelopeBuffer$.MODULE$.MetadataPresentFlag())) {
            int totalMetadataLength = this.byteBuffer().getInt();
            object = this.byteBuffer().position(this.byteBuffer().position() + totalMetadataLength);
        } else {
            object = BoxedUnit.UNIT;
        }
        int senderTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset());
        if ((senderTag & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = senderTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._senderActorRef_$eq(null);
            header._senderActorRefIdx_$eq(idx);
        } else {
            header._senderActorRef_$eq(this.emptyAsNull(this.readLiteral()));
        }
        int recipientTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset());
        if ((recipientTag & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = recipientTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._recipientActorRef_$eq(null);
            header._recipientActorRefIdx_$eq(idx);
        } else {
            header._recipientActorRef_$eq(this.emptyAsNull(this.readLiteral()));
        }
        int manifestTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset());
        if ((manifestTag & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = manifestTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._manifest_$eq(null);
            header._manifestIdx_$eq(idx);
        } else {
            header._manifest_$eq(this.readLiteral());
        }
    }

    private String emptyAsNull(String s) {
        String string = s;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? null : s;
    }

    private String readLiteral() {
        String string;
        int length = this.byteBuffer().getShort();
        if (length == 0) {
            string = "";
        } else {
            this.ensureLiteralCharsLength(length);
            char[] chars = this.literalChars();
            byte[] bytes = this.literalBytes();
            this.byteBuffer().get(bytes, 0, length);
            for (int i = 0; i < length; ++i) {
                chars[i] = (char)bytes[i];
            }
            string = String.valueOf(chars, 0, length);
        }
        return string;
    }

    private void writeLiteral(int tagOffset, String literal) {
        block1: {
            int length;
            int n = length = literal == null ? 0 : literal.length();
            if (length > 65535) {
                throw new IllegalArgumentException("Literals longer than 65535 cannot be encoded in the envelope");
            }
            this.byteBuffer().putInt(tagOffset, this.byteBuffer().position());
            this.byteBuffer().putShort((short)length);
            if (length <= 0) break block1;
            this.ensureLiteralCharsLength(length);
            byte[] bytes = this.literalBytes();
            Unsafe.copyUSAsciiStrToBytes(literal, bytes);
            this.byteBuffer().put(bytes, 0, length);
        }
    }

    private void ensureLiteralCharsLength(int length) {
        block0: {
            if (length <= this.literalChars().length) break block0;
            this.literalChars_$eq(new char[length]);
            this.literalBytes_$eq(new byte[length]);
        }
    }

    public void tryCleanDirectByteBuffer() {
        DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(this.byteBuffer());
    }

    public EnvelopeBuffer copy() {
        int p = this.byteBuffer().position();
        this.byteBuffer().rewind();
        byte[] bytes = new byte[this.byteBuffer().remaining()];
        this.byteBuffer().get(bytes);
        ByteBuffer newByteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        newByteBuffer.position(p);
        this.byteBuffer().position(p);
        return new EnvelopeBuffer(newByteBuffer);
    }

    public EnvelopeBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.aeronBuffer = new UnsafeBuffer(byteBuffer);
        this.literalChars = new char[64];
        this.literalBytes = new byte[64];
        this._streamId = -1;
    }
}

