/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.rfc7952.data.api.StreamWriterMetadataExtension;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

@Beta
public abstract class AbstractNodeDataWithSchema<T extends DataSchemaNode> {
    private final T schema;
    private ImmutableMap<QName, Object> attributes;

    public AbstractNodeDataWithSchema(T schema) {
        this.schema = (DataSchemaNode)Objects.requireNonNull(schema);
    }

    public final @NonNull T getSchema() {
        return this.schema;
    }

    public final void setAttributes(ImmutableMap<QName, Object> attributes) {
        Preconditions.checkState((this.attributes == null ? 1 : 0) != 0, (String)"Node '%s' has already set its attributes to %s.", (Object)this.getSchema().getQName(), this.attributes);
        this.attributes = attributes;
    }

    public final ImmutableMap<QName, Object> getAttributes() {
        return this.attributes;
    }

    public final void write(NormalizedNodeStreamWriter writer) throws IOException {
        this.write(writer, (StreamWriterMetadataExtension)writer.getExtensions().getInstance(StreamWriterMetadataExtension.class));
    }

    protected abstract void write(NormalizedNodeStreamWriter var1, @Nullable StreamWriterMetadataExtension var2) throws IOException;

    protected final YangInstanceIdentifier.NodeIdentifier provideNodeIdentifier() {
        return YangInstanceIdentifier.NodeIdentifier.create((QName)this.schema.getQName());
    }

    protected final void writeMetadata(StreamWriterMetadataExtension metaWriter) throws IOException {
        if (metaWriter != null && this.attributes != null && !this.attributes.isEmpty()) {
            metaWriter.metadata(this.attributes);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.schema);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNodeDataWithSchema other = (AbstractNodeDataWithSchema)obj;
        return this.schema.equals(other.schema);
    }
}

