/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtils.class);

    private PropertyUtils() {
    }

    public static int getIntSystemProperty(String propName, int defaultValue) {
        int propValue = defaultValue;
        String strValue = System.getProperty(propName);
        if (!Strings.isNullOrEmpty((String)strValue) && !strValue.trim().isEmpty()) {
            try {
                propValue = Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                LOG.warn("Cannot parse value {} for system property {}, using default {}", new Object[]{strValue, propName, defaultValue});
            }
        }
        return propValue;
    }
}

