/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.eos.dom.simple;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipChangeState;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipState;
import org.opendaylight.mdsal.eos.common.api.GenericEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipCandidateRegistration;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipChange;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListenerRegistration;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipService;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SimpleDOMEntityOwnershipService
implements DOMEntityOwnershipService {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleDOMEntityOwnershipService.class);
    private final @GuardedBy(value={"entities"}) Table<String, YangInstanceIdentifier, DOMEntity> entities = HashBasedTable.create();
    private final @GuardedBy(value={"listeners"}) Multimap<String, DOMEntityOwnershipListener> listeners = ArrayListMultimap.create((int)0, (int)1);
    private final UUID uuid;

    @VisibleForTesting
    SimpleDOMEntityOwnershipService(UUID uuid) {
        this.uuid = Objects.requireNonNull(uuid);
    }

    public SimpleDOMEntityOwnershipService() {
        this(UUID.randomUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMEntityOwnershipCandidateRegistration registerCandidate(DOMEntity entity) throws CandidateAlreadyRegisteredException {
        Table<String, YangInstanceIdentifier, DOMEntity> table = this.entities;
        synchronized (table) {
            DOMEntity prev = (DOMEntity)this.entities.get((Object)entity.getType(), (Object)entity.getIdentifier());
            if (prev != null) {
                throw new CandidateAlreadyRegisteredException((GenericEntity)prev);
            }
            this.entities.put((Object)entity.getType(), (Object)((YangInstanceIdentifier)entity.getIdentifier()), (Object)entity);
            LOG.debug("{}: registered candidate {}", (Object)this.uuid, (Object)entity);
        }
        this.notifyListeners(entity, EntityOwnershipChangeState.LOCAL_OWNERSHIP_GRANTED);
        return new EntityRegistration(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMEntityOwnershipListenerRegistration registerListener(String entityType, DOMEntityOwnershipListener listener) {
        ImmutableList owned;
        Object object = this.entities;
        synchronized (object) {
            owned = ImmutableList.copyOf(this.entities.row((Object)entityType).values());
            LOG.trace("{}: acquired candidates {} for new listener {}", new Object[]{this.uuid, owned, listener});
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.put((Object)entityType, (Object)listener);
        }
        for (DOMEntity entity : owned) {
            this.notifyListener(listener, new DOMEntityOwnershipChange(entity, EntityOwnershipChangeState.LOCAL_OWNERSHIP_GRANTED));
        }
        LOG.debug("{}: registered listener {}", (Object)this.uuid, (Object)listener);
        return new ListenerRegistration(entityType, listener);
    }

    public Optional<EntityOwnershipState> getOwnershipState(DOMEntity forEntity) {
        return this.isCandidateRegistered(forEntity) ? Optional.of(EntityOwnershipState.IS_OWNER) : Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCandidateRegistered(DOMEntity forEntity) {
        Table<String, YangInstanceIdentifier, DOMEntity> table = this.entities;
        synchronized (table) {
            return this.entities.contains((Object)forEntity.getType(), (Object)forEntity.getIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntity(DOMEntity entity) {
        Table<String, YangInstanceIdentifier, DOMEntity> table = this.entities;
        synchronized (table) {
            this.entities.remove((Object)entity.getType(), (Object)entity.getIdentifier());
            LOG.debug("{}: unregistered candidate {}", (Object)this.uuid, (Object)entity);
        }
        this.notifyListeners(entity, EntityOwnershipChangeState.LOCAL_OWNERSHIP_LOST_NO_OWNER);
    }

    private void notifyListener(DOMEntityOwnershipListener listener, DOMEntityOwnershipChange change) {
        try {
            LOG.trace("{} notifying listener {} change {}", new Object[]{this.uuid, listener, change});
            listener.ownershipChanged(change);
        }
        catch (RuntimeException e) {
            LOG.warn("{}: Listener {} change {} failed", new Object[]{this.uuid, listener, change, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(DOMEntity entity, EntityOwnershipChangeState state) {
        ImmutableList snap;
        DOMEntityOwnershipChange change = new DOMEntityOwnershipChange(entity, state);
        Multimap<String, DOMEntityOwnershipListener> multimap = this.listeners;
        synchronized (multimap) {
            snap = ImmutableList.copyOf((Collection)this.listeners.get((Object)entity.getType()));
        }
        for (DOMEntityOwnershipListener listener : snap) {
            this.notifyListener(listener, change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterListener(ListenerRegistration reg) {
        Multimap<String, DOMEntityOwnershipListener> multimap = this.listeners;
        synchronized (multimap) {
            this.listeners.remove((Object)reg.getEntityType(), reg.getInstance());
            LOG.debug("{}: unregistered listener {}", (Object)this.uuid, reg.getInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        MoreObjects.ToStringHelper h = MoreObjects.toStringHelper(SimpleDOMEntityOwnershipService.class).add("uuid", (Object)this.uuid);
        Table<String, YangInstanceIdentifier, DOMEntity> table = this.entities;
        synchronized (table) {
            h.add("entities", this.entities);
        }
        table = this.listeners;
        synchronized (table) {
            h.add("listeners", this.listeners);
        }
        return h.toString();
    }

    private final class EntityRegistration
    extends AbstractObjectRegistration<DOMEntity>
    implements DOMEntityOwnershipCandidateRegistration {
        EntityRegistration(DOMEntity entity) {
            super((Object)entity);
        }

        protected void removeRegistration() {
            SimpleDOMEntityOwnershipService.this.removeEntity((DOMEntity)this.getInstance());
        }
    }

    private final class ListenerRegistration
    extends AbstractObjectRegistration<DOMEntityOwnershipListener>
    implements DOMEntityOwnershipListenerRegistration {
        private final String entityType;

        ListenerRegistration(String entityType, DOMEntityOwnershipListener listener) {
            super((Object)listener);
            this.entityType = Objects.requireNonNull(entityType);
        }

        public String getEntityType() {
            return this.entityType;
        }

        protected void removeRegistration() {
            SimpleDOMEntityOwnershipService.this.unregisterListener(this);
        }
    }
}

