/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.Handlers;
import io.undertow.connector.ByteBufferPool;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionConfigWrapper;
import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.api.SessionPersistenceManager;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.core.ContextClassLoaderSetupAction;
import io.undertow.servlet.core.DeploymentImpl;
import io.undertow.servlet.core.ErrorPages;
import io.undertow.servlet.core.InMemorySessionManagerFactory;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.core.ManagedFilters;
import io.undertow.servlet.core.ManagedListener;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.handlers.ServletHandler;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.servlet.util.InMemorySessionPersistence;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.servlet.DispatcherType;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.SessionCookieConfig;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.xml.parsers.SAXParserFactory;
import org.ops4j.pax.web.service.AuthenticatorService;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.config.LogConfiguration;
import org.ops4j.pax.web.service.spi.config.SessionConfiguration;
import org.ops4j.pax.web.service.spi.model.ContextMetadataModel;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServletContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerKey;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.LoginConfigModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConstraintModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.elements.SessionConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;
import org.ops4j.pax.web.service.spi.model.elements.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.model.events.ServerEvent;
import org.ops4j.pax.web.service.spi.servlet.Default404Servlet;
import org.ops4j.pax.web.service.spi.servlet.DefaultSessionCookieConfig;
import org.ops4j.pax.web.service.spi.servlet.DynamicRegistrations;
import org.ops4j.pax.web.service.spi.servlet.OsgiDynamicServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiInitializedServlet;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContextClassLoader;
import org.ops4j.pax.web.service.spi.servlet.OsgiSessionAttributeListener;
import org.ops4j.pax.web.service.spi.servlet.PreprocessorFilterConfig;
import org.ops4j.pax.web.service.spi.servlet.RegisteringContainerInitializer;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.ClearDynamicRegistrationsChange;
import org.ops4j.pax.web.service.spi.task.ContainerInitializerModelChange;
import org.ops4j.pax.web.service.spi.task.ContextMetadataModelChange;
import org.ops4j.pax.web.service.spi.task.ContextParamsChange;
import org.ops4j.pax.web.service.spi.task.ContextStartChange;
import org.ops4j.pax.web.service.spi.task.ContextStopChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageModelChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageStateChange;
import org.ops4j.pax.web.service.spi.task.EventListenerModelChange;
import org.ops4j.pax.web.service.spi.task.FilterModelChange;
import org.ops4j.pax.web.service.spi.task.FilterStateChange;
import org.ops4j.pax.web.service.spi.task.MimeAndLocaleMappingChange;
import org.ops4j.pax.web.service.spi.task.OpCode;
import org.ops4j.pax.web.service.spi.task.OsgiContextModelChange;
import org.ops4j.pax.web.service.spi.task.SecurityConfigChange;
import org.ops4j.pax.web.service.spi.task.ServletContextModelChange;
import org.ops4j.pax.web.service.spi.task.ServletModelChange;
import org.ops4j.pax.web.service.spi.task.TransactionStateChange;
import org.ops4j.pax.web.service.spi.task.WebSocketModelChange;
import org.ops4j.pax.web.service.spi.task.WelcomeFileModelChange;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.undertow.PaxWebUndertowExtension;
import org.ops4j.pax.web.service.undertow.UndertowSupport;
import org.ops4j.pax.web.service.undertow.configuration.model.Interface;
import org.ops4j.pax.web.service.undertow.configuration.model.IoSubsystem;
import org.ops4j.pax.web.service.undertow.configuration.model.SecurityRealm;
import org.ops4j.pax.web.service.undertow.configuration.model.Server;
import org.ops4j.pax.web.service.undertow.configuration.model.ServletContainer;
import org.ops4j.pax.web.service.undertow.configuration.model.SocketBinding;
import org.ops4j.pax.web.service.undertow.configuration.model.UndertowConfiguration;
import org.ops4j.pax.web.service.undertow.configuration.model.UndertowSubsystem;
import org.ops4j.pax.web.service.undertow.internal.FileSessionPersistence;
import org.ops4j.pax.web.service.undertow.internal.PaxWebFilterInfo;
import org.ops4j.pax.web.service.undertow.internal.PaxWebListenerInfo;
import org.ops4j.pax.web.service.undertow.internal.PaxWebOuterHandlerWrapper;
import org.ops4j.pax.web.service.undertow.internal.PaxWebPreprocessorsHandler;
import org.ops4j.pax.web.service.undertow.internal.PaxWebSecurityHandler;
import org.ops4j.pax.web.service.undertow.internal.PaxWebServletInfo;
import org.ops4j.pax.web.service.undertow.internal.PaxWebSessionIdGenerator;
import org.ops4j.pax.web.service.undertow.internal.UndertowFactory;
import org.ops4j.pax.web.service.undertow.internal.UndertowServerController;
import org.ops4j.pax.web.service.undertow.internal.configuration.ResolvingContentHandler;
import org.ops4j.pax.web.service.undertow.internal.configuration.UnmarshallingContentHandler;
import org.ops4j.pax.web.service.undertow.internal.security.JaasIdentityManager;
import org.ops4j.pax.web.service.undertow.internal.security.PropertiesIdentityManager;
import org.ops4j.pax.web.service.undertow.internal.web.FlexibleErrorPages;
import org.ops4j.pax.web.service.undertow.internal.web.OsgiResourceManager;
import org.ops4j.pax.web.service.undertow.internal.web.OsgiServletContainerInitializerInfo;
import org.ops4j.pax.web.service.undertow.internal.web.UndertowResourceServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

class UndertowServerWrapper
implements BatchVisitor,
UndertowSupport {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowServerWrapper.class);
    private final Bundle paxWebUndertowBundle;
    private final ClassLoader classLoader;
    private final Map<String, UndertowFactory.AcceptingChannelWithAddress> listeners = new HashMap<String, UndertowFactory.AcceptingChannelWithAddress>();
    private final Map<String, XnioWorker> workers = new HashMap<String, XnioWorker>();
    private final Map<String, ByteBufferPool> bufferPools = new HashMap<String, ByteBufferPool>();
    private final Map<Integer, Integer> securePortMapping = new HashMap<Integer, Integer>();
    private HttpHandler rootHandler;
    private PathHandler pathHandler;
    private final UndertowFactory undertowFactory;
    private IdentityManager identityManager;
    private final Set<String> transactions = new HashSet<String>();
    private final Map<String, List<ElementModel<?, ?>>> delayedRemovals = new HashMap();
    private final ServletContainer servletContainer = Servlets.newContainer();
    private final Map<String, PaxWebOuterHandlerWrapper> wrappingHandlers = new HashMap<String, PaxWebOuterHandlerWrapper>();
    private final Map<String, PaxWebPreprocessorsHandler> preprocessorsHandlers = new HashMap<String, PaxWebPreprocessorsHandler>();
    private final Map<String, PaxWebSecurityHandler> securityHandlers = new HashMap<String, PaxWebSecurityHandler>();
    private final Map<String, DeploymentInfo> deploymentInfos = new HashMap<String, DeploymentInfo>();
    private final Map<OsgiContextModel, OsgiServletContext> osgiServletContexts = new HashMap<OsgiContextModel, OsgiServletContext>();
    private final Map<String, TreeSet<OsgiContextModel>> osgiContextModels = new HashMap<String, TreeSet<OsgiContextModel>>();
    private final Map<String, TreeSet<OsgiServletContainerInitializerInfo>> initializers = new HashMap<String, TreeSet<OsgiServletContainerInitializerInfo>>();
    private final Map<String, DynamicRegistrations> dynamicRegistrations = new HashMap<String, DynamicRegistrations>();
    private final Map<String, TreeMap<EventListenerKey, PaxWebListenerInfo>> rankedListeners = new HashMap<String, TreeMap<EventListenerKey, PaxWebListenerInfo>>();
    private final Map<String, List<PaxWebListenerInfo>> orderedListeners = new HashMap<String, List<PaxWebListenerInfo>>();
    private final Configuration configuration;
    private final Default404Servlet default404Servlet = new Default404Servlet(true);
    private SessionCookieConfig defaultSessionCookieConfig = null;
    private Integer defaultSessionTimeout = null;
    private SessionPersistenceManager globalSessionPersistenceManager;
    private UndertowConfiguration undertowConfiguration;
    private final Map<String, FlexibleErrorPages> errorPages = new HashMap<String, FlexibleErrorPages>();
    private final List<EventListenerModel> sessionListenerModels = new ArrayList<EventListenerModel>();
    private final Map<String, TreeMap<OsgiContextModel, SecurityConfigurationModel>> contextSecurityConstraints = new HashMap<String, TreeMap<OsgiContextModel, SecurityConfigurationModel>>();

    UndertowServerWrapper(Configuration config, UndertowFactory undertowFactory, Bundle paxWebUndertowBundle, ClassLoader classLoader) {
        this.configuration = config;
        this.undertowFactory = undertowFactory;
        this.paxWebUndertowBundle = paxWebUndertowBundle;
        this.classLoader = classLoader;
    }

    public void configure() throws Exception {
        LOG.info("Creating Undertow server instance using configuration properties.");
        this.pathHandler = Handlers.path();
        this.rootHandler = this.pathHandler;
        try {
            this.applyUndertowConfiguration();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Problem configuring Undertow server: " + e.getMessage(), e);
        }
        if (this.configuration.logging().isLogNCSAFormatEnabled().booleanValue()) {
            this.configureRequestLog();
        }
        this.verifyListenerConfiguration();
        if (this.defaultSessionCookieConfig == null) {
            this.defaultSessionCookieConfig = this.configuration.session().getDefaultSessionCookieConfig();
        }
        if (this.defaultSessionTimeout == null) {
            this.defaultSessionTimeout = this.configuration.session().getSessionTimeout();
        }
        if (this.globalSessionPersistenceManager == null) {
            File dir = this.configuration.session().getSessionStoreDirectory();
            if (dir != null) {
                LOG.info("Using file session persistence. Location: " + dir.getCanonicalPath());
                this.globalSessionPersistenceManager = new FileSessionPersistence(dir);
            } else {
                LOG.info("Using in-memory session persistence");
                this.globalSessionPersistenceManager = new InMemorySessionPersistence();
            }
        }
    }

    private void applyUndertowConfiguration() throws Exception {
        ServletContainer.PersistentSessionsConfig persistentSessions;
        ByteBufferPool bufferPoolForListener;
        UndertowConfiguration.BindingInfo binding;
        String listenerName;
        SecurityRealm defaultRealm;
        IoSubsystem io;
        File xmlConfig;
        File[] locations = this.configuration.server().getConfigurationFiles();
        URL undertowResource = this.getClass().getResource("/undertow.xml");
        if (locations.length == 0) {
            if (undertowResource == null) {
                LOG.info("No external Undertow configuration files specified. Default/PID configuration will be used.");
            } else {
                LOG.info("Found \"undertow.xml\" resource on the classpath: {}.", (Object)undertowResource);
            }
        } else if (locations.length > 1) {
            LOG.warn("Can't specify Undertow configuration using more than one XML file. Only {} will be used.", (Object)locations[0]);
        } else {
            if (undertowResource != null) {
                LOG.info("Found additional \"undertow.xml\" resource on the classpath: {}, but {} will be used instead.", (Object)undertowResource, (Object)locations[0]);
            }
            LOG.info("Processing Undertow configuration from file: {}", (Object)locations[0]);
        }
        File file = xmlConfig = locations.length > 0 ? locations[0] : null;
        if (xmlConfig != null || undertowResource != null) {
            InputStream stream;
            UnmarshallingContentHandler unmarshallerHandler = new UnmarshallingContentHandler();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            spf.setXIncludeAware(false);
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            xmlReader.setContentHandler(new ResolvingContentHandler(this.configuration.all(), unmarshallerHandler));
            if (xmlConfig != null) {
                LOG.debug("Parsing {}", (Object)xmlConfig);
                stream = new FileInputStream(xmlConfig);
                try {
                    xmlReader.parse(new InputSource(stream));
                }
                finally {
                    stream.close();
                }
            }
            LOG.debug("Parsing {}", (Object)undertowResource);
            stream = undertowResource.openStream();
            try {
                xmlReader.parse(new InputSource(stream));
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            this.undertowConfiguration = unmarshallerHandler.getConfiguration();
        }
        if (this.undertowConfiguration == null) {
            this.undertowConfiguration = new UndertowConfiguration();
        }
        if (this.undertowConfiguration.getInterfaces().size() == 0) {
            Interface iface = new Interface();
            iface.setName("default");
            Iterator<IoSubsystem.BufferPool> address = new Interface.InetAddress();
            ((Interface.InetAddress)((Object)address)).setIp("0.0.0.0");
            iface.getAddresses().add((Interface.InetAddress)((Object)address));
            this.undertowConfiguration.getInterfaces().add(iface);
        }
        if (this.undertowConfiguration.getSocketBindings().size() == 0 && this.configuration.server().isHttpEnabled().booleanValue()) {
            SocketBinding binding2 = new SocketBinding();
            binding2.setName("http");
            binding2.setInterfaceRef("default");
            binding2.setPort(this.configuration.server().getHttpPort());
            this.undertowConfiguration.getSocketBindings().add(binding2);
        }
        if (this.undertowConfiguration.getSubsystem() == null) {
            this.undertowConfiguration.setSubsystem(new UndertowSubsystem());
        }
        if (this.undertowConfiguration.getSubsystem().getServer() == null) {
            this.undertowConfiguration.getSubsystem().setServer(new Server());
        }
        this.undertowConfiguration.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Undertow XML configuration parsed correctly: {}", (Object)this.undertowConfiguration);
        }
        if ((io = this.undertowConfiguration.getIoSubsystem()) != null) {
            for (IoSubsystem.Worker worker : io.getWorkers()) {
                this.workers.put(worker.getName(), this.undertowFactory.createWorker(worker));
            }
            for (IoSubsystem.BufferPool pool : io.getBufferPools()) {
                this.bufferPools.put(pool.getName(), this.undertowFactory.createBufferPool(pool));
            }
        }
        if ((defaultRealm = this.undertowConfiguration.securityRealm("default")) != null) {
            SecurityRealm.JaasAuth jaasAuth = defaultRealm.getAuthentication().getJaas();
            SecurityRealm.PropertiesAuth propertiesAuth = defaultRealm.getAuthentication().getProperties();
            SecurityRealm.UsersAuth usersAuth = defaultRealm.getAuthentication().getUsers();
            if (jaasAuth != null) {
                LOG.info("Creating JAAS Identity Manager");
                String userPrincipalClassName = defaultRealm.getUserPrincipalClassName();
                if (userPrincipalClassName == null || "".equals(userPrincipalClassName.trim())) {
                    userPrincipalClassName = "java.security.Principal";
                }
                LinkedHashSet<String> rolePrincipalClassNames = new LinkedHashSet<String>(defaultRealm.getRolePrincipalClassNames());
                this.identityManager = new JaasIdentityManager(jaasAuth.getName(), userPrincipalClassName, rolePrincipalClassNames);
            } else if (propertiesAuth != null || usersAuth != null) {
                HashMap<String, String> users = new HashMap<String, String>();
                if (propertiesAuth != null) {
                    Properties userProperties = new Properties();
                    LOG.info("Creating Properties Identity Manager using {}", (Object)propertiesAuth.getPath());
                    File userBase = new File(propertiesAuth.getPath());
                    if (!userBase.isFile()) {
                        throw new IllegalArgumentException(userBase.getCanonicalPath() + " is not accessible. Can't load users/groups information.");
                    }
                    try (FileInputStream stream = new FileInputStream(userBase);){
                        userProperties.load(stream);
                        for (String string : userProperties.stringPropertyNames()) {
                            users.put(string, userProperties.getProperty(string));
                        }
                    }
                } else {
                    LOG.info("Creating Properties Identity Manager using XML configuration");
                    for (SecurityRealm.User user : usersAuth.getUsers()) {
                        users.put(user.getUsername(), user.getPassword());
                    }
                }
                this.identityManager = new PropertiesIdentityManager(users);
            }
        }
        if (this.undertowConfiguration.getSubsystem().getServer().getHost() != null) {
            for (Server.Host.Location location : this.undertowConfiguration.getSubsystem().getServer().getHost().getLocations()) {
                String context = location.getName();
                String handlerRef = location.getHandler();
                UndertowSubsystem.FileHandler fileHandler = this.undertowConfiguration.handler(handlerRef);
                if (fileHandler == null) {
                    throw new IllegalArgumentException("No handler with name \"" + location.getHandler() + "\" available for " + location.getName() + " location.");
                }
                File base = new File(fileHandler.getPath());
                if (!base.isDirectory()) {
                    throw new IllegalArgumentException(base.getCanonicalPath() + " is not accessible. Can't configure handler for " + location.getName() + " location.");
                }
                PathResourceManager resourceManager = new PathResourceManager(base.toPath(), (long)fileHandler.getCacheBufferSize().intValue() * (long)fileHandler.getCacheBuffers().intValue(), fileHandler.getCaseSensitive().booleanValue(), fileHandler.getFollowSymlink().booleanValue(), fileHandler.getSafeSymlinkPaths().toArray(new String[0]));
                ResourceHandler rh = new ResourceHandler((ResourceManager)resourceManager);
                if (this.undertowConfiguration.getSubsystem().getServletContainer() != null) {
                    rh.setWelcomeFiles(new String[0]);
                    for (ServletContainer.WelcomeFile wf : this.undertowConfiguration.getSubsystem().getServletContainer().getWelcomeFiles()) {
                        rh.addWelcomeFiles(new String[]{wf.getName()});
                    }
                }
                ListIterator<Server.Host.FilterRef> listIterator = location.getFilterRefs().listIterator(location.getFilterRefs().size());
                while (listIterator.hasPrevious()) {
                    Server.Host.FilterRef fr = listIterator.previous();
                    UndertowSubsystem.AbstractFilter filter = this.undertowConfiguration.filter(fr.getName());
                    if (filter == null) {
                        throw new IllegalArgumentException("No filter with name \"" + fr.getName() + "\" available.");
                    }
                    Predicate p = fr.getPredicate() == null ? null : Predicates.parse((String)fr.getPredicate(), (ClassLoader)HttpHandler.class.getClassLoader());
                    rh = filter.configure((HttpHandler)rh, p);
                }
                if (!(this.rootHandler instanceof PathHandler)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding resource handler for location \"" + context + "\" and base path \"" + base.getCanonicalPath() + "\".");
                }
                ((PathHandler)this.rootHandler).addPrefixPath(context, (HttpHandler)rh);
            }
        }
        if (this.undertowConfiguration.getSubsystem().getServer().getHost() != null) {
            List<Server.Host.FilterRef> filterRefs = this.undertowConfiguration.getSubsystem().getServer().getHost().getFilterRefs();
            ListIterator<Server.Host.FilterRef> iterator = filterRefs.listIterator(filterRefs.size());
            while (iterator.hasPrevious()) {
                Server.Host.FilterRef fr = iterator.previous();
                UndertowSubsystem.AbstractFilter filter = this.undertowConfiguration.filter(fr.getName());
                if (filter == null) {
                    throw new IllegalArgumentException("No filter with name \"" + fr.getName() + "\" available.");
                }
                Predicate p = fr.getPredicate() == null ? null : Predicates.parse((String)fr.getPredicate(), (ClassLoader)HttpHandler.class.getClassLoader());
                this.rootHandler = filter.configure(this.rootHandler, p);
            }
        }
        List<Server.HttpListener> httpListeners = this.undertowConfiguration.getSubsystem().getServer().getHttpListeners();
        List<Server.HttpsListener> httpsListeners = this.undertowConfiguration.getSubsystem().getServer().getHttpsListeners();
        for (Server.HttpListener http : httpListeners) {
            listenerName = http.getName();
            if (!http.isEnabled()) {
                LOG.debug("Skipping disabled Undertow http listener \"{}\"", (Object)listenerName);
                continue;
            }
            binding = this.undertowConfiguration.bindingInfo(http.getSocketBindingName());
            for (String address : binding.getAddresses()) {
                SocketBinding secureSocketBinding;
                LOG.info("Configuring Undertow http listener for address " + address + ":" + binding.getPort());
                XnioWorker xnioWorker = this.getWorker(http.getWorkerName());
                bufferPoolForListener = this.getBufferPool(http.getBufferPoolName());
                if (http.getRedirectSocket() != null && (secureSocketBinding = this.undertowConfiguration.socketBinding(http.getRedirectSocket())) != null) {
                    this.securePortMapping.put(binding.getPort(), secureSocketBinding.getPort());
                }
                InetSocketAddress inetAddress = new InetSocketAddress(address, binding.getPort());
                AcceptingChannel<? extends StreamConnection> listener = this.undertowFactory.createListener(this.configuration, http, this.rootHandler, null, xnioWorker, bufferPoolForListener, inetAddress);
                this.listeners.put(http.getName(), new UndertowFactory.AcceptingChannelWithAddress(listener, inetAddress));
            }
        }
        for (Server.HttpsListener https : httpsListeners) {
            listenerName = https.getName();
            if (!https.isEnabled()) {
                LOG.debug("Skipping disabled Undertow https listener \"{}\"", (Object)listenerName);
                continue;
            }
            binding = this.undertowConfiguration.bindingInfo(https.getSocketBindingName());
            for (String address : binding.getAddresses()) {
                SecurityRealm realm;
                LOG.info("Configuring Undertow https listener for address " + address + ":" + binding.getPort());
                XnioWorker xnioWorker = this.getWorker(https.getWorkerName());
                bufferPoolForListener = this.getBufferPool(https.getBufferPoolName());
                if (https.getSslContext() != null) {
                    LOG.warn("ssl-context reference attribute from https-listener listener is not supported in Pax Web. Please use security-realm reference attribute instead.");
                }
                if ((realm = this.undertowConfiguration.securityRealm(https.getSecurityRealm())) == null) {
                    throw new IllegalArgumentException("No security realm with name \"" + https.getSecurityRealm() + "\" available for \"" + https.getName() + "\" https listener.");
                }
                InetSocketAddress inetAddress = new InetSocketAddress(address, binding.getPort());
                AcceptingChannel<? extends StreamConnection> listener = this.undertowFactory.createListener(this.configuration, https, this.rootHandler, realm, xnioWorker, bufferPoolForListener, inetAddress);
                this.listeners.put(https.getName(), new UndertowFactory.AcceptingChannelWithAddress(listener, inetAddress));
            }
        }
        if (this.undertowConfiguration.getSubsystem().getServletContainer() != null) {
            ServletContainer.SessionCookie cookieConfig;
            String dst = this.undertowConfiguration.getSubsystem().getServletContainer().getDefaultSessionTimeout();
            if (dst != null && !"".equals(dst)) {
                try {
                    this.defaultSessionTimeout = Integer.parseInt(dst);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Invalid default session timeout \"" + dst + "\". Using 30 (minutes).");
                }
            }
            if ((cookieConfig = this.undertowConfiguration.getSubsystem().getServletContainer().getSessionCookie()) != null) {
                this.defaultSessionCookieConfig = new DefaultSessionCookieConfig();
                this.defaultSessionCookieConfig.setName(cookieConfig.getName());
                this.defaultSessionCookieConfig.setComment(cookieConfig.getComment());
                this.defaultSessionCookieConfig.setDomain(cookieConfig.getDomain());
                this.defaultSessionCookieConfig.setSecure(cookieConfig.isSecure());
                this.defaultSessionCookieConfig.setHttpOnly(cookieConfig.isHttpOnly());
                this.defaultSessionCookieConfig.setMaxAge(cookieConfig.getMaxAge().intValue());
            }
        }
        ServletContainer.PersistentSessionsConfig persistentSessionsConfig = persistentSessions = this.undertowConfiguration.getSubsystem().getServletContainer() == null ? null : this.undertowConfiguration.getSubsystem().getServletContainer().getPersistentSessions();
        if (persistentSessions != null) {
            if (persistentSessions.getPath() != null && !"".equals(persistentSessions.getPath().trim())) {
                File sessionsDir = new File(persistentSessions.getPath());
                if (sessionsDir.isDirectory() || sessionsDir.mkdirs()) {
                    LOG.info("Using file session persistence. Location: " + sessionsDir.getCanonicalPath());
                    this.globalSessionPersistenceManager = new FileSessionPersistence(sessionsDir);
                } else {
                    LOG.warn("Can't access or create {} for file session persistence.", (Object)sessionsDir);
                }
            } else {
                LOG.info("No path configured for persistent-sessions. Using in-memory session persistence.");
                this.globalSessionPersistenceManager = new InMemorySessionPersistence();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XnioWorker getWorker(String workerName) {
        if (workerName != null) {
            if (!this.workers.containsKey(workerName)) {
                if ("default".equals(workerName)) {
                    Map<String, XnioWorker> map = this.workers;
                    synchronized (map) {
                        if (!this.workers.containsKey(workerName)) {
                            this.workers.put("default", this.undertowFactory.getDefaultWorker(this.configuration));
                        }
                    }
                    return this.workers.get(workerName);
                }
                throw new IllegalArgumentException("No worker named \"" + workerName + "\" is configured");
            }
            return this.workers.get(workerName);
        }
        return this.undertowFactory.getDefaultWorker(this.configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBufferPool getBufferPool(String bufferPoolName) {
        if (bufferPoolName != null) {
            if (!this.bufferPools.containsKey(bufferPoolName)) {
                if ("default".equals(bufferPoolName)) {
                    Map<String, ByteBufferPool> map = this.bufferPools;
                    synchronized (map) {
                        if (!this.bufferPools.containsKey(bufferPoolName)) {
                            this.bufferPools.put("default", this.undertowFactory.getDefaultBufferPool());
                        }
                    }
                    return this.bufferPools.get(bufferPoolName);
                }
                throw new IllegalArgumentException("No buffer pool named \"" + bufferPoolName + "\" is configured");
            }
            return this.bufferPools.get(bufferPoolName);
        }
        return this.undertowFactory.getDefaultBufferPool();
    }

    @Override
    public EventListener proxiedServletContextListener(EventListener eventListener, OsgiContextModel context) {
        ContextLinkingInvocationHandler handler = new ContextLinkingInvocationHandler(eventListener);
        Object cl = context.getClassLoader();
        if (cl == null) {
            cl = eventListener.getClass().getClassLoader();
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        for (Class<?> c = eventListener.getClass(); c != Object.class; c = c.getSuperclass()) {
            interfaces.addAll(Arrays.asList(c.getInterfaces()));
        }
        EventListener wrapper = (EventListener)Proxy.newProxyInstance((ClassLoader)cl, interfaces.toArray(new Class[0]), (InvocationHandler)handler);
        OsgiContextModel highestRanked = this.securityHandlers.get(context.getContextPath()).getDefaultOsgiContextModel();
        if (highestRanked != null) {
            OsgiServletContext highestRankedContext = this.osgiServletContexts.get(highestRanked);
            handler.setOsgiContext((ServletContext)highestRankedContext);
        }
        return wrapper;
    }

    private void verifyListenerConfiguration() {
        String[] addresses;
        boolean httpEnabled = this.configuration.server().isHttpEnabled();
        Integer httpPort = this.configuration.server().getHttpPort();
        boolean httpsEnabled = this.configuration.server().isHttpSecureEnabled();
        Integer httpsPort = this.configuration.server().getHttpSecurePort();
        for (String address : addresses = this.configuration.server().getListeningAddresses()) {
            this.verifyListener(address, httpPort, httpEnabled, false, () -> this.undertowFactory.createDefaultListener(address, this.rootHandler, this.configuration));
            this.verifyListener(address, httpsPort, httpsEnabled, true, () -> this.undertowFactory.createSecureListener(address, this.rootHandler, this.configuration));
        }
    }

    private void verifyListener(String address, Integer port, boolean enabled, boolean secure, Supplier<UndertowFactory.AcceptingChannelWithAddress> listenerProvider) {
        UndertowFactory.AcceptingChannelWithAddress expectedListener = null;
        boolean listenerFound = false;
        UndertowFactory.AcceptingChannelWithAddress backupListener = null;
        Iterator<UndertowFactory.AcceptingChannelWithAddress> iterator = this.listeners.values().iterator();
        while (iterator.hasNext()) {
            boolean nonSecureMatch;
            UndertowFactory.AcceptingChannelWithAddress listener = iterator.next();
            String className = listener.getAcceptingChannel().getClass().getName();
            boolean secureMatch = secure && className.equals("io.undertow.protocols.ssl.UndertowAcceptingSslChannel");
            boolean bl = nonSecureMatch = !secure && className.equals("org.xnio.nio.QueuedNioTcpServer2");
            if (!secureMatch && !nonSecureMatch) continue;
            if (this.match(address, port, listener.getAddress())) {
                listenerFound = true;
                if (enabled) {
                    expectedListener = listener;
                    continue;
                }
                LOG.warn("Listener defined in external configuration will be removed, because it's not enabled: {}", (Object)listener);
                iterator.remove();
                continue;
            }
            backupListener = listener;
        }
        if (expectedListener == null && backupListener != null) {
            expectedListener = backupListener;
        }
        if (listenerFound) {
            if (enabled) {
                LOG.info("Using configured {} as {} listener for address: {}:{}", new Object[]{expectedListener, secure ? "secure" : "non secure", address, port});
            }
        } else if (enabled) {
            LOG.info("Creating {} connector for address {}:{}", new Object[]{secure ? "secure" : "non secure", address, port});
            UndertowFactory.AcceptingChannelWithAddress listener = listenerProvider.get();
            this.listeners.put(UUID.randomUUID().toString(), listener);
        }
    }

    private boolean match(String address1, Integer port1, InetSocketAddress connector) {
        InetSocketAddress isa1 = address1 != null ? new InetSocketAddress(address1, (int)port1) : new InetSocketAddress(port1);
        return isa1.equals(connector);
    }

    public void configureRequestLog() throws IOException {
        if (this.undertowConfiguration != null && this.undertowConfiguration.getSubsystem() != null && this.undertowConfiguration.getSubsystem().getServer() != null && this.undertowConfiguration.getSubsystem().getServer().getHost() != null && this.undertowConfiguration.getSubsystem().getServer().getHost().getAccessLog() != null) {
            Server.Host.AccessLog accessLog = this.undertowConfiguration.getSubsystem().getServer().getHost().getAccessLog();
            Bundle bundle = FrameworkUtil.getBundle(UndertowServerController.class);
            ClassLoader loader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
            XnioWorker xnioWorker = this.undertowFactory.createLogWorker();
            DefaultAccessLogReceiver logReceiver = DefaultAccessLogReceiver.builder().setLogWriteExecutor((Executor)xnioWorker).setOutputDirectory(new File(accessLog.getDirectory()).toPath()).setLogBaseName(accessLog.getPrefix()).setLogNameSuffix(accessLog.getSuffix()).setRotate(Boolean.parseBoolean(accessLog.getRotate())).build();
            this.rootHandler = new AccessLogHandler(this.rootHandler, (AccessLogReceiver)logReceiver, accessLog.getPattern(), AccessLogHandler.class.getClassLoader());
            return;
        }
        LogConfiguration lc = this.configuration.logging();
        if (!lc.isLogNCSAFormatEnabled().booleanValue()) {
            return;
        }
        if (lc.getLogNCSADirectory() == null) {
            throw new IllegalArgumentException("Log directory for NCSA logging is not specified. Please set org.ops4j.pax.web.log.ncsa.directory property.");
        }
        File logDir = new File(lc.getLogNCSADirectory());
        if (logDir.isFile()) {
            throw new IllegalArgumentException(logDir + " is not a valid directory to store request logs");
        }
        LOG.info("NCSARequestlogging is using directory {}", (Object)lc.getLogNCSADirectory());
        if (lc.isLogNCSAFormatEnabled().booleanValue()) {
            String logNCSADirectory = lc.getLogNCSADirectory();
            String baseName = lc.getLogNCSAFile();
            Bundle bundle = FrameworkUtil.getBundle(UndertowServerController.class);
            ClassLoader loader = bundle == null ? this.getClass().getClassLoader() : ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
            XnioWorker xnioWorker = this.undertowFactory.createLogWorker();
            DefaultAccessLogReceiver logReceiver = DefaultAccessLogReceiver.builder().setLogWriteExecutor((Executor)xnioWorker).setOutputDirectory(new File(logNCSADirectory).toPath()).setLogBaseName(baseName).setLogNameSuffix("log").setRotate(true).build();
            String format = lc.isLogNCSAExtended() != false ? "combined" : "common";
            this.rootHandler = new AccessLogHandler(this.rootHandler, (AccessLogReceiver)logReceiver, format, AccessLogHandler.class.getClassLoader());
        }
    }

    public void start() throws Exception {
        LOG.info("Starting {}", (Object)this);
        this.listeners.values().forEach(l -> l.getAcceptingChannel().resumeAccepts());
    }

    public void stop() throws Exception {
        LOG.info("Stopping {}", (Object)this);
        this.listeners.values().forEach(l -> IoUtils.safeClose(l.getAcceptingChannel()));
        this.servletContainer.listDeployments().forEach(d -> {
            DeploymentManager deployment = this.servletContainer.getDeployment(d);
            if (deployment.getState() != DeploymentManager.State.UNDEPLOYED) {
                String contextPath = deployment.getDeployment().getServletContext().getContextPath();
                try {
                    if (this.preprocessorsHandlers.containsKey(contextPath)) {
                        for (PreprocessorFilterConfig fc : this.preprocessorsHandlers.get(contextPath).getPreprocessors()) {
                            if (!fc.isInitCalled()) continue;
                            fc.destroy();
                            fc.setInitCalled(false);
                        }
                    }
                    deployment.stop();
                    deployment.undeploy();
                }
                catch (ServletException e) {
                    LOG.warn("Problem stopping deployment for context " + contextPath + ": " + e.getMessage(), (Throwable)e);
                }
            }
        });
        this.deploymentInfos.clear();
        this.preprocessorsHandlers.clear();
        this.securityHandlers.clear();
        this.wrappingHandlers.clear();
        this.errorPages.clear();
        this.workers.values().forEach(XnioWorker::shutdown);
        this.workers.clear();
        this.bufferPools.values().forEach(ByteBufferPool::close);
        this.bufferPools.clear();
        this.undertowFactory.closeDefaultPoolAndBuffer();
        this.osgiServletContexts.values().forEach(OsgiServletContext::unregister);
    }

    public ServerEvent.Address[] getAddresses(boolean useLocalPort) {
        if (this.listeners.size() == 0) {
            return new ServerEvent.Address[0];
        }
        ArrayList result = new ArrayList(this.listeners.size());
        this.listeners.values().forEach(ac -> result.add(new ServerEvent.Address(ac.getAddress(), ac.isSecure())));
        return result.toArray(new ServerEvent.Address[0]);
    }

    public void visitTransactionStateChange(TransactionStateChange change) {
        String contextPath = change.getContextPath();
        if (change.getKind() == OpCode.ASSOCIATE) {
            if (!this.transactions.add(contextPath)) {
                throw new IllegalStateException("Context path " + contextPath + " is already associated with config transaction");
            }
            this.delayedRemovals.computeIfAbsent(contextPath, cp -> new ArrayList());
        } else if (change.getKind() == OpCode.DISASSOCIATE) {
            if (!this.transactions.remove(contextPath)) {
                throw new IllegalStateException("Context path " + contextPath + " is not associated with any config transaction");
            }
            List<ElementModel<?, ?>> toRemove = this.delayedRemovals.get(contextPath);
            DeploymentManager manager = this.getDeploymentManager(contextPath);
            if (toRemove != null) {
                Iterator<ElementModel<?, ?>> iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    ElementModel<?, ?> model = iterator.next();
                    if (model instanceof ServletModel) {
                        this.removeServletModel(contextPath, (ServletModel)model, null);
                    } else if (model instanceof EventListenerModel) {
                        if (manager != null) {
                            DeploymentInfo deploymentInfo = manager.getDeployment().getDeploymentInfo();
                            Deployment deployment = manager.getDeployment();
                            this.stopUndertowContext(contextPath, manager, deploymentInfo, false);
                            this.removeEventListenerModel(deploymentInfo, (EventListenerModel)model, ((EventListenerModel)model).getResolvedListener());
                        } else if (this.deploymentInfos.containsKey(contextPath)) {
                            this.removeEventListenerModel(this.deploymentInfos.get(contextPath), (EventListenerModel)model, ((EventListenerModel)model).getResolvedListener());
                        }
                    }
                    iterator.remove();
                }
            }
            this.delayedRemovals.remove(contextPath);
            if (this.deploymentInfos.containsKey(contextPath)) {
                this.ensureServletContextStarted(contextPath);
            }
        }
    }

    public void visitServletContextModelChange(ServletContextModelChange change) {
        ServletContextModel model = change.getServletContextModel();
        String contextPath = model.getContextPath();
        if (change.getKind() == OpCode.ADD) {
            if (this.deploymentInfos.containsKey(contextPath)) {
                return;
            }
            LOG.info("Creating new Undertow context for {}", (Object)model);
            DeploymentInfo deploymentInfo = Servlets.deployment();
            String deploymentName = "/".equals(model.getContextPath()) ? "ROOT" : model.getContextPath().substring(1).replaceAll("/", "_");
            deploymentInfo.setDeploymentName(deploymentName);
            deploymentInfo.setDisplayName(model.getId());
            deploymentInfo.setContextPath(contextPath);
            deploymentInfo.setUrlEncoding(StandardCharsets.UTF_8.name());
            deploymentInfo.setEagerFilterInit(true);
            if (this.configuration.server().isShowStacks().booleanValue()) {
                deploymentInfo.setServletStackTraces(ServletStackTraces.ALL);
            } else {
                deploymentInfo.setServletStackTraces(ServletStackTraces.NONE);
            }
            deploymentInfo.addServlet(new PaxWebServletInfo("default", (Servlet)this.default404Servlet, true).addMapping("/"));
            deploymentInfo.setConfidentialPortManager((ConfidentialPortManager)new SimpleConfidentialPortManager());
            deploymentInfo.setIdentityManager(this.identityManager);
            PaxWebPreprocessorsHandler preprocessorWrapper = new PaxWebPreprocessorsHandler();
            this.preprocessorsHandlers.put(contextPath, preprocessorWrapper);
            deploymentInfo.addOuterHandlerChainWrapper((HandlerWrapper)preprocessorWrapper);
            PaxWebOuterHandlerWrapper outerWrapper = new PaxWebOuterHandlerWrapper(new OsgiSessionAttributeListener(this.sessionListenerModels));
            this.wrappingHandlers.put(contextPath, outerWrapper);
            deploymentInfo.addOuterHandlerChainWrapper((HandlerWrapper)outerWrapper);
            PaxWebSecurityHandler securityWrapper = new PaxWebSecurityHandler();
            this.securityHandlers.put(contextPath, securityWrapper);
            deploymentInfo.addSecurityWrapper((HandlerWrapper)securityWrapper);
            SessionConfiguration sc = this.configuration.session();
            deploymentInfo.setDefaultSessionTimeout(sc.getSessionTimeout() * 60);
            ServletSessionConfig ssc = new ServletSessionConfig();
            ssc.setName(this.defaultSessionCookieConfig.getName());
            ssc.setDomain(this.defaultSessionCookieConfig.getDomain());
            ssc.setPath(this.defaultSessionCookieConfig.getPath());
            ssc.setMaxAge(this.defaultSessionCookieConfig.getMaxAge());
            ssc.setHttpOnly(this.defaultSessionCookieConfig.isHttpOnly());
            ssc.setSecure(this.defaultSessionCookieConfig.isSecure());
            ssc.setComment(this.defaultSessionCookieConfig.getComment());
            deploymentInfo.setServletSessionConfig(ssc);
            deploymentInfo.setSessionPersistenceManager(this.globalSessionPersistenceManager);
            this.deploymentInfos.put(contextPath, deploymentInfo);
            this.osgiContextModels.put(contextPath, new TreeSet());
            this.initializers.put(contextPath, new TreeSet());
            this.dynamicRegistrations.put(contextPath, new DynamicRegistrations());
            this.rankedListeners.put(contextPath, new TreeMap());
            this.orderedListeners.put(contextPath, new ArrayList());
        } else if (change.getKind() == OpCode.DELETE) {
            OsgiContextModel highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath));
            if (highestRankedModel != null) {
                return;
            }
            this.orderedListeners.remove(contextPath);
            this.rankedListeners.remove(contextPath);
            this.dynamicRegistrations.remove(contextPath);
            this.initializers.remove(contextPath);
            this.osgiContextModels.remove(contextPath);
            this.deploymentInfos.remove(contextPath);
            this.securityHandlers.remove(contextPath);
            this.wrappingHandlers.remove(contextPath);
            DeploymentManager manager = this.getDeploymentManager(contextPath);
            if (manager != null) {
                DeploymentInfo deploymentInfoToRemove = manager.getDeployment().getDeploymentInfo();
                this.stopUndertowContext(contextPath, manager, null, false);
                this.servletContainer.removeDeployment(deploymentInfoToRemove);
            }
        }
    }

    public void visitOsgiContextModelChange(OsgiContextModelChange change) {
        OsgiContextModel highestRankedModel;
        if (change.getKind() == OpCode.ASSOCIATE || change.getKind() == OpCode.DISASSOCIATE) {
            return;
        }
        OsgiContextModel osgiModel = change.getOsgiContextModel();
        ServletContextModel servletContextModel = change.getServletContextModel();
        String contextPath = osgiModel.getContextPath();
        if (change.getKind() == OpCode.ADD) {
            LOG.info("Adding {} to deployment info of {}", (Object)osgiModel, (Object)contextPath);
            if (this.osgiServletContexts.containsKey(osgiModel)) {
                throw new IllegalStateException(osgiModel + " is already registered");
            }
            TreeSet<OsgiContextModel> osgiContextModels = this.osgiContextModels.get(contextPath);
            if (osgiContextModels == null) {
                this.visitServletContextModelChange(new ServletContextModelChange(OpCode.ADD, new ServletContextModel(contextPath)));
                osgiContextModels = this.osgiContextModels.get(contextPath);
            }
            Object classLoader = null;
            if (osgiModel.getClassLoader() != null) {
                classLoader = osgiModel.getClassLoader();
            }
            if (this.paxWebUndertowBundle != null) {
                OsgiServletContextClassLoader loader = classLoader != null ? classLoader : new OsgiServletContextClassLoader();
                loader.addBundle(osgiModel.getOwnerBundle());
                loader.addBundle(this.paxWebUndertowBundle);
                loader.addBundle(Utils.getPaxWebJspBundle((Bundle)this.paxWebUndertowBundle));
                loader.addBundle(Utils.getPaxWebUndertowWebSocketBundle((Bundle)this.paxWebUndertowBundle));
                loader.addBundle(Utils.getUndertowWebSocketBundle((Bundle)this.paxWebUndertowBundle));
                loader.makeImmutable();
                classLoader = loader;
            } else if (classLoader == null) {
                classLoader = this.classLoader;
            }
            OsgiServletContext osgiContext = new OsgiServletContext(this.getRealServletContext(contextPath), osgiModel, servletContextModel, this.defaultSessionCookieConfig, (ClassLoader)classLoader);
            File tmpLocation = new File(this.configuration.server().getTemporaryDirectory(), osgiModel.getTemporaryLocation());
            if (!tmpLocation.exists() && !tmpLocation.mkdirs()) {
                LOG.warn("Can't create temporary directory for {}: {}", (Object)osgiModel, (Object)tmpLocation.getAbsolutePath());
            }
            osgiModel.getInitialContextAttributes().put("javax.servlet.context.tempdir", tmpLocation);
            osgiContext.setAttribute("javax.servlet.context.tempdir", (Object)tmpLocation);
            this.osgiServletContexts.put(osgiModel, osgiContext);
            osgiContextModels.add(osgiModel);
        }
        boolean hasStopped = false;
        if (change.getKind() == OpCode.DELETE) {
            OsgiServletContext currentHighestRankedContext;
            PaxWebOuterHandlerWrapper wrapper;
            LOG.info("Removing {} from {}", (Object)osgiModel, (Object)contextPath);
            OsgiServletContext removedOsgiServletContext = this.osgiServletContexts.remove(osgiModel);
            TreeSet<OsgiContextModel> models = this.osgiContextModels.get(contextPath);
            if (models != null) {
                models.remove(osgiModel);
            }
            if (removedOsgiServletContext != null) {
                removedOsgiServletContext.unregister();
                removedOsgiServletContext.releaseWebContainerContext();
            }
            if ((wrapper = this.wrappingHandlers.get(contextPath)) != null && ((currentHighestRankedContext = wrapper.getDefaultServletContext()) == removedOsgiServletContext || this.pendingTransaction(contextPath))) {
                DeploymentManager manager = this.getDeploymentManager(contextPath);
                if (manager != null) {
                    this.stopUndertowContext(contextPath, manager, null, false);
                    hasStopped = true;
                }
                if (this.wrappingHandlers.containsKey(contextPath)) {
                    this.wrappingHandlers.get(contextPath).setDefaultServletContext(null);
                }
                if (this.securityHandlers.containsKey(contextPath)) {
                    this.securityHandlers.get(contextPath).setDefaultOsgiContextModel(null, null);
                }
            }
        }
        if ((highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath))) != null) {
            ServletInfo defaultServlet;
            DeploymentInfo deploymentInfo;
            PaxWebSecurityHandler securityHandler = this.securityHandlers.get(contextPath);
            if (securityHandler != null && highestRankedModel != securityHandler.getDefaultOsgiContextModel()) {
                DeploymentManager manager;
                LOG.info("Changing default OSGi context model for context \"" + contextPath + "\"");
                OsgiServletContext highestRankedContext = this.osgiServletContexts.get(highestRankedModel);
                if (this.wrappingHandlers.containsKey(contextPath)) {
                    this.wrappingHandlers.get(contextPath).setDefaultServletContext(highestRankedContext);
                }
                securityHandler.setDefaultOsgiContextModel(highestRankedModel, highestRankedContext.getResolvedWebContainerContext());
                this.osgiServletContexts.forEach((ocm, osc) -> {
                    if (ocm.getContextPath().equals(contextPath) && osc != highestRankedContext) {
                        osc.unregister();
                    }
                });
                if (!hasStopped && (manager = this.getDeploymentManager(contextPath)) != null) {
                    this.stopUndertowContext(contextPath, manager, null, false);
                    hasStopped = true;
                }
                highestRankedContext.register();
            }
            if ((deploymentInfo = this.deploymentInfos.get(contextPath)) != null && (defaultServlet = (ServletInfo)deploymentInfo.getServlets().get("default")) instanceof PaxWebServletInfo && ((PaxWebServletInfo)defaultServlet).is404()) {
                ((PaxWebServletInfo)defaultServlet).setOsgiContextModel(highestRankedModel);
            }
            if (hasStopped) {
                if (this.pendingTransaction(contextPath)) {
                    change.registerBatchCompletedAction((Change)new ContextStartChange(OpCode.MODIFY, contextPath));
                } else {
                    this.ensureServletContextStarted(contextPath);
                }
            }
        } else {
            ServletInfo defaultServlet;
            DeploymentInfo deploymentInfo;
            if (this.wrappingHandlers.containsKey(contextPath)) {
                this.wrappingHandlers.get(contextPath).setDefaultServletContext(null);
            }
            if (this.securityHandlers.containsKey(contextPath)) {
                this.securityHandlers.get(contextPath).setDefaultOsgiContextModel(null, null);
            }
            if ((deploymentInfo = this.deploymentInfos.get(contextPath)) != null && (defaultServlet = (ServletInfo)deploymentInfo.getServlets().get("default")) instanceof PaxWebServletInfo && ((PaxWebServletInfo)defaultServlet).is404()) {
                ((PaxWebServletInfo)defaultServlet).setOsgiContextModel(null);
            }
            this.visitServletContextModelChange(new ServletContextModelChange(OpCode.DELETE, new ServletContextModel(contextPath)));
        }
    }

    public void visitContextMetadataModelChange(ContextMetadataModelChange change) {
        if (change.getKind() == OpCode.ADD) {
            OsgiContextModel ocm = change.getOsgiContextModel();
            ContextMetadataModel meta = change.getMetadata();
            String contextPath = ocm.getContextPath();
            OsgiContextModel highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath));
            if (ocm == highestRankedModel) {
                LOG.info("Configuring metadata of {}", (Object)ocm);
                DeploymentInfo info = this.deploymentInfos.get(contextPath);
                info.setMajorVersion(meta.getMajorVersion());
                info.setMinorVersion(meta.getMinorVersion());
                info.setDisplayName(meta.getDisplayName());
                info.setDefaultRequestEncoding(meta.getRequestCharacterEncoding());
                info.setDefaultResponseEncoding(meta.getResponseCharacterEncoding());
                info.setDenyUncoveredHttpMethods(meta.isDenyUncoveredHttpMethods());
            }
        }
    }

    public void visitMimeAndLocaleMappingChange(MimeAndLocaleMappingChange change) {
        String contextPath;
        OsgiContextModel highestRankedModel;
        OsgiContextModel ocm;
        if (change.getKind() == OpCode.ADD && (ocm = change.getOsgiContextModel()) == (highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath = ocm.getContextPath())))) {
            LOG.info("Configuring MIME and Locale Encoding mapping of {}", (Object)ocm);
            DeploymentInfo info = this.deploymentInfos.get(contextPath);
            change.getMimeMapping().forEach((ext, mime) -> info.addMimeMapping(new MimeMapping(ext, mime)));
            change.getLocaleEncodingMapping().forEach((arg_0, arg_1) -> ((DeploymentInfo)info).addLocaleCharsetMapping(arg_0, arg_1));
        }
    }

    public void visitServletModelChange(ServletModelChange change) {
        HashSet done = new HashSet();
        if (change.getKind() == OpCode.ADD && !change.isDisabled() || change.getKind() == OpCode.ENABLE) {
            ServletModel model = change.getServletModel();
            if (change.getNewModelsInfo() == null) {
                LOG.info("Adding servlet {}", (Object)model);
            } else {
                LOG.info("Adding servlet {} to new contexts {}", (Object)model, (Object)change.getNewModelsInfo());
            }
            change.getContextModels().forEach(osgiContext -> {
                ErrorPageModel epm;
                String contextPath = osgiContext.getContextPath();
                if (!done.add(contextPath)) {
                    return;
                }
                LOG.debug("Adding servlet {} to {}", (Object)model.getName(), (Object)contextPath);
                DeploymentManager manager = this.getDeploymentManager(contextPath);
                Deployment deployment = manager == null ? null : manager.getDeployment();
                DeploymentInfo deploymentInfo = deployment == null ? this.deploymentInfos.get(contextPath) : deployment.getDeploymentInfo();
                OsgiServletContext context = this.osgiServletContexts.get(osgiContext);
                PaxWebServletInfo info = new PaxWebServletInfo(model, (OsgiContextModel)osgiContext, context, "whiteboard".equalsIgnoreCase(this.configuration.server().getTCCLType()));
                boolean isDefaultResourceServlet = model.isResourceServlet();
                if (isDefaultResourceServlet) {
                    for (String pattern : model.getUrlPatterns()) {
                        isDefaultResourceServlet &= "/".equals(pattern);
                    }
                    info.addInitParam("pathInfoOnly", Boolean.toString(!isDefaultResourceServlet));
                    info.addInitParam("resolve-against-context-root", Boolean.toString(isDefaultResourceServlet));
                }
                Iterator it = deploymentInfo.getServlets().entrySet().iterator();
                while (it.hasNext()) {
                    ManagedServlet ms;
                    Map.Entry e = it.next();
                    ServletInfo pwsi = (ServletInfo)e.getValue();
                    boolean override = false;
                    if (pwsi instanceof PaxWebServletInfo && (((PaxWebServletInfo)pwsi).getServletModel() == null || ((PaxWebServletInfo)pwsi).getServletModel().isOverridable())) {
                        for (String mapping : pwsi.getMappings()) {
                            if (!info.getMappings().contains(mapping)) continue;
                            override = true;
                            break;
                        }
                    }
                    if (!override) continue;
                    it.remove();
                    if (deployment == null || !((ms = deployment.getServlets().getManagedServlet((String)e.getKey())).getServletInfo() instanceof PaxWebServletInfo)) continue;
                    ms.getServletInfo().getMappings().clear();
                }
                model.getRoleLinks().forEach((arg_0, arg_1) -> ((ServletInfo)info).addSecurityRoleRef(arg_0, arg_1));
                info.setRunAs(model.getRunAs());
                deploymentInfo.addServlet((ServletInfo)info);
                if (deployment != null) {
                    deployment.getServlets().addServlet((ServletInfo)info);
                }
                if ((epm = model.getErrorPageModel()) != null && epm.isValid()) {
                    String location = epm.getLocation();
                    FlexibleErrorPages currentState = this.errorPages.computeIfAbsent(contextPath, cp -> new FlexibleErrorPages());
                    for (String ex : epm.getExceptionClassNames()) {
                        try {
                            ClassLoader cl = ((BundleWiring)model.getRegisteringBundle().adapt(BundleWiring.class)).getClassLoader();
                            Class<?> t = cl.loadClass(ex);
                            currentState.getExceptionMappings().put(t, location);
                            deploymentInfo.addErrorPage(new ErrorPage(location, t));
                        }
                        catch (ClassNotFoundException e) {
                            LOG.warn("Can't load exception class {}: {}", new Object[]{ex, e.getMessage(), e});
                        }
                    }
                    Iterator override = epm.getErrorCodes().iterator();
                    while (override.hasNext()) {
                        int code = (Integer)override.next();
                        currentState.getErrorCodeLocations().put(code, location);
                        deploymentInfo.addErrorPage(new ErrorPage(location, code));
                    }
                    if (epm.isXx4()) {
                        for (int c = 400; c < 500; ++c) {
                            currentState.getErrorCodeLocations().put(c, location);
                            deploymentInfo.addErrorPage(new ErrorPage(location, c));
                        }
                    }
                    if (epm.isXx5()) {
                        for (int c = 500; c < 600; ++c) {
                            currentState.getErrorCodeLocations().put(c, location);
                            deploymentInfo.addErrorPage(new ErrorPage(location, c));
                        }
                    }
                    if (deployment instanceof DeploymentImpl) {
                        ((DeploymentImpl)deployment).setErrorPages((ErrorPages)currentState);
                    }
                }
                this.deploymentInfos.put(contextPath, deploymentInfo);
                if (!change.isDynamic()) {
                    this.ensureServletContextStarted(contextPath);
                } else if (model.isServletSecurityPresent()) {
                    ArrayList dynamicModels = new ArrayList();
                    model.getContextModels().forEach(ocm -> {
                        for (SecurityConstraintModel sc : ocm.getSecurityConfiguration().getSecurityConstraints()) {
                            if (sc.getServletModel() != model) continue;
                            dynamicModels.add(sc);
                        }
                    });
                    ServletSecurityInfo ssi = new ServletSecurityInfo();
                    for (SecurityConstraintModel constraintModel : dynamicModels) {
                        SecurityConstraint constraint = new SecurityConstraint();
                        if (constraintModel.isAuthRolesSet()) {
                            constraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.AUTHENTICATE);
                        }
                        constraint.addRolesAllowed((Collection)constraintModel.getAuthRoles());
                        if (constraintModel.getTransportGuarantee() == ServletSecurity.TransportGuarantee.NONE) {
                            constraint.setTransportGuaranteeType(TransportGuaranteeType.NONE);
                        } else if (constraintModel.getTransportGuarantee() == ServletSecurity.TransportGuarantee.CONFIDENTIAL) {
                            constraint.setTransportGuaranteeType(TransportGuaranteeType.CONFIDENTIAL);
                        }
                        for (SecurityConstraintModel.WebResourceCollection col : constraintModel.getWebResourceCollections()) {
                            WebResourceCollection wrc = new WebResourceCollection();
                            boolean methodSet = false;
                            wrc.addHttpMethods((Collection)col.getMethods());
                            if (col.getMethods().size() == 0) {
                                wrc.addHttpMethodOmissions((Collection)col.getOmittedMethods());
                            }
                            wrc.addUrlPatterns((Collection)col.getPatterns());
                            constraint.addWebResourceCollection(wrc);
                        }
                        deploymentInfo.addSecurityConstraint(constraint);
                    }
                }
            });
            return;
        }
        if (change.getKind() == OpCode.DISABLE || change.getKind() == OpCode.DELETE) {
            for (Map.Entry entry : change.getServletModels().entrySet()) {
                ServletModel model = (ServletModel)entry.getKey();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                model.getContextModels().forEach(osgiContextModel -> {
                    String contextPath = osgiContextModel.getContextPath();
                    if (!done.add(contextPath)) {
                        return;
                    }
                    if (this.pendingTransaction(contextPath)) {
                        LOG.debug("Delaying removal of servlet {}", (Object)model);
                        this.delayedRemovals.get(contextPath).add((ElementModel<?, ?>)model);
                        return;
                    }
                    this.removeServletModel(contextPath, model, change);
                });
            }
        }
    }

    private void removeServletModel(String contextPath, ServletModel model, ServletModelChange change) {
        ErrorPageModel epm;
        DeploymentInfo deploymentInfo;
        LOG.info("Removing servlet {}", (Object)model);
        LOG.debug("Removing servlet {} from context {}", (Object)model.getName(), (Object)contextPath);
        DeploymentManager manager = this.getDeploymentManager(contextPath);
        Deployment deployment = manager == null ? null : manager.getDeployment();
        DeploymentInfo deploymentInfo2 = deploymentInfo = deployment == null ? this.deploymentInfos.get(contextPath) : deployment.getDeploymentInfo();
        if (change == null || !change.isDynamic()) {
            this.stopUndertowContext(contextPath, manager, deploymentInfo, false);
        }
        if (deploymentInfo != null) {
            deploymentInfo.getServlets().remove(model.getName());
            if (Arrays.asList(model.getUrlPatterns()).contains("/")) {
                PaxWebServletInfo defaultServletInfo = new PaxWebServletInfo("default", (Servlet)this.default404Servlet, true);
                deploymentInfo.addServlet(defaultServletInfo.addMapping("/"));
            }
        }
        if ((epm = model.getErrorPageModel()) != null && deploymentInfo != null) {
            String location = epm.getLocation();
            FlexibleErrorPages currentState = this.errorPages.computeIfAbsent(contextPath, cp -> new FlexibleErrorPages());
            for (String ex : epm.getExceptionClassNames()) {
                try {
                    ClassLoader cl = ((BundleWiring)model.getRegisteringBundle().adapt(BundleWiring.class)).getClassLoader();
                    Class<?> t = cl.loadClass(ex);
                    currentState.getExceptionMappings().remove(t, location);
                }
                catch (ClassNotFoundException e2) {
                    LOG.warn("Can't load exception class {}: {}", new Object[]{ex, e2.getMessage(), e2});
                }
            }
            Iterator iterator = epm.getErrorCodes().iterator();
            while (iterator.hasNext()) {
                int code = (Integer)iterator.next();
                currentState.getErrorCodeLocations().remove(code, location);
            }
            if (epm.isXx4()) {
                for (int c2 = 400; c2 < 500; ++c2) {
                    currentState.getErrorCodeLocations().remove(c2, location);
                }
            }
            if (epm.isXx5()) {
                for (int c3 = 500; c3 < 600; ++c3) {
                    currentState.getErrorCodeLocations().remove(c3, location);
                }
            }
            deploymentInfo.getErrorPages().clear();
            currentState.getErrorCodeLocations().forEach((c, l) -> deploymentInfo.addErrorPage(new ErrorPage(location, c.intValue())));
            currentState.getExceptionMappings().forEach((e, l) -> deploymentInfo.addErrorPage(new ErrorPage(location, e)));
        }
        if (change == null || !change.isDynamic()) {
            this.ensureServletContextStarted(contextPath);
        }
    }

    public void visitFilterModelChange(FilterModelChange change) {
        FilterModel model = change.getFilterModel();
        HashSet<String> done = new HashSet<String>();
        if (change.getKind() == OpCode.ADD && model.isDynamic()) {
            for (OsgiContextModel ocm : change.getContextModels()) {
                String contextPath = ocm.getContextPath();
                if (!done.add(contextPath)) continue;
                LOG.info("Adding dynamic filter {} to context {}", (Object)model, (Object)contextPath);
                OsgiContextModel highestRankedModel = null;
                for (OsgiContextModel cm : model.getContextModels()) {
                    if (!cm.getContextPath().equals(contextPath)) continue;
                    highestRankedModel = cm;
                    break;
                }
                if (highestRankedModel == null) {
                    highestRankedModel = ocm;
                }
                OsgiServletContext osgiContext = this.osgiServletContexts.get(highestRankedModel);
                DeploymentManager manager = this.getDeploymentManager(contextPath);
                DeploymentInfo deploymentInfo = manager == null ? this.deploymentInfos.get(contextPath) : manager.getDeployment().getDeploymentInfo();
                Deployment deployment = manager == null ? null : manager.getDeployment();
                PaxWebFilterInfo info = new PaxWebFilterInfo(model, osgiContext, "whiteboard".equalsIgnoreCase(this.configuration.server().getTCCLType()));
                deploymentInfo.addFilter((FilterInfo)info);
                if (deployment != null) {
                    deployment.getFilters().addFilter((FilterInfo)info);
                }
                this.configureFilterMappings(model, deploymentInfo);
            }
        }
    }

    public void visitFilterStateChange(FilterStateChange change) {
        DeploymentInfo deploymentInfo;
        DeploymentManager.State state;
        DeploymentManager manager;
        OsgiContextModel defaultHighestRankedModel;
        TreeSet<FilterModel> filters;
        Map filtersMap;
        String contextPath;
        if (change.isDynamic()) {
            return;
        }
        Map contextFilters = change.getContextFilters();
        for (Map.Entry entry : contextFilters.entrySet()) {
            contextPath = (String)entry.getKey();
            filtersMap = (Map)entry.getValue();
            filters = new TreeSet<FilterModel>(filtersMap.keySet());
            LOG.info("Changing preprocessor configuration for context {}", (Object)contextPath);
            defaultHighestRankedModel = this.osgiContextModels.containsKey(contextPath) ? this.osgiContextModels.get(contextPath).iterator().next() : null;
            manager = this.getDeploymentManager(contextPath);
            state = manager == null ? DeploymentManager.State.UNDEPLOYED : manager.getState();
            DeploymentInfo deploymentInfo2 = deploymentInfo = manager == null ? this.deploymentInfos.get(contextPath) : manager.getDeployment().getDeploymentInfo();
            if (deploymentInfo == null) continue;
            PaxWebPreprocessorsHandler preprocessorsHandler = this.preprocessorsHandlers.get(contextPath);
            HashSet<PreprocessorFilterConfig> toDestroy = new HashSet<PreprocessorFilterConfig>(preprocessorsHandler.getPreprocessors());
            LinkedList<PreprocessorFilterConfig> toInit = new LinkedList<PreprocessorFilterConfig>();
            preprocessorsHandler.getPreprocessors().clear();
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                FilterModel model = (FilterModel)iterator.next();
                if (!model.isPreprocessor()) continue;
                PreprocessorFilterConfig filterConfig = new PreprocessorFilterConfig(model, this.osgiServletContexts.get(defaultHighestRankedModel));
                if (toDestroy.stream().noneMatch(pfc -> pfc.getModel().equals((Object)model))) {
                    toInit.add(filterConfig);
                } else {
                    toDestroy.removeIf(pfc -> {
                        boolean match = pfc.getModel().equals((Object)model);
                        if (match) {
                            filterConfig.copyFrom(pfc);
                        }
                        return match;
                    });
                }
                preprocessorsHandler.getPreprocessors().add(filterConfig);
                iterator.remove();
            }
            if (manager == null || manager.getState() != DeploymentManager.State.STARTED) continue;
            for (PreprocessorFilterConfig fc : toInit) {
                try {
                    fc.getInstance().init((FilterConfig)fc);
                    fc.setInitCalled(true);
                }
                catch (ServletException ex) {
                    LOG.warn("Problem during preprocessor initialization: {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
            for (PreprocessorFilterConfig fc : toDestroy) {
                fc.destroy();
                fc.setInitCalled(false);
            }
        }
        for (Map.Entry entry : contextFilters.entrySet()) {
            contextPath = (String)entry.getKey();
            filtersMap = (Map)entry.getValue();
            filters = new TreeSet(filtersMap.keySet());
            LOG.info("Changing filter configuration for context {}", (Object)contextPath);
            defaultHighestRankedModel = this.osgiContextModels.containsKey(contextPath) ? this.osgiContextModels.get(contextPath).iterator().next() : null;
            manager = this.getDeploymentManager(contextPath);
            state = manager == null ? DeploymentManager.State.UNDEPLOYED : manager.getState();
            DeploymentInfo deploymentInfo3 = deploymentInfo = manager == null ? this.deploymentInfos.get(contextPath) : manager.getDeployment().getDeploymentInfo();
            if (deploymentInfo == null) continue;
            boolean quick = this.canQuicklyAddFilter(deploymentInfo, filters);
            if (!(quick &= filtersMap.values().stream().noneMatch(Objects::nonNull))) {
                this.stopUndertowContext(contextPath, manager, null, true);
                if (manager != null) {
                    state = manager.getState();
                }
                deploymentInfo = this.undertowFactory.clearFilters(deploymentInfo, false, true);
                this.deploymentInfos.put(contextPath, deploymentInfo);
            }
            LinkedList<PaxWebFilterInfo> added = new LinkedList<PaxWebFilterInfo>();
            for (FilterModel model : filters) {
                if (model.isPreprocessor()) continue;
                OsgiContextModel highestRankedModel = null;
                List contextModels = filtersMap.get(model) != null ? (List)filtersMap.get(model) : model.getContextModels();
                for (OsgiContextModel ocm : contextModels) {
                    if (!ocm.getContextPath().equals(contextPath)) continue;
                    highestRankedModel = ocm;
                    break;
                }
                if (highestRankedModel == null) {
                    LOG.warn("(dev) Can't find proper OsgiContextModel for the filter. Falling back to highest ranked OsgiContextModel for given ServletContextModel");
                    highestRankedModel = defaultHighestRankedModel;
                }
                OsgiServletContext context2 = this.osgiServletContexts.get(highestRankedModel);
                PaxWebFilterInfo info = new PaxWebFilterInfo(model, context2, "whiteboard".equalsIgnoreCase(this.configuration.server().getTCCLType()));
                if (quick && state == DeploymentManager.State.STARTED) {
                    ManagedFilters currentFilters = manager.getDeployment().getFilters();
                    ManagedFilter managedFilter = currentFilters.getManagedFilter(info.getName());
                    if (managedFilter == null) {
                        currentFilters.addFilter((FilterInfo)info);
                        added.add(info);
                    } else {
                        FilterInfo currentFilter = managedFilter.getFilterInfo();
                        if (!(currentFilter instanceof PaxWebFilterInfo) || !((PaxWebFilterInfo)currentFilter).getFilterModel().equals((Object)model)) {
                            currentFilters.addFilter((FilterInfo)info);
                            added.add(info);
                        }
                    }
                }
                if (quick && added.size() <= 0 && state == DeploymentManager.State.STARTED) continue;
                deploymentInfo.addFilter((FilterInfo)info);
                this.configureFilterMappings(model, deploymentInfo);
            }
            if (added.size() > 0) {
                for (ManagedFilter filter : manager.getDeployment().getFilters().getFilters().values()) {
                    try {
                        new ContextClassLoaderSetupAction(deploymentInfo.getClassLoader()).create((exchange, context) -> {
                            filter.createFilter();
                            return null;
                        }).call(null, null);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Can't start filter " + filter + ": " + e.getMessage(), e);
                    }
                }
                continue;
            }
            if (quick && state == DeploymentManager.State.STARTED) continue;
            if (state == DeploymentManager.State.STARTED) {
                LOG.trace("Redeploying {}", (Object)contextPath);
            }
            if (change.isDynamic()) continue;
            this.ensureServletContextStarted(contextPath);
        }
    }

    public void visitEventListenerModelChange(EventListenerModelChange change) {
        HashSet done = new HashSet();
        if (change.getKind() == OpCode.ADD) {
            EventListenerModel eventListenerModel = change.getEventListenerModel();
            List contextModels = change.getContextModels();
            contextModels.forEach(context -> {
                String contextPath = context.getContextPath();
                if (!done.add(contextPath)) {
                    return;
                }
                DeploymentManager manager = this.getDeploymentManager(contextPath);
                DeploymentInfo deploymentInfo = manager == null ? this.deploymentInfos.get(context.getContextPath()) : manager.getDeployment().getDeploymentInfo();
                EventListener eventListener = eventListenerModel.resolveEventListener();
                if (eventListener instanceof ServletContextAttributeListener) {
                    OsgiServletContext c = this.osgiServletContexts.get(context);
                    c.addServletContextAttributeListener((ServletContextAttributeListener)eventListener);
                }
                if (eventListener instanceof HttpSessionAttributeListener) {
                    this.sessionListenerModels.add(eventListenerModel);
                }
                boolean stopped = false;
                if (manager != null && manager.getState() != DeploymentManager.State.UNDEPLOYED && ServletContextListener.class.isAssignableFrom(eventListener.getClass())) {
                    this.stopUndertowContext(contextPath, manager, null, false);
                    stopped = true;
                }
                EventListener wrapper = eventListener;
                if (eventListener instanceof ServletContextListener) {
                    wrapper = this.proxiedServletContextListener(eventListener, (OsgiContextModel)context);
                }
                PaxWebListenerInfo info = new PaxWebListenerInfo(eventListener.getClass(), (InstanceFactory<? extends EventListener>)new ImmediateInstanceFactory((Object)wrapper));
                info.setModel(eventListenerModel);
                if (eventListenerModel.isDynamic()) {
                    this.orderedListeners.get(contextPath).add(info);
                    if (manager != null && manager.getState() == DeploymentManager.State.UNDEPLOYED) {
                        deploymentInfo.addListener((ListenerInfo)info);
                        manager.getDeployment().getApplicationListeners().addListener(new ManagedListener((ListenerInfo)info, eventListenerModel.isDynamic()));
                    }
                } else {
                    this.rankedListeners.get(contextPath).put(EventListenerKey.ofModel((EventListenerModel)eventListenerModel), info);
                }
                if (!ServletContextListener.class.isAssignableFrom(eventListener.getClass()) && manager != null) {
                    deploymentInfo.addListener((ListenerInfo)info);
                    manager.getDeployment().getApplicationListeners().addListener(new ManagedListener((ListenerInfo)info, eventListenerModel.isDynamic()));
                }
                if (stopped) {
                    LOG.info("Scheduling start of the {} context after listener registration for already started context", (Object)contextPath);
                    change.registerBatchCompletedAction((Change)new ContextStartChange(OpCode.MODIFY, contextPath));
                }
            });
        }
        if (change.getKind() == OpCode.DELETE) {
            List eventListenerModels = change.getEventListenerModels();
            for (EventListenerModel eventListenerModel : eventListenerModels) {
                List contextModels = eventListenerModel.getContextModels();
                contextModels.forEach(context -> {
                    String contextPath = context.getContextPath();
                    if (!done.add(contextPath)) {
                        return;
                    }
                    DeploymentManager manager = this.getDeploymentManager(contextPath);
                    DeploymentInfo deploymentInfo = manager == null ? this.deploymentInfos.get(contextPath) : manager.getDeployment().getDeploymentInfo();
                    EventListener eventListener = eventListenerModel.resolveEventListener();
                    if (eventListener instanceof ServletContextAttributeListener) {
                        OsgiServletContext c = this.osgiServletContexts.get(context);
                        c.removeServletContextAttributeListener((ServletContextAttributeListener)eventListener);
                    }
                    if (eventListener instanceof HttpSessionAttributeListener) {
                        this.sessionListenerModels.remove(eventListenerModel);
                    }
                    if (eventListenerModel.isDynamic()) {
                        if (this.orderedListeners.containsKey(contextPath)) {
                            this.orderedListeners.get(contextPath).removeIf(li -> li.getModel() == eventListenerModel);
                        }
                    } else if (this.rankedListeners.containsKey(contextPath)) {
                        this.rankedListeners.get(contextPath).remove(EventListenerKey.ofModel((EventListenerModel)eventListenerModel));
                    }
                    if (this.pendingTransaction(contextPath)) {
                        LOG.debug("Delaying removal of event listener {}", (Object)eventListenerModel);
                        return;
                    }
                    Deployment deployment = manager == null ? null : manager.getDeployment();
                    this.stopUndertowContext(contextPath, manager, deploymentInfo, false);
                    this.removeEventListenerModel(deploymentInfo, eventListenerModel, eventListener);
                    this.ensureServletContextStarted(contextPath);
                });
            }
        }
    }

    private void removeEventListenerModel(DeploymentInfo deploymentInfo, EventListenerModel eventListenerModel, EventListener eventListener) {
        if (deploymentInfo != null) {
            deploymentInfo.getListeners().removeIf(li -> {
                try {
                    return li.getInstanceFactory() instanceof ImmediateInstanceFactory && ((ImmediateInstanceFactory)li.getInstanceFactory()).createInstance().getInstance() == eventListener;
                }
                catch (InstantiationException ignored) {
                    return false;
                }
            });
        }
        eventListenerModel.releaseEventListener();
    }

    public void visitWelcomeFileModelChange(WelcomeFileModelChange change) {
        WelcomeFileModel model = change.getWelcomeFileModel();
        OpCode op = change.getKind();
        if (op == OpCode.ADD || op == OpCode.DELETE) {
            List contextModels = op == OpCode.ADD ? change.getContextModels() : model.getContextModels();
            contextModels.forEach(context -> {
                LinkedHashSet<String> currentWelcomeFiles;
                OsgiServletContext osgiServletContext = this.osgiServletContexts.get(context);
                if (osgiServletContext == null) {
                    return;
                }
                Deployment deployment = this.getDeployment(context.getContextPath());
                LinkedHashSet<String> linkedHashSet = currentWelcomeFiles = osgiServletContext.getWelcomeFiles() == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(Arrays.asList(osgiServletContext.getWelcomeFiles()));
                if (op == OpCode.ADD) {
                    currentWelcomeFiles.addAll(Arrays.asList(model.getWelcomeFiles()));
                } else if (model.getWelcomeFiles().length == 0) {
                    currentWelcomeFiles.clear();
                } else {
                    for (String s : model.getWelcomeFiles()) {
                        currentWelcomeFiles.remove(s);
                    }
                }
                String[] newWelcomeFiles = currentWelcomeFiles.toArray(new String[0]);
                osgiServletContext.setWelcomeFiles(newWelcomeFiles);
                osgiServletContext.setWelcomeFilesRedirect(model.isRedirect());
                LOG.info("Reconfiguration of welcome files for all resource servlets in context \"{}\"", context);
                if (deployment != null) {
                    for (ServletHandler sh : deployment.getServlets().getServletHandlers().values()) {
                        PaxWebServletInfo info;
                        ManagedServlet ms = sh.getManagedServlet();
                        if (ms == null || ms.getServletInfo() == null || !(ms.getServletInfo() instanceof PaxWebServletInfo) || (info = (PaxWebServletInfo)ms.getServletInfo()).getServletModel() == null || !info.getServletModel().isResourceServlet() || context != info.getOsgiContextModel()) continue;
                        if (ms.isStarted()) {
                            try {
                                Servlet servlet = (Servlet)ms.getServlet().getInstance();
                                if (servlet instanceof UndertowResourceServlet) {
                                    ((UndertowResourceServlet)servlet).setWelcomeFiles(newWelcomeFiles);
                                    ((UndertowResourceServlet)servlet).setWelcomeFilesRedirect(model.isRedirect());
                                    continue;
                                }
                                if (!(servlet instanceof OsgiInitializedServlet)) continue;
                                ((UndertowResourceServlet)((OsgiInitializedServlet)servlet).getDelegate()).setWelcomeFiles(newWelcomeFiles);
                                ((UndertowResourceServlet)((OsgiInitializedServlet)servlet).getDelegate()).setWelcomeFilesRedirect(model.isRedirect());
                            }
                            catch (ServletException e) {
                                LOG.warn("Problem reconfiguring welcome files in servlet {}", (Object)ms, (Object)e);
                            }
                            continue;
                        }
                        LOG.debug("Welcome files will be set in {} when init() is called", (Object)ms);
                    }
                }
            });
        }
    }

    public void visitErrorPageModelChange(ErrorPageModelChange change) {
    }

    public void visitErrorPageStateChange(ErrorPageStateChange change) {
        Map contextErrorPages = change.getContextErrorPages();
        for (Map.Entry entry : contextErrorPages.entrySet()) {
            DeploymentInfo deploymentInfo;
            String contextPath = (String)entry.getKey();
            TreeMap errorPageModelsMap = (TreeMap)entry.getValue();
            Set errorPageModels = errorPageModelsMap.keySet();
            LOG.info("Changing error page configuration for context {}", (Object)contextPath);
            Deployment deployment = this.getDeployment(contextPath);
            DeploymentInfo deploymentInfo2 = deploymentInfo = deployment == null ? this.deploymentInfos.get(contextPath) : deployment.getDeploymentInfo();
            if (deploymentInfo == null) {
                return;
            }
            deploymentInfo.getErrorPages().clear();
            HashMap<Integer, String> errorCodeLocations = new HashMap<Integer, String>();
            HashMap<Class<? extends Throwable>, String> exceptionMappings = new HashMap<Class<? extends Throwable>, String>();
            FlexibleErrorPages pages = new FlexibleErrorPages(errorCodeLocations, exceptionMappings, null);
            this.errorPages.put(contextPath, pages);
            for (ErrorPageModel model : errorPageModels) {
                String location = model.getLocation();
                for (String ex : model.getExceptionClassNames()) {
                    try {
                        ClassLoader cl = ((BundleWiring)model.getRegisteringBundle().adapt(BundleWiring.class)).getClassLoader();
                        Class<?> t = cl.loadClass(ex);
                        exceptionMappings.put(t, location);
                        deploymentInfo.addErrorPage(new ErrorPage(location, t));
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn("Can't load exception class {}: {}", new Object[]{ex, e.getMessage(), e});
                    }
                }
                Iterator iterator = model.getErrorCodes().iterator();
                while (iterator.hasNext()) {
                    int code = (Integer)iterator.next();
                    errorCodeLocations.put(code, location);
                    deploymentInfo.addErrorPage(new ErrorPage(location, code));
                }
                if (model.isXx4()) {
                    for (int c = 400; c < 500; ++c) {
                        errorCodeLocations.put(c, location);
                        deploymentInfo.addErrorPage(new ErrorPage(location, c));
                    }
                }
                if (!model.isXx5()) continue;
                for (int c = 500; c < 600; ++c) {
                    errorCodeLocations.put(c, location);
                    deploymentInfo.addErrorPage(new ErrorPage(location, c));
                }
            }
            if (!(deployment instanceof DeploymentImpl)) continue;
            ((DeploymentImpl)deployment).setErrorPages((ErrorPages)pages);
        }
    }

    public void visitContainerInitializerModelChange(ContainerInitializerModelChange change) {
        if (change.getKind() == OpCode.ADD) {
            ContainerInitializerModel model = change.getContainerInitializerModel();
            if (!model.isForAnyRuntime() && !model.isForUndertow()) {
                return;
            }
            List contextModels = change.getContextModels();
            contextModels.forEach(context -> {
                String path = context.getContextPath();
                DeploymentManager manager = this.getDeploymentManager(path);
                if (manager != null) {
                    this.stopUndertowContext(path, manager, null, false);
                }
                DynamicRegistrations registrations = this.dynamicRegistrations.get(path);
                OsgiDynamicServletContext dynamicContext = new OsgiDynamicServletContext(this.osgiServletContexts.get(context), registrations);
                OsgiServletContainerInitializerInfo info = new OsgiServletContainerInitializerInfo(model, dynamicContext);
                this.initializers.get(path).add(info);
            });
        }
        if (change.getKind() == OpCode.DELETE) {
            List models = change.getContainerInitializerModels();
            for (ContainerInitializerModel model : models) {
                if (!model.isForAnyRuntime() && !model.isForUndertow()) continue;
                List contextModels = model.getContextModels();
                contextModels.forEach(context -> {
                    String path = context.getContextPath();
                    TreeSet<OsgiServletContainerInitializerInfo> initializers = this.initializers.get(path);
                    if (initializers != null) {
                        initializers.removeIf(i -> i.getModel() == model);
                    }
                });
            }
        }
    }

    public void visitWebSocketModelChange(WebSocketModelChange change) {
        if (change.getKind() == OpCode.ADD && !change.isDisabled() || change.getKind() == OpCode.ENABLE) {
            WebSocketModel model = change.getWebSocketModel();
            HashSet done = new HashSet();
            change.getContextModels().forEach(osgiContextModel -> {
                String contextPath = osgiContextModel.getContextPath();
                if (!done.add(contextPath)) {
                    return;
                }
                LOG.info("Adding web socket {} to {}", (Object)model, (Object)contextPath);
                this.ensureServletContextStarted(contextPath);
            });
            return;
        }
        if (change.getKind() == OpCode.DISABLE || change.getKind() == OpCode.DELETE) {
            for (Map.Entry entry : change.getWebSocketModels().entrySet()) {
                WebSocketModel model = (WebSocketModel)entry.getKey();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                HashSet done = new HashSet();
                model.getContextModels().forEach(osgiContextModel -> {
                    String contextPath = osgiContextModel.getContextPath();
                    if (!done.add(contextPath)) {
                        return;
                    }
                    LOG.info("Removing web socket {} from context {}", (Object)model, (Object)contextPath);
                    this.ensureServletContextStarted(contextPath);
                });
            }
        }
    }

    public void visitClearDynamicRegistrationsChange(ClearDynamicRegistrationsChange change) {
        HashSet done = new HashSet();
        change.getContextModels().forEach(context -> {
            String contextPath = context.getContextPath();
            if (!done.add(contextPath)) {
                return;
            }
            this.clearDynamicRegistrations(contextPath, (OsgiContextModel)context);
        });
    }

    private void clearDynamicRegistrations(String contextPath, OsgiContextModel context) {
        LOG.debug("Removing dynamically registered servlets/filters/listeners from context {}", (Object)contextPath);
        DeploymentManager manager = this.getDeploymentManager(contextPath);
        this.stopUndertowContext(contextPath, manager, null, false);
        DeploymentInfo deploymentInfo = this.deploymentInfos.get(contextPath);
        int[] removed = new int[]{0};
        HashMap<ServletModel, Boolean> toRemove = new HashMap<ServletModel, Boolean>();
        for (ServletInfo info : deploymentInfo.getServlets().values()) {
            ServletModel model2;
            if (!(info instanceof PaxWebServletInfo) || (model2 = ((PaxWebServletInfo)info).getServletModel()) == null || !model2.isDynamic()) continue;
            toRemove.put(model2, Boolean.TRUE);
            removed[0] = removed[0] + 1;
        }
        if (!toRemove.isEmpty()) {
            this.visitServletModelChange(new ServletModelChange(OpCode.DELETE, toRemove, true));
        }
        deploymentInfo = this.undertowFactory.clearFilters(deploymentInfo, true, false);
        this.deploymentInfos.put(contextPath, deploymentInfo);
        DynamicRegistrations contextRegistrations = this.dynamicRegistrations.get(contextPath);
        if (contextRegistrations != null) {
            DeploymentInfo finalDeploymentInfo = deploymentInfo;
            contextRegistrations.getDynamicListenerModels().forEach((listenerToRemove, model) -> {
                if (model.isDynamic()) {
                    OsgiServletContext c;
                    removed[0] = removed[0] + 1;
                    if (listenerToRemove instanceof ServletContextAttributeListener && (c = this.osgiServletContexts.get(context)) != null) {
                        c.removeServletContextAttributeListener((ServletContextAttributeListener)listenerToRemove);
                    }
                    finalDeploymentInfo.getListeners().removeIf(li -> {
                        try {
                            return li.getInstanceFactory() instanceof ImmediateInstanceFactory && ((ImmediateInstanceFactory)li.getInstanceFactory()).createInstance().getInstance() == listenerToRemove;
                        }
                        catch (InstantiationException ignored) {
                            return false;
                        }
                    });
                }
            });
            OsgiContextModel highestRanked = this.securityHandlers.get(contextPath).getDefaultOsgiContextModel();
            OsgiServletContext highestRankedContext = this.osgiServletContexts.get(highestRanked);
            ServiceLoader<PaxWebUndertowExtension> extensions = ServiceLoader.load(PaxWebUndertowExtension.class, highestRankedContext.getClassLoader());
            for (PaxWebUndertowExtension extension : extensions) {
                extension.cleanDeployment(deploymentInfo);
            }
            contextRegistrations.getDynamicListenerModels().clear();
            contextRegistrations.getDynamicServletRegistrations().clear();
            contextRegistrations.getDynamicFilterRegistrations().clear();
            contextRegistrations.getDynamicListenerRegistrations().clear();
        }
        if (removed[0] > 0) {
            LOG.debug("Removed {} dynamically registered servlets/filters/listeners from context {}", (Object)removed[0], (Object)contextPath);
        }
    }

    public void visitContextStartChange(ContextStartChange change) {
        String contextPath = change.getContextPath();
        this.ensureServletContextStarted(contextPath);
    }

    public void visitContextStopChange(ContextStopChange change) {
        String contextPath = change.getContextPath();
        DeploymentManager manager = this.getDeploymentManager(contextPath);
        this.stopUndertowContext(contextPath, manager, null, false);
    }

    public void visitContextParamsChange(ContextParamsChange change) {
        if (change.getKind() == OpCode.ADD) {
            LOG.info("Adding init parameters to {}: {}", (Object)change.getOsgiContextModel(), (Object)change.getParams());
            change.getOsgiContextModel().getContextParams().putAll(change.getParams());
        } else {
            LOG.info("Removing init parameters from {}: {}", (Object)change.getOsgiContextModel(), (Object)change.getParams());
            change.getParams().keySet().forEach(param -> change.getOsgiContextModel().getContextParams().remove(param));
        }
    }

    public void visitSecurityConfigChange(SecurityConfigChange change) {
        LoginConfigModel loginConfigModel = change.getLoginConfigModel();
        List securityRoles = change.getSecurityRoles();
        List securityConstraints = change.getSecurityConstraints();
        OsgiContextModel ocm = change.getOsgiContextModel();
        if (change.getKind() == OpCode.ADD) {
            LOG.info("Adding security configuration to {}", (Object)ocm);
            ocm.getSecurityConfiguration().setLoginConfig(loginConfigModel);
            ocm.getSecurityConfiguration().getSecurityRoles().addAll(securityRoles);
            ocm.getSecurityConfiguration().getSecurityConstraints().addAll(securityConstraints);
            this.contextSecurityConstraints.computeIfAbsent(ocm.getContextPath(), c -> new TreeMap()).put(ocm, ocm.getSecurityConfiguration());
        } else {
            LOG.info("Removing security configuration from {}", (Object)ocm);
            ocm.getSecurityConfiguration().setLoginConfig(null);
            securityRoles.forEach(ocm.getSecurityConfiguration().getSecurityRoles()::remove);
            securityConstraints.forEach(sc -> ocm.getSecurityConfiguration().getSecurityConstraints().removeIf(scm -> scm.getName().equals(sc.getName())));
            TreeMap<OsgiContextModel, SecurityConfigurationModel> constraints = this.contextSecurityConstraints.get(ocm.getContextPath());
            constraints.remove(ocm);
        }
    }

    private void ensureServletContextStarted(String contextPath) {
        DeploymentManager manager = this.getDeploymentManager(contextPath);
        if (manager != null || this.pendingTransaction(contextPath) || !this.deploymentInfos.containsKey(contextPath) || this.securityHandlers.get(contextPath).getDefaultOsgiContextModel() == null) {
            return;
        }
        try {
            ArrayList<String> connectors;
            LoginConfigModel lc;
            OsgiContextModel highestRanked = this.securityHandlers.get(contextPath).getDefaultOsgiContextModel();
            OsgiServletContext highestRankedContext = this.osgiServletContexts.get(highestRanked);
            highestRankedContext.allowServletContextListeners();
            OsgiDynamicServletContext highestRankedDynamicContext = new OsgiDynamicServletContext(highestRankedContext, this.dynamicRegistrations.get(contextPath));
            LOG.info("Starting Undertow context \"{}\" with default Osgi Context {}", (Object)(contextPath.equals("") ? "/" : contextPath), (Object)highestRanked);
            DynamicRegistrations registrations = this.dynamicRegistrations.get(contextPath);
            highestRankedContext.clearAttributesFromPreviousCycle();
            this.clearDynamicRegistrations(contextPath, highestRanked);
            DeploymentInfo deployment = this.deploymentInfos.get(contextPath);
            deployment.getServletExtensions().removeIf(e -> e instanceof ContextLinkingServletExtension);
            deployment.addServletExtension((ServletExtension)new ContextLinkingServletExtension(contextPath, highestRankedContext, highestRankedDynamicContext));
            if (highestRankedContext.getClassLoader() != null) {
                deployment.setClassLoader(highestRankedContext.getClassLoader());
            }
            deployment.setResourceManager((ResourceManager)new OsgiResourceManager("", (ServletContext)highestRankedContext));
            ServiceLoader<PaxWebUndertowExtension> extensions = ServiceLoader.load(PaxWebUndertowExtension.class, highestRankedContext.getClassLoader());
            for (PaxWebUndertowExtension paxWebUndertowExtension : extensions) {
                paxWebUndertowExtension.handleDeployment(deployment, this.undertowConfiguration, this, highestRanked);
            }
            deployment.getServletContainerInitializers().clear();
            TreeSet initializers = new TreeSet(this.initializers.get(contextPath));
            for (OsgiServletContainerInitializerInfo info : initializers) {
                deployment.addServletContainerInitializers(new ServletContainerInitializerInfo[]{info});
            }
            RegisteringContainerInitializer registeringContainerInitializer = new RegisteringContainerInitializer(highestRankedContext, registrations);
            deployment.addServletContainerInitializers(new ServletContainerInitializerInfo[]{new OsgiServletContainerInitializerInfo(registeringContainerInitializer)});
            deployment.setSessionIdGenerator((SessionIdGenerator)new PaxWebSessionIdGenerator());
            deployment.setSessionConfigWrapper(new SessionConfigWrapper(){

                public SessionConfig wrap(final SessionConfig sessionConfig, Deployment deployment) {
                    return new SessionConfig(){

                        public void setSessionId(HttpServerExchange exchange, String sessionId) {
                            String prefix = PaxWebSessionIdGenerator.sessionIdPrefix.get();
                            if (prefix != null) {
                                sessionId = sessionId.substring(prefix.length() + 1);
                            }
                            sessionConfig.setSessionId(exchange, sessionId);
                        }

                        public void clearSession(HttpServerExchange exchange, String sessionId) {
                            sessionConfig.clearSession(exchange, sessionId);
                        }

                        public String findSessionId(HttpServerExchange exchange) {
                            ServletRequestContext ctx;
                            String prefix = PaxWebSessionIdGenerator.sessionIdPrefix.get();
                            String id = sessionConfig.findSessionId(exchange);
                            if (id != null && prefix == null && (ctx = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)) != null && ctx.getCurrentServlet() != null && ctx.getCurrentServlet().getManagedServlet() != null && ctx.getCurrentServlet().getManagedServlet().getServletInfo() instanceof PaxWebServletInfo) {
                                PaxWebServletInfo paxWebServletInfo = (PaxWebServletInfo)ctx.getCurrentServlet().getManagedServlet().getServletInfo();
                                OsgiContextModel osgiContextModel = !paxWebServletInfo.is404() ? paxWebServletInfo.getServletContext().getOsgiContextModel() : paxWebServletInfo.getOsgiContextModel();
                                String string = prefix = osgiContextModel == null ? null : osgiContextModel.getTemporaryLocation().replaceAll("/", "_");
                            }
                            if (prefix != null && id != null) {
                                return prefix + "~" + id;
                            }
                            return id;
                        }

                        public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
                            return sessionConfig.sessionCookieSource(exchange);
                        }

                        public String rewriteUrl(String originalUrl, String sessionId) {
                            return sessionConfig.rewriteUrl(originalUrl, sessionId);
                        }
                    };
                }
            });
            deployment.setSessionManagerFactory((SessionManagerFactory)new InMemorySessionManagerFactory());
            SessionConfigurationModel session = highestRanked.getSessionConfiguration();
            if (session != null) {
                if (session.getSessionTimeout() != null) {
                    deployment.setDefaultSessionTimeout(session.getSessionTimeout() * 60);
                }
                SessionCookieConfig scc = session.getSessionCookieConfig();
                ServletSessionConfig ssc = deployment.getServletSessionConfig();
                if (scc != null) {
                    if (ssc == null) {
                        ssc = new ServletSessionConfig();
                        deployment.setServletSessionConfig(ssc);
                    }
                    if (scc.getName() != null) {
                        ssc.setName(scc.getName());
                    }
                    if (scc.getDomain() != null) {
                        ssc.setDomain(scc.getDomain());
                    }
                    if (scc.getPath() != null) {
                        ssc.setPath(scc.getPath());
                    }
                    ssc.setMaxAge(scc.getMaxAge());
                    ssc.setHttpOnly(scc.isHttpOnly());
                    ssc.setSecure(scc.isSecure());
                    ssc.setComment(scc.getComment());
                    if (session.getTrackingModes().size() > 0) {
                        ssc.setSessionTrackingModes(session.getTrackingModes());
                    }
                }
            }
            Map<OsgiContextModel, SecurityConfigurationModel> allSecConfigs = (Map<OsgiContextModel, SecurityConfigurationModel>)this.contextSecurityConstraints.get(contextPath);
            SecurityConfigurationModel securityConfig = null;
            if (allSecConfigs != null && allSecConfigs.size() > 0) {
                securityConfig = (SecurityConfigurationModel)allSecConfigs.values().iterator().next();
            }
            if (securityConfig == null) {
                securityConfig = highestRanked.getSecurityConfiguration();
                allSecConfigs = Collections.singletonMap(highestRanked, securityConfig);
            }
            LoginConfigModel loginConfigModel = lc = securityConfig != null ? securityConfig.getLoginConfig() : null;
            if (lc == null) {
                deployment.setLoginConfig(null);
            } else {
                Object customAuthenticator;
                String authMethod = lc.getAuthMethod();
                String realmName = lc.getRealmName();
                if (("BASIC".equals(authMethod) || "DIGEST".equals(authMethod)) && realmName == null) {
                    realmName = "default";
                }
                if ((customAuthenticator = this.getAuthenticator(authMethod.toUpperCase())) != null) {
                    LOG.debug("Setting custom Undertow authenticator {}", customAuthenticator);
                    deployment.getServletExtensions().add(customAuthenticator);
                }
                deployment.setLoginConfig(new LoginConfig(authMethod, realmName, lc.getFormLoginPage(), lc.getFormErrorPage()));
            }
            deployment.getSecurityRoles().clear();
            deployment.getSecurityConstraints().clear();
            ArrayList allConstraints = new ArrayList();
            LinkedHashSet allRoles = new LinkedHashSet();
            if (allSecConfigs != null) {
                allSecConfigs.values().forEach(sc -> {
                    allConstraints.addAll(sc.getSecurityConstraints());
                    allRoles.addAll(sc.getSecurityRoles());
                });
            }
            deployment.addSecurityRoles(allRoles);
            for (SecurityConstraintModel constraintModel : allConstraints) {
                SecurityConstraint constraint = new SecurityConstraint();
                if (constraintModel.isAuthRolesSet()) {
                    constraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.AUTHENTICATE);
                }
                constraint.addRolesAllowed((Collection)constraintModel.getAuthRoles());
                if (constraintModel.getTransportGuarantee() == ServletSecurity.TransportGuarantee.NONE) {
                    constraint.setTransportGuaranteeType(TransportGuaranteeType.NONE);
                } else if (constraintModel.getTransportGuarantee() == ServletSecurity.TransportGuarantee.CONFIDENTIAL) {
                    constraint.setTransportGuaranteeType(TransportGuaranteeType.CONFIDENTIAL);
                }
                for (SecurityConstraintModel.WebResourceCollection col : constraintModel.getWebResourceCollections()) {
                    WebResourceCollection wrc = new WebResourceCollection();
                    boolean methodSet = false;
                    wrc.addHttpMethods((Collection)col.getMethods());
                    if (col.getMethods().size() == 0) {
                        wrc.addHttpMethodOmissions((Collection)col.getOmittedMethods());
                    }
                    wrc.addUrlPatterns((Collection)col.getPatterns());
                    constraint.addWebResourceCollection(wrc);
                }
                deployment.addSecurityConstraint(constraint);
            }
            for (int pos = 0; pos < this.orderedListeners.get(contextPath).size(); ++pos) {
                PaxWebListenerInfo li = this.orderedListeners.get(contextPath).get(pos);
                this.rankedListeners.get(contextPath).put(EventListenerKey.ofPosition((int)pos), li);
            }
            for (PaxWebListenerInfo li : this.rankedListeners.get(contextPath).values()) {
                deployment.addListener((ListenerInfo)li);
            }
            ArrayList<String> allVirtualHosts = new ArrayList<String>();
            ArrayList<String> vhosts = new ArrayList<String>(highestRanked.getVirtualHosts());
            if (vhosts.isEmpty()) {
                vhosts.addAll(Arrays.asList(this.configuration.server().getVirtualHosts()));
            }
            if ((connectors = new ArrayList<String>(highestRanked.getConnectors())).isEmpty()) {
                connectors.addAll(Arrays.asList(this.configuration.server().getConnectors()));
            }
            for (String vhost : vhosts) {
                if (vhost == null || "".equals(vhost.trim())) continue;
                if (vhost.startsWith("@")) {
                    allVirtualHosts.add(vhost);
                    continue;
                }
                allVirtualHosts.add(vhost);
            }
            for (String c : connectors) {
                if (c == null || "".equals(c.trim())) continue;
                if (c.startsWith("@")) {
                    allVirtualHosts.add(c);
                    continue;
                }
                allVirtualHosts.add("@" + c);
            }
            PaxWebOuterHandlerWrapper handlerWrapper = this.wrappingHandlers.get(contextPath);
            if (handlerWrapper != null) {
                handlerWrapper.setVirtualHosts(allVirtualHosts.toArray(new String[0]));
            }
            manager = this.servletContainer.addDeployment(deployment);
            manager.deploy();
            HttpHandler handler = manager.start();
            for (PreprocessorFilterConfig fc : this.preprocessorsHandlers.get(contextPath).getPreprocessors()) {
                if (fc.isInitCalled()) continue;
                fc.getInstance().init((FilterConfig)fc);
                fc.setInitCalled(true);
            }
            highestRankedDynamicContext.rememberAttributesFromSCIs();
            this.pathHandler.addPrefixPath(contextPath, handler);
        }
        catch (ServletException e2) {
            throw new IllegalStateException("Can't start Undertow context " + contextPath + ": " + e2.getMessage(), e2);
        }
    }

    private boolean pendingTransaction(String contextPath) {
        return this.transactions.contains(contextPath);
    }

    private ServletContext getRealServletContext(String contextPath) {
        Deployment deployment = this.getDeployment(contextPath);
        return deployment == null ? null : deployment.getServletContext();
    }

    private Deployment getDeployment(String contextPath) {
        DeploymentManager deploymentManager = this.getDeploymentManager(contextPath);
        if (deploymentManager == null || deploymentManager.getDeployment() == null) {
            return null;
        }
        return deploymentManager.getDeployment();
    }

    private DeploymentManager getDeploymentManager(String contextPath) {
        String path = contextPath.equals("") ? "/" : contextPath;
        DeploymentManager deploymentManager = this.servletContainer.getDeploymentByPath(path);
        if (deploymentManager == null || deploymentManager.getDeployment() == null) {
            return null;
        }
        if (!deploymentManager.getDeployment().getDeploymentInfo().getContextPath().equals(path)) {
            return null;
        }
        return deploymentManager;
    }

    private boolean canQuicklyAddFilter(DeploymentInfo deploymentInfo, Set<FilterModel> filters) {
        boolean quick;
        FilterInfo[] existingFilters = deploymentInfo.getFilters().values().toArray(new FilterInfo[0]);
        FilterModel[] newFilters = filters.toArray(new FilterModel[0]);
        boolean bl = quick = existingFilters.length <= newFilters.length;
        for (int pos = 0; quick && pos < existingFilters.length; ++pos) {
            if (!(existingFilters[pos] instanceof PaxWebFilterInfo)) {
                quick = false;
                break;
            }
            PaxWebFilterInfo fi = (PaxWebFilterInfo)existingFilters[pos];
            if (fi.getFilterModel() != null && fi.getFilterModel().equals((Object)newFilters[pos])) continue;
            quick = false;
            break;
        }
        return quick;
    }

    private void configureFilterMappings(FilterModel model, DeploymentInfo deploymentInfo) {
        String filterName = model.getName();
        if (model.isDynamic()) {
            model.getDynamicServletNames().forEach(dm -> {
                if (!dm.isAfter()) {
                    for (DispatcherType dt : dm.getDispatcherTypes()) {
                        for (String sn : dm.getServletNames()) {
                            deploymentInfo.insertFilterServletNameMapping(0, filterName, sn, dt);
                        }
                    }
                }
            });
            model.getDynamicUrlPatterns().forEach(dm -> {
                if (!dm.isAfter()) {
                    for (DispatcherType dt : dm.getDispatcherTypes()) {
                        for (String pattern : dm.getUrlPatterns()) {
                            deploymentInfo.insertFilterUrlMapping(0, filterName, pattern, dt);
                        }
                    }
                }
            });
            model.getDynamicServletNames().forEach(dm -> {
                if (dm.isAfter()) {
                    for (DispatcherType dt : dm.getDispatcherTypes()) {
                        for (String sn : dm.getServletNames()) {
                            deploymentInfo.addFilterServletNameMapping(filterName, sn, dt);
                        }
                    }
                }
            });
            model.getDynamicUrlPatterns().forEach(dm -> {
                if (dm.isAfter()) {
                    for (DispatcherType dt : dm.getDispatcherTypes()) {
                        for (String pattern : dm.getUrlPatterns()) {
                            deploymentInfo.addFilterUrlMapping(filterName, pattern, dt);
                        }
                    }
                }
            });
        } else {
            for (FilterModel.Mapping mapping : model.getMappingsPerDispatcherTypes()) {
                for (DispatcherType dt : mapping.getDispatcherTypes()) {
                    if (mapping.getRegexPatterns() != null && mapping.getRegexPatterns().length > 0) {
                        deploymentInfo.addFilterUrlMapping(filterName, "/*", dt);
                    } else if (mapping.getUrlPatterns() != null) {
                        for (String pattern : mapping.getUrlPatterns()) {
                            deploymentInfo.addFilterUrlMapping(filterName, pattern, dt);
                        }
                    }
                    if (mapping.getServletNames() == null) continue;
                    for (String name : mapping.getServletNames()) {
                        deploymentInfo.addFilterServletNameMapping(filterName, name, dt);
                    }
                }
            }
        }
    }

    private void stopUndertowContext(String contextPath, DeploymentManager manager, DeploymentInfo deploymentInfo, boolean skipPreprocessors) {
        this.pathHandler.removePrefixPath(contextPath);
        try {
            if (manager != null) {
                LOG.info("Stopping Undertow context \"{}\"", (Object)contextPath);
                if (!skipPreprocessors) {
                    for (PreprocessorFilterConfig fc : this.preprocessorsHandlers.get(contextPath).getPreprocessors()) {
                        if (!fc.isInitCalled()) continue;
                        fc.destroy();
                        fc.setInitCalled(false);
                    }
                }
                manager.stop();
                manager.undeploy();
            }
            if (deploymentInfo != null) {
                this.deploymentInfos.put(contextPath, deploymentInfo);
            }
        }
        catch (ServletException e2) {
            LOG.warn("Error stopping Undertow context \"{}\": {}", new Object[]{contextPath, e2.getMessage(), e2});
        }
        if (this.deploymentInfos.containsKey(contextPath)) {
            this.rankedListeners.get(contextPath).entrySet().removeIf(e -> ((EventListenerKey)e.getKey()).getRanklessPosition() >= 0);
            this.orderedListeners.get(contextPath).clear();
            this.deploymentInfos.get(contextPath).getListeners().clear();
        }
    }

    private ServletExtension getAuthenticator(String method) {
        ServiceLoader<AuthenticatorService> sl = ServiceLoader.load(AuthenticatorService.class, this.getClass().getClassLoader());
        for (AuthenticatorService svc : sl) {
            try {
                ServletExtension auth = (ServletExtension)svc.getAuthenticatorService(method, ServletExtension.class);
                if (auth == null) continue;
                return auth;
            }
            catch (Throwable t) {
                LOG.debug("Unable to load AuthenticatorService for: " + method, t);
            }
        }
        return null;
    }

    private class ContextLinkingServletExtension
    implements ServletExtension {
        private final String contextPath;
        private final OsgiServletContext osgiContext;
        private final OsgiDynamicServletContext osgiDynamicContext;

        ContextLinkingServletExtension(String contextPath, OsgiServletContext osgiContext, OsgiDynamicServletContext osgiDynamicContext) {
            this.contextPath = contextPath;
            this.osgiContext = osgiContext;
            this.osgiDynamicContext = osgiDynamicContext;
        }

        public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
            for (ListenerInfo lInfo : deploymentInfo.getListeners()) {
                try {
                    InvocationHandler ih;
                    InstanceHandle handle = lInfo.getInstanceFactory().createInstance();
                    EventListener el = (EventListener)handle.getInstance();
                    if (!Proxy.isProxyClass(el.getClass()) || !((ih = Proxy.getInvocationHandler(el)) instanceof ContextLinkingInvocationHandler)) continue;
                    if (lInfo.isProgramatic()) {
                        ((ContextLinkingInvocationHandler)ih).setOsgiContext((ServletContext)this.osgiContext);
                        continue;
                    }
                    ((ContextLinkingInvocationHandler)ih).setOsgiContext((ServletContext)this.osgiDynamicContext);
                }
                catch (InstantiationException instantiationException) {}
            }
            UndertowServerWrapper.this.osgiServletContexts.forEach((ocm, osc) -> {
                if (ocm.getContextPath().equals(this.contextPath)) {
                    osc.setContainerServletContext(servletContext);
                }
            });
        }
    }

    private static class ContextLinkingInvocationHandler
    implements InvocationHandler {
        private final EventListener eventListener;
        private ServletContext osgiContext;

        ContextLinkingInvocationHandler(EventListener eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.osgiContext != null) {
                if (method.getName().equals("contextInitialized")) {
                    return method.invoke((Object)this.eventListener, new ServletContextEvent(this.osgiContext));
                }
                if (method.getName().equals("contextDestroyed")) {
                    return method.invoke((Object)this.eventListener, new ServletContextEvent(this.osgiContext));
                }
            }
            return method.invoke((Object)this.eventListener, args);
        }

        public void setOsgiContext(ServletContext osgiContext) {
            this.osgiContext = osgiContext;
        }
    }

    private class SimpleConfidentialPortManager
    implements ConfidentialPortManager {
        private SimpleConfidentialPortManager() {
        }

        public int getConfidentialPort(HttpServerExchange exchange) {
            Integer mappedPort;
            int port = ((InetSocketAddress)exchange.getConnection().getLocalAddress(InetSocketAddress.class)).getPort();
            if (port < 0) {
                LOG.debug("Confidential port not defined for port {}", (Object)port);
            }
            if ((mappedPort = (Integer)UndertowServerWrapper.this.securePortMapping.get(port)) == null) {
                return -1;
            }
            return mappedPort;
        }
    }
}

