/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.common.api;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.WritableObject;

public enum LogicalDatastoreType implements WritableObject
{
    OPERATIONAL(1),
    CONFIGURATION(2);

    private int serialized;

    private LogicalDatastoreType(int serialized) {
        this.serialized = serialized;
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.serialized);
    }

    public static @NonNull LogicalDatastoreType readFrom(DataInput in) throws IOException {
        byte serialized = in.readByte();
        return switch (serialized) {
            case 1 -> OPERATIONAL;
            case 2 -> CONFIGURATION;
            default -> throw new IOException("Unknown type " + serialized);
        };
    }
}

