/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.List;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractAugmentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ChoiceGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeSchemaTreeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.StatementNamespace;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.rt.DefaultCaseRuntimeType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class CaseGenerator
extends CompositeSchemaTreeGenerator<CaseEffectiveStatement, CaseRuntimeType> {
    CaseGenerator(CaseEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.CASE;
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        ChoiceGenerator choice;
        AbstractCompositeGenerator<?, ?> parent = this.getParent();
        if (parent instanceof AbstractAugmentGenerator) {
            AbstractAugmentGenerator augGen = (AbstractAugmentGenerator)parent;
            AbstractCompositeGenerator<?, ?> target = augGen.targetGenerator();
            Verify.verify((boolean)(target instanceof ChoiceGenerator), (String)"Unexpected parent augment %s target %s", parent, target);
            choice = (ChoiceGenerator)target;
        } else {
            Verify.verify((boolean)(parent instanceof ChoiceGenerator), (String)"Unexpected parent %s", parent);
            choice = (ChoiceGenerator)parent;
        }
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.addImplementsType((Type)choice.getGeneratedType(builderFactory));
        builder.addImplementsType((Type)BindingTypes.DATA_OBJECT);
        CaseGenerator.addAugmentable(builder);
        this.addUsesInterfaces(builder, builderFactory);
        CaseGenerator.addConcreteInterfaceMethods(builder);
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, this.localName());
        this.addGetterMethods(builder, builderFactory);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        return builder.build();
    }

    @Override
    CompositeRuntimeTypeBuilder<CaseEffectiveStatement, CaseRuntimeType> createBuilder(CaseEffectiveStatement statement) {
        return new CompositeRuntimeTypeBuilder<CaseEffectiveStatement, CaseRuntimeType>(statement){

            @Override
            CaseRuntimeType build(GeneratedType generatedType, CaseEffectiveStatement statement, List<RuntimeType> childTypes, List<AugmentRuntimeType> augmentTypes) {
                return new DefaultCaseRuntimeType(generatedType, statement, childTypes, augmentTypes);
            }
        };
    }
}

