/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CollisionDomain;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleNamingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.reactor.StatementNamespace;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.rt.DefaultModuleRuntimeType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ModuleRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public final class ModuleGenerator
extends AbstractCompositeGenerator<ModuleEffectiveStatement, ModuleRuntimeType> {
    private final @NonNull JavaTypeName yangModuleInfo = JavaTypeName.create((String)this.javaPackage(), (String)"$YangModuleInfoImpl");
    private final CollisionDomain.Member prefixMember;

    ModuleGenerator(ModuleEffectiveStatement statement) {
        super(statement);
        this.prefixMember = this.domain().addPrefix(this, new ModuleNamingStrategy((AbstractQName)statement.argument()));
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.DATA_ROOT;
    }

    @Override
    ModuleGenerator currentModule() {
        return this;
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
    }

    @Override
    String createJavaPackage() {
        return BindingMapping.getRootPackageName((QNameModule)((ModuleEffectiveStatement)this.statement()).localQNameModule());
    }

    @Override
    AbstractCompositeGenerator<?, ?> getPackageParent() {
        return this;
    }

    @Override
    CollisionDomain parentDomain() {
        return this.domain();
    }

    @Override
    CollisionDomain.Member createMember(CollisionDomain domain) {
        return domain.addSecondary(this, this.prefixMember, "Data");
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)this.statement()).argument()).getLocalName());
        builder.addImplementsType((Type)BindingTypes.DATA_ROOT);
        int usesCount = this.addUsesInterfaces(builder, builderFactory);
        if (usesCount > 1) {
            ModuleGenerator.narrowImplementedInterface(builder);
        }
        this.addGetterMethods(builder, builderFactory);
        builderFactory.addCodegenInformation((ModuleEffectiveStatement)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        return builder.build();
    }

    @NonNull CollisionDomain.Member getPrefixMember() {
        return (CollisionDomain.Member)Verify.verifyNotNull((Object)this.prefixMember);
    }

    void addQNameConstant(GeneratedTypeBuilderBase<?> builder, AbstractQName localName) {
        builder.addConstant((Type)BindingTypes.QNAME, "QNAME", Map.entry(this.yangModuleInfo, localName.getLocalName()));
    }

    void addNameConstant(GeneratedTypeBuilderBase<?> builder, String templateName) {
        builder.addConstant((Type)BindingTypes.YANG_DATA_NAME, "NAME", Map.entry(this.yangModuleInfo, templateName));
    }

    @Override
    CompositeRuntimeTypeBuilder<ModuleEffectiveStatement, ModuleRuntimeType> createBuilder(ModuleEffectiveStatement statement) {
        return new CompositeRuntimeTypeBuilder<ModuleEffectiveStatement, ModuleRuntimeType>(statement){

            @Override
            ModuleRuntimeType build(GeneratedType type, ModuleEffectiveStatement statement, List<RuntimeType> children, List<AugmentRuntimeType> augments) {
                Verify.verify((boolean)augments.isEmpty(), (String)"Unexpected augments %s", augments);
                return new DefaultModuleRuntimeType(type, statement, children);
            }
        };
    }
}

