/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.TransactionDatastoreMismatchException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionFactory;

public abstract class AbstractDOMBrokerTransaction<T extends DOMStoreTransaction>
implements DOMDataTreeTransaction {
    private static final VarHandle BACKING_TX;
    private final @NonNull Object identifier;
    private final Map<LogicalDatastoreType, ? extends DOMStoreTransactionFactory> storeTxFactories;
    private volatile Map.Entry<LogicalDatastoreType, T> backingTx;

    protected AbstractDOMBrokerTransaction(Object identifier, Map<LogicalDatastoreType, ? extends DOMStoreTransactionFactory> storeTxFactories) {
        this.identifier = Objects.requireNonNull(identifier, "Identifier should not be null");
        this.storeTxFactories = Objects.requireNonNull(storeTxFactories, "Store Transaction Factories should not be null");
        Preconditions.checkArgument((!storeTxFactories.isEmpty() ? 1 : 0) != 0, (Object)"Store Transaction Factories should not be empty");
    }

    protected final T getSubtransaction(LogicalDatastoreType datastoreType) {
        LogicalDatastoreType expected;
        Objects.requireNonNull(datastoreType, "datastoreType must not be null.");
        Map.Entry entry = this.backingTx;
        if (entry == null) {
            if (!this.storeTxFactories.containsKey(datastoreType)) {
                throw new IllegalArgumentException(datastoreType + " is not supported");
            }
            T tx = this.createTransaction(datastoreType);
            Map.Entry<LogicalDatastoreType, T> newEntry = Map.entry(datastoreType, tx);
            Map.Entry witness = BACKING_TX.compareAndExchange(this, null, newEntry);
            if (witness != null) {
                tx.close();
                entry = witness;
            } else {
                entry = newEntry;
            }
        }
        if ((expected = entry.getKey()) != datastoreType) {
            throw new TransactionDatastoreMismatchException(expected, datastoreType);
        }
        return (T)((DOMStoreTransaction)entry.getValue());
    }

    protected T getSubtransaction() {
        Map.Entry<LogicalDatastoreType, T> entry = this.backingTx;
        return (T)(entry == null ? null : (DOMStoreTransaction)entry.getValue());
    }

    protected abstract T createTransaction(LogicalDatastoreType var1);

    public Object getIdentifier() {
        return this.identifier;
    }

    protected void closeSubtransaction() {
        if (this.backingTx != null) {
            try {
                ((DOMStoreTransaction)this.backingTx.getValue()).close();
            }
            catch (Exception e) {
                throw new IllegalStateException("Uncaught exception occurred during closing transaction", e);
            }
        }
    }

    protected DOMStoreTransactionFactory getTxFactory(LogicalDatastoreType type) {
        return this.storeTxFactories.get(type);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("identifier", this.identifier);
    }

    static {
        try {
            BACKING_TX = MethodHandles.lookup().findVarHandle(AbstractDOMBrokerTransaction.class, "backingTx", Map.Entry.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

