/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import java.lang.ref.Cleaner;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ClientBackedTransaction<T extends AbstractClientHandle<?>>
extends AbstractDOMStoreTransaction<TransactionIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientBackedTransaction.class);
    private static final Cleaner CLEANER = Cleaner.create();
    private final T delegate;
    private final Cleaner.Cleanable cleanable;

    ClientBackedTransaction(T delegate, Throwable allocationContext) {
        super((Object)((AbstractClientHandle)delegate).getIdentifier());
        this.delegate = (AbstractClientHandle)Objects.requireNonNull(delegate);
        this.cleanable = CLEANER.register((Object)this, new Cleanup((AbstractClientHandle<?>)delegate, allocationContext));
    }

    public void close() {
        ((AbstractClientHandle)this.delegate).abort();
        this.cleanable.clean();
    }

    final T delegate() {
        return this.delegate;
    }

    private static final class Cleanup
    implements Runnable {
        private final AbstractClientHandle<?> transaction;
        private final Throwable allocationContext;

        Cleanup(AbstractClientHandle<?> transaction, Throwable allocationContext) {
            this.transaction = transaction;
            this.allocationContext = allocationContext;
        }

        @Override
        public void run() {
            if (this.transaction.abort()) {
                LOG.info("Aborted orphan transaction {}", this.transaction, (Object)this.allocationContext);
            }
        }
    }
}

