/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.annotations.Beta;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.databroker.CommitStatsMXBeanImpl;
import org.opendaylight.controller.cluster.databroker.ConcurrentDOMDataBroker;
import org.opendaylight.controller.md.sal.common.util.jmx.ThreadExecutorStatsMXBeanImpl;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.spi.store.DOMStore;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.util.concurrent.SpecialExecutors;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true, configurationPid={"org.opendaylight.controller.cluster.datastore.broker"}, property={"type=default"})
@Designate(ocd=Config.class)
public final class OSGiDOMDataBroker
implements DOMDataBroker {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiDOMDataBroker.class);
    @Reference(target="(type=distributed-config)")
    DOMStore configDatastore = null;
    @Reference(target="(type=distributed-operational)")
    DOMStore operDatastore = null;
    private ExecutorService executorService;
    private ConcurrentDOMDataBroker delegate;
    private CommitStatsMXBeanImpl commitStats;
    private ThreadExecutorStatsMXBeanImpl threadStats;

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        return this.delegate.newReadOnlyTransaction();
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        return this.delegate.newWriteOnlyTransaction();
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        return this.delegate.newReadWriteTransaction();
    }

    public ClassToInstanceMap<DOMDataBrokerExtension> getExtensions() {
        return this.delegate.getExtensions();
    }

    public DOMTransactionChain createTransactionChain(DOMTransactionChainListener listener) {
        return this.delegate.createTransactionChain(listener);
    }

    public DOMTransactionChain createMergingTransactionChain(DOMTransactionChainListener listener) {
        return this.delegate.createMergingTransactionChain(listener);
    }

    @Activate
    void activate(Config config) {
        LOG.info("DOM Data Broker starting");
        DurationStatisticsTracker commitStatsTracker = DurationStatisticsTracker.createConcurrent();
        this.executorService = SpecialExecutors.newBlockingBoundedCachedThreadPool((int)config.callbackPoolSize(), (int)config.callbackQueueSize(), (String)"CommitFutures", ConcurrentDOMDataBroker.class);
        this.delegate = new ConcurrentDOMDataBroker((Map<LogicalDatastoreType, DOMStore>)ImmutableMap.of((Object)LogicalDatastoreType.CONFIGURATION, (Object)this.configDatastore, (Object)LogicalDatastoreType.OPERATIONAL, (Object)this.operDatastore), this.executorService, commitStatsTracker);
        this.commitStats = new CommitStatsMXBeanImpl(commitStatsTracker, "DOMDataBroker");
        this.commitStats.register();
        this.threadStats = ThreadExecutorStatsMXBeanImpl.create((Executor)this.executorService, (String)"CommitFutureExecutorStats", (String)"DOMDataBroker");
        LOG.info("DOM Data Broker started");
    }

    @Deactivate
    void deactivate() {
        LOG.info("DOM Data Broker stopping");
        this.commitStats.unregister();
        if (this.threadStats != null) {
            this.threadStats.unregister();
        }
        this.delegate.close();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOG.warn("Future executor failed to finish in time, giving up", (Throwable)e);
        }
        LOG.info("DOM Data Broker stopped");
    }

    @ObjectClassDefinition
    public static @interface Config {
        @AttributeDefinition(name="max-data-broker-future-callback-queue-size")
        public int callbackQueueSize() default 1000;

        @AttributeDefinition(name="max-data-broker-future-callback-pool-size")
        public int callbackPoolSize() default 20;
    }
}

