/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalAbortable;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractClientHandle<T extends AbstractProxyTransaction>
extends LocalAbortable
implements Identifiable<TransactionIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientHandle.class);
    private static final AtomicReferenceFieldUpdater<AbstractClientHandle, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractClientHandle.class, State.class, "state");
    private final @NonNull TransactionIdentifier transactionId;
    private final @NonNull AbstractClientHistory parent;
    private volatile State<T> state = new State();

    AbstractClientHandle(AbstractClientHistory parent, TransactionIdentifier transactionId) {
        this.transactionId = Objects.requireNonNull(transactionId);
        this.parent = Objects.requireNonNull(parent);
    }

    public TransactionIdentifier getIdentifier() {
        return this.transactionId;
    }

    public boolean abort() {
        if (this.commonAbort()) {
            this.parent.onTransactionAbort(this);
            return true;
        }
        return false;
    }

    private boolean commonAbort() {
        Map<Long, T> toClose = this.ensureClosed();
        if (toClose == null) {
            return false;
        }
        toClose.values().forEach(AbstractProxyTransaction::abort);
        this.parent.onTransactionShardsBound(this.transactionId, toClose.keySet());
        return true;
    }

    @Override
    final void localAbort(Throwable cause) {
        LOG.debug("Local abort of transaction {}", (Object)this.getIdentifier(), (Object)cause);
        this.commonAbort();
    }

    final @Nullable Map<Long, T> ensureClosed() {
        State<T> local = this.state;
        return local != null && STATE_UPDATER.compareAndSet(this, local, null) ? local : null;
    }

    final T ensureProxy(YangInstanceIdentifier path) {
        return this.ensureProxy(this.getState(), this.parent.resolveShardForPath(path));
    }

    private T ensureProxy(State<T> localState, Long shard) {
        return (T)localState.computeIfAbsent(shard, this::createProxy);
    }

    final Stream<T> ensureAllProxies() {
        State<T> local = this.getState();
        return this.parent.resolveAllShards().map(shard -> this.ensureProxy(local, (Long)shard));
    }

    final AbstractClientHistory parent() {
        return this.parent;
    }

    abstract @NonNull T createProxy(@NonNull Long var1);

    private State<T> getState() {
        State<T> local = this.state;
        Preconditions.checkState((local != null ? 1 : 0) != 0, (String)"Transaction %s is closed", (Object)this.transactionId);
        return local;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("identifier", (Object)this.transactionId).add("state", this.state).toString();
    }

    private static final class State<T>
    extends ConcurrentHashMap<Long, T> {
        private static final long serialVersionUID = 1L;

        private State() {
        }
    }
}

