/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;

@Beta
public class ClientLocalHistory
extends AbstractClientHistory
implements AutoCloseable {
    ClientLocalHistory(AbstractDataStoreClientBehavior client, LocalHistoryIdentifier historyId) {
        super(client, historyId);
    }

    @Override
    public void close() {
        this.doClose();
    }

    private AbstractClientHistory.State ensureIdleState() {
        AbstractClientHistory.State local = this.state();
        Preconditions.checkState((local == AbstractClientHistory.State.IDLE ? 1 : 0) != 0, (String)"Local history %s state is %s", (Object)this, (Object)((Object)local));
        return local;
    }

    @Override
    ClientSnapshot doCreateSnapshot() {
        this.ensureIdleState();
        return new ClientSnapshot(this, new TransactionIdentifier(this.getIdentifier(), this.nextTx()));
    }

    @Override
    ClientTransaction doCreateTransaction() {
        this.updateState(this.ensureIdleState(), AbstractClientHistory.State.TX_OPEN);
        return new ClientTransaction(this, new TransactionIdentifier(this.getIdentifier(), this.nextTx()));
    }

    @Override
    void onTransactionAbort(AbstractClientHandle<?> snap) {
        AbstractClientHistory.State local;
        if (snap instanceof ClientTransaction && (local = this.state()) == AbstractClientHistory.State.TX_OPEN) {
            this.updateState(local, AbstractClientHistory.State.IDLE);
        }
        super.onTransactionAbort(snap);
    }

    @Override
    AbstractTransactionCommitCohort onTransactionReady(ClientTransaction tx, AbstractTransactionCommitCohort cohort) {
        AbstractClientHistory.State local = this.state();
        switch (local) {
            case CLOSED: {
                return super.onTransactionReady(tx, cohort);
            }
            case IDLE: {
                throw new IllegalStateException(String.format("Local history %s is idle when readying transaction %s", this, tx.getIdentifier()));
            }
            case TX_OPEN: {
                this.updateState(local, AbstractClientHistory.State.IDLE);
                return super.onTransactionReady(tx, cohort);
            }
        }
        throw new IllegalStateException(String.format("Local history %s in unhandled state %s", new Object[]{this, local}));
    }

    @Override
    ProxyHistory createHistoryProxy(LocalHistoryIdentifier historyId, AbstractClientConnection<ShardBackendInfo> connection) {
        return ProxyHistory.createClient(this, connection, historyId);
    }
}

