/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.DirectTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.EmptyTransactionCommitCohort;
import org.opendaylight.controller.cluster.datastore.utils.RootScatterGather;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Beta
public class ClientTransaction
extends AbstractClientHandle<AbstractProxyTransaction> {
    ClientTransaction(AbstractClientHistory parent, TransactionIdentifier transactionId) {
        super(parent, transactionId);
    }

    public FluentFuture<Boolean> exists(YangInstanceIdentifier path) {
        return ((AbstractProxyTransaction)this.ensureProxy(path)).exists(path);
    }

    public FluentFuture<Optional<NormalizedNode>> read(YangInstanceIdentifier path) {
        return path.isEmpty() ? this.readRoot() : ((AbstractProxyTransaction)this.ensureProxy(path)).read(path);
    }

    private FluentFuture<Optional<NormalizedNode>> readRoot() {
        return RootScatterGather.gather(this.parent().actorUtils(), this.ensureAllProxies().map(proxy -> proxy.read(YangInstanceIdentifier.empty())));
    }

    public void delete(YangInstanceIdentifier path) {
        if (path.isEmpty()) {
            this.ensureAllProxies().forEach(proxy -> proxy.delete(YangInstanceIdentifier.empty()));
        } else {
            ((AbstractProxyTransaction)this.ensureProxy(path)).delete(path);
        }
    }

    public void merge(YangInstanceIdentifier path, NormalizedNode data) {
        if (path.isEmpty()) {
            this.mergeRoot(RootScatterGather.castRootNode(data));
        } else {
            ((AbstractProxyTransaction)this.ensureProxy(path)).merge(path, data);
        }
    }

    private void mergeRoot(@NonNull ContainerNode rootData) {
        if (!rootData.isEmpty()) {
            RootScatterGather.scatterTouched(rootData, this::ensureProxy).forEach(scattered -> ((AbstractProxyTransaction)scattered.shard()).merge(YangInstanceIdentifier.empty(), (NormalizedNode)scattered.container()));
        }
    }

    public void write(YangInstanceIdentifier path, NormalizedNode data) {
        if (path.isEmpty()) {
            this.writeRoot(RootScatterGather.castRootNode(data));
        } else {
            ((AbstractProxyTransaction)this.ensureProxy(path)).write(path, data);
        }
    }

    private void writeRoot(@NonNull ContainerNode rootData) {
        RootScatterGather.scatterAll(rootData, this::ensureProxy, this.ensureAllProxies()).forEach(scattered -> ((AbstractProxyTransaction)scattered.shard()).write(YangInstanceIdentifier.empty(), (NormalizedNode)scattered.container()));
    }

    private AbstractProxyTransaction ensureProxy(YangInstanceIdentifier.PathArgument childId) {
        return this.ensureProxy(YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument)childId));
    }

    public DOMStoreThreePhaseCommitCohort ready() {
        Map participants = this.ensureClosed();
        Preconditions.checkState((participants != null ? 1 : 0) != 0, (String)"Attempted to submit a closed transaction %s", (Object)this);
        Collection<AbstractProxyTransaction> toReady = participants.values();
        toReady.forEach(AbstractProxyTransaction::seal);
        TransactionIdentifier txId = this.getIdentifier();
        AbstractClientHistory parent = this.parent();
        parent.onTransactionShardsBound(txId, participants.keySet());
        return parent.onTransactionReady(this, switch (toReady.size()) {
            case 0 -> new EmptyTransactionCommitCohort(parent, txId);
            case 1 -> new DirectTransactionCommitCohort(parent, txId, (AbstractProxyTransaction)toReady.iterator().next());
            default -> new ClientTransactionCommitCohort(parent, txId, toReady);
        });
    }

    @Override
    final AbstractProxyTransaction createProxy(Long shard) {
        return this.parent().createTransactionProxy(this.getIdentifier(), shard);
    }
}

