/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.AbstractLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.IncrementTransactionSequenceRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.RuntimeRequestException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.FailedDataTreeModificationException;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.RemoteProxyTransaction;
import org.opendaylight.controller.cluster.datastore.util.AbstractDataTreeModificationCursor;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LocalProxyTransaction
extends AbstractProxyTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(LocalProxyTransaction.class);
    private final @NonNull TransactionIdentifier identifier;

    LocalProxyTransaction(ProxyHistory parent, TransactionIdentifier identifier, boolean isDone) {
        super(parent, isDone);
        this.identifier = Objects.requireNonNull(identifier);
    }

    public final TransactionIdentifier getIdentifier() {
        return this.identifier;
    }

    abstract @NonNull DataTreeSnapshot readOnlyView();

    abstract void applyForwardedModifyTransactionRequest(ModifyTransactionRequest var1, @Nullable Consumer<Response<?, ?>> var2);

    abstract void replayModifyTransactionRequest(ModifyTransactionRequest var1, @Nullable Consumer<Response<?, ?>> var2, long var3);

    @Override
    FluentFuture<Boolean> doExists(YangInstanceIdentifier path) {
        boolean result;
        try {
            result = this.readOnlyView().readNode(path).isPresent();
        }
        catch (FailedDataTreeModificationException e) {
            return FluentFutures.immediateFailedFluentFuture((Throwable)ReadFailedException.MAPPER.apply((Exception)e));
        }
        return FluentFutures.immediateBooleanFluentFuture((boolean)result);
    }

    @Override
    FluentFuture<Optional<NormalizedNode>> doRead(YangInstanceIdentifier path) {
        Optional result;
        try {
            result = this.readOnlyView().readNode(path);
        }
        catch (FailedDataTreeModificationException e) {
            return FluentFutures.immediateFailedFluentFuture((Throwable)ReadFailedException.MAPPER.apply((Exception)e));
        }
        return FluentFutures.immediateFluentFuture((Object)result);
    }

    final AbortLocalTransactionRequest abortRequest() {
        return new AbortLocalTransactionRequest(this.identifier, this.localActor());
    }

    @Override
    void handleReplayedLocalRequest(AbstractLocalTransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        if (!(request instanceof AbortLocalTransactionRequest)) {
            throw LocalProxyTransaction.unhandledRequest(request);
        }
        this.enqueueAbort((TransactionRequest<?>)request, callback, enqueuedTicks);
    }

    @Override
    void handleReplayedRemoteRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        if (request instanceof ModifyTransactionRequest) {
            this.replayModifyTransactionRequest((ModifyTransactionRequest)request, callback, enqueuedTicks);
        } else if (!this.handleReadRequest(request, callback)) {
            if (request instanceof TransactionPurgeRequest) {
                this.enqueuePurge(callback, enqueuedTicks);
            } else if (request instanceof IncrementTransactionSequenceRequest) {
                LOG.debug("Not replaying {}", request);
            } else {
                throw LocalProxyTransaction.unhandledRequest(request);
            }
        }
    }

    void handleForwardedRemoteRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        if (request instanceof ModifyTransactionRequest) {
            this.applyForwardedModifyTransactionRequest((ModifyTransactionRequest)request, callback);
        } else if (!this.handleReadRequest(request, callback)) {
            if (request instanceof TransactionPurgeRequest) {
                this.enqueuePurge(callback);
            } else {
                throw LocalProxyTransaction.unhandledRequest(request);
            }
        }
    }

    @NonNull Response<?, ?> handleExistsRequest(@NonNull DataTreeSnapshot snapshot, @NonNull ExistsTransactionRequest request) {
        try {
            return new ExistsTransactionSuccess((TransactionIdentifier)request.getTarget(), request.getSequence(), snapshot.readNode(request.getPath()).isPresent());
        }
        catch (FailedDataTreeModificationException e) {
            return request.toRequestFailure((RequestException)new RuntimeRequestException("Failed to access data", (Throwable)ReadFailedException.MAPPER.apply((Exception)e)));
        }
    }

    @NonNull Response<?, ?> handleReadRequest(@NonNull DataTreeSnapshot snapshot, @NonNull ReadTransactionRequest request) {
        try {
            return new ReadTransactionSuccess((TransactionIdentifier)request.getTarget(), request.getSequence(), snapshot.readNode(request.getPath()));
        }
        catch (FailedDataTreeModificationException e) {
            return request.toRequestFailure((RequestException)new RuntimeRequestException("Failed to access data", (Throwable)ReadFailedException.MAPPER.apply((Exception)e)));
        }
    }

    private boolean handleReadRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        if (request instanceof ReadTransactionRequest) {
            if (callback != null) {
                Response<?, ?> response = this.handleReadRequest(this.readOnlyView(), (ReadTransactionRequest)request);
                this.executeInActor(() -> callback.accept(response));
            }
            return true;
        }
        if (request instanceof ExistsTransactionRequest) {
            if (callback != null) {
                Response<?, ?> response = this.handleExistsRequest(this.readOnlyView(), (ExistsTransactionRequest)request);
                this.executeInActor(() -> callback.accept(response));
            }
            return true;
        }
        return false;
    }

    @Override
    final void forwardToRemote(final RemoteProxyTransaction successor, TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        if (request instanceof CommitLocalTransactionRequest) {
            CommitLocalTransactionRequest req = (CommitLocalTransactionRequest)request;
            DataTreeModification mod = req.getModification();
            LOG.debug("Applying modification {} to successor {}", (Object)mod, (Object)successor);
            mod.applyToCursor((DataTreeModificationCursor)new AbstractDataTreeModificationCursor(){

                public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode data) {
                    successor.write(this.current().node(child), data);
                }

                public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode data) {
                    successor.merge(this.current().node(child), data);
                }

                public void delete(YangInstanceIdentifier.PathArgument child) {
                    successor.delete(this.current().node(child));
                }
            });
            successor.sealOnly();
            ModifyTransactionRequest successorReq = successor.commitRequest(req.isCoordinated());
            successor.sendRequest((TransactionRequest<?>)successorReq, callback);
        } else if (request instanceof AbortLocalTransactionRequest) {
            LOG.debug("Forwarding abort {} to successor {}", request, (Object)successor);
            successor.abort();
        } else if (request instanceof TransactionPurgeRequest) {
            LOG.debug("Forwarding purge {} to successor {}", request, (Object)successor);
            successor.enqueuePurge(callback);
        } else if (request instanceof ModifyTransactionRequest) {
            successor.handleForwardedRequest(request, callback);
        } else {
            throw LocalProxyTransaction.unhandledRequest(request);
        }
    }

    @Override
    void forwardToLocal(LocalProxyTransaction successor, TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        if (request instanceof AbortLocalTransactionRequest) {
            successor.sendAbort(request, callback);
        } else if (request instanceof TransactionPurgeRequest) {
            successor.enqueuePurge(callback);
        } else {
            throw LocalProxyTransaction.unhandledRequest(request);
        }
        LOG.debug("Forwarded request {} to successor {}", request, (Object)successor);
    }

    void sendAbort(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        this.sendRequest(request, callback);
    }

    void enqueueAbort(TransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        this.enqueueRequest(request, callback, enqueuedTicks);
    }
}

