/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedLong;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ClosedTransactionException;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.DeadTransactionException;
import org.opendaylight.controller.cluster.access.commands.IncrementTransactionSequenceRequest;
import org.opendaylight.controller.cluster.access.commands.LocalHistorySuccess;
import org.opendaylight.controller.cluster.access.commands.OutOfOrderRequestException;
import org.opendaylight.controller.cluster.access.commands.SkipTransactionsRequest;
import org.opendaylight.controller.cluster.access.commands.SkipTransactionsResponse;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeResponse;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.FrontendTransaction;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.MutableUnsignedLongSet;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractFrontendHistory
implements Identifiable<LocalHistoryIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFrontendHistory.class);
    private final Map<TransactionIdentifier, FrontendTransaction> transactions = new HashMap<TransactionIdentifier, FrontendTransaction>();
    private final MutableUnsignedLongSet purgedTransactions;
    private final String persistenceId;
    private final ShardDataTree tree;
    private Map<UnsignedLong, Boolean> closedTransactions;

    AbstractFrontendHistory(String persistenceId, ShardDataTree tree, Map<UnsignedLong, Boolean> closedTransactions, MutableUnsignedLongSet purgedTransactions) {
        this.persistenceId = Objects.requireNonNull(persistenceId);
        this.tree = Objects.requireNonNull(tree);
        this.closedTransactions = Objects.requireNonNull(closedTransactions);
        this.purgedTransactions = Objects.requireNonNull(purgedTransactions);
    }

    final String persistenceId() {
        return this.persistenceId;
    }

    final long readTime() {
        return this.tree.readTime();
    }

    final @Nullable TransactionSuccess<?> handleTransactionRequest(TransactionRequest<?> request, RequestEnvelope envelope, long now) throws RequestException {
        Optional<TransactionSuccess<?>> maybeReplay;
        if (request instanceof TransactionPurgeRequest) {
            TransactionPurgeRequest purgeRequest = (TransactionPurgeRequest)request;
            return this.handleTransactionPurgeRequest(purgeRequest, envelope, now);
        }
        if (request instanceof SkipTransactionsRequest) {
            SkipTransactionsRequest skipRequest = (SkipTransactionsRequest)request;
            return this.handleSkipTransactionsRequest(skipRequest, envelope, now);
        }
        TransactionIdentifier id = (TransactionIdentifier)request.getTarget();
        long txidBits = id.getTransactionId();
        if (this.purgedTransactions.contains(txidBits)) {
            LOG.warn("{}: Request {} is contained purged transactions {}", new Object[]{this.persistenceId, request, this.purgedTransactions});
            throw new DeadTransactionException(this.purgedTransactions.toRangeSet());
        }
        Boolean closed = this.closedTransactions.get(UnsignedLong.fromLongBits((long)txidBits));
        if (closed != null) {
            boolean successful = closed;
            LOG.debug("{}: Request {} refers to a {} transaction", new Object[]{this.persistenceId, request, successful ? "successful" : "failed"});
            throw new ClosedTransactionException(successful);
        }
        FrontendTransaction tx = this.transactions.get(id);
        if (tx == null) {
            if (request.getSequence() != 0L) {
                LOG.warn("{}: no transaction state present, unexpected request {}", (Object)this.persistenceId(), request);
                throw new OutOfOrderRequestException(0L);
            }
            tx = this.createTransaction(request, id);
            this.transactions.put(id, tx);
        } else if (!(request instanceof IncrementTransactionSequenceRequest) && (maybeReplay = tx.replaySequence(request.getSequence())).isPresent()) {
            TransactionSuccess<?> replay = maybeReplay.orElseThrow();
            LOG.debug("{}: envelope {} replaying response {}", new Object[]{this.persistenceId(), envelope, replay});
            return replay;
        }
        return tx.handleRequest(request, envelope, now);
    }

    private TransactionPurgeResponse handleTransactionPurgeRequest(TransactionPurgeRequest request, RequestEnvelope envelope, long now) {
        TransactionIdentifier id = (TransactionIdentifier)request.getTarget();
        long txidBits = id.getTransactionId();
        if (this.purgedTransactions.contains(txidBits)) {
            LOG.debug("{}: transaction {} already purged", (Object)this.persistenceId, (Object)id);
            return new TransactionPurgeResponse(id, request.getSequence());
        }
        UnsignedLong ul = UnsignedLong.fromLongBits((long)txidBits);
        if (this.closedTransactions.containsKey(ul)) {
            this.tree.purgeTransaction(id, () -> {
                this.closedTransactions.remove(ul);
                if (this.closedTransactions.isEmpty()) {
                    this.closedTransactions = ImmutableMap.of();
                }
                this.purgedTransactions.add(txidBits);
                LOG.debug("{}: finished purging inherited transaction {}", (Object)this.persistenceId(), (Object)id);
                envelope.sendSuccess((RequestSuccess)new TransactionPurgeResponse(id, request.getSequence()), this.readTime() - now);
            });
            return null;
        }
        FrontendTransaction tx = this.transactions.get(id);
        if (tx == null) {
            LOG.warn("{}: transaction {} not tracked in {}, but not present in active transactions", new Object[]{this.persistenceId, id, this.purgedTransactions});
            this.purgedTransactions.add(txidBits);
            return new TransactionPurgeResponse(id, request.getSequence());
        }
        this.tree.purgeTransaction(id, () -> {
            this.purgedTransactions.add(txidBits);
            this.transactions.remove(id);
            LOG.debug("{}: finished purging transaction {}", (Object)this.persistenceId(), (Object)id);
            envelope.sendSuccess((RequestSuccess)new TransactionPurgeResponse(id, request.getSequence()), this.readTime() - now);
        });
        return null;
    }

    private SkipTransactionsResponse handleSkipTransactionsRequest(SkipTransactionsRequest request, RequestEnvelope envelope, long now) {
        TransactionIdentifier first = (TransactionIdentifier)request.getTarget();
        List others = request.getOthers();
        ArrayList<UnsignedLong> ids = new ArrayList<UnsignedLong>(others.size() + 1);
        ids.add(UnsignedLong.fromLongBits((long)first.getTransactionId()));
        ids.addAll(others);
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            UnsignedLong id = (UnsignedLong)it.next();
            long bits = id.longValue();
            if (this.purgedTransactions.contains(bits)) {
                LOG.warn("{}: history {} tracks {} as purged", new Object[]{this.persistenceId(), this.getIdentifier(), id});
                it.remove();
                continue;
            }
            if (!this.transactions.containsKey(new TransactionIdentifier((LocalHistoryIdentifier)this.getIdentifier(), bits))) continue;
            LOG.warn("{}: history {} tracks {} as open", new Object[]{this.persistenceId(), this.getIdentifier(), id});
            it.remove();
        }
        if (ids.isEmpty()) {
            LOG.debug("{}: history {} completing empty skip request", (Object)this.persistenceId(), this.getIdentifier());
            return new SkipTransactionsResponse(first, now);
        }
        ImmutableUnsignedLongSet transactionIds = MutableUnsignedLongSet.of(ids.stream().mapToLong(UnsignedLong::longValue).toArray()).immutableCopy();
        LOG.debug("{}: history {} skipping transactions {}", new Object[]{this.persistenceId(), this.getIdentifier(), transactionIds.ranges()});
        this.tree.skipTransactions((LocalHistoryIdentifier)this.getIdentifier(), transactionIds, () -> {
            this.purgedTransactions.addAll(transactionIds);
            envelope.sendSuccess((RequestSuccess)new TransactionPurgeResponse(first, request.getSequence()), this.readTime() - now);
        });
        return null;
    }

    final void destroy(long sequence, RequestEnvelope envelope, long now) {
        LOG.debug("{}: closing history {}", (Object)this.persistenceId(), this.getIdentifier());
        this.tree.closeTransactionChain((LocalHistoryIdentifier)this.getIdentifier(), () -> envelope.sendSuccess((RequestSuccess)new LocalHistorySuccess((LocalHistoryIdentifier)this.getIdentifier(), sequence), this.readTime() - now));
    }

    final void purge(long sequence, RequestEnvelope envelope, long now) {
        LOG.debug("{}: purging history {}", (Object)this.persistenceId(), this.getIdentifier());
        this.tree.purgeTransactionChain((LocalHistoryIdentifier)this.getIdentifier(), () -> envelope.sendSuccess((RequestSuccess)new LocalHistorySuccess((LocalHistoryIdentifier)this.getIdentifier(), sequence), this.readTime() - now));
    }

    final void retire() {
        this.transactions.values().forEach(FrontendTransaction::retire);
        this.tree.removeTransactionChain((LocalHistoryIdentifier)this.getIdentifier());
    }

    private FrontendTransaction createTransaction(TransactionRequest<?> request, TransactionIdentifier id) {
        AbstractReadTransactionRequest readTxRequest;
        if (request instanceof CommitLocalTransactionRequest) {
            CommitLocalTransactionRequest commitLocalRequest = (CommitLocalTransactionRequest)request;
            LOG.debug("{}: allocating new ready transaction {}", (Object)this.persistenceId(), (Object)id);
            this.tree.getStats().incrementReadWriteTransactionCount();
            return this.createReadyTransaction(id, commitLocalRequest.getModification());
        }
        if (request instanceof AbstractReadTransactionRequest && (readTxRequest = (AbstractReadTransactionRequest)request).isSnapshotOnly()) {
            LOG.debug("{}: allocating new open snapshot {}", (Object)this.persistenceId(), (Object)id);
            this.tree.getStats().incrementReadOnlyTransactionCount();
            return this.createOpenSnapshot(id);
        }
        LOG.debug("{}: allocating new open transaction {}", (Object)this.persistenceId(), (Object)id);
        this.tree.getStats().incrementReadWriteTransactionCount();
        return this.createOpenTransaction(id);
    }

    abstract FrontendTransaction createOpenSnapshot(TransactionIdentifier var1);

    abstract FrontendTransaction createOpenTransaction(TransactionIdentifier var1);

    abstract FrontendTransaction createReadyTransaction(TransactionIdentifier var1, DataTreeModification var2);

    abstract ShardDataTreeCohort createFailedCohort(TransactionIdentifier var1, DataTreeModification var2, Exception var3);

    abstract ShardDataTreeCohort createReadyCohort(TransactionIdentifier var1, DataTreeModification var2, Optional<SortedSet<String>> var3);

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("identifier", this.getIdentifier()).add("persistenceId", (Object)this.persistenceId).add("transactions", this.transactions).toString();
    }
}

