/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractThreePhaseCommitCohort;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.yangtools.yang.common.Empty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;

class DebugThreePhaseCommitCohort
extends AbstractThreePhaseCommitCohort<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(DebugThreePhaseCommitCohort.class);
    private final AbstractThreePhaseCommitCohort<?> delegate;
    private final Throwable debugContext;
    private final TransactionIdentifier transactionId;
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_FINAL"})
    private Logger log = LOG;

    DebugThreePhaseCommitCohort(TransactionIdentifier transactionId, AbstractThreePhaseCommitCohort<?> delegate, Throwable debugContext) {
        this.delegate = Objects.requireNonNull(delegate);
        this.debugContext = Objects.requireNonNull(debugContext);
        this.transactionId = Objects.requireNonNull(transactionId);
    }

    private <V> ListenableFuture<V> addFutureCallback(ListenableFuture<V> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<V>(){

            public void onSuccess(V result) {
            }

            public void onFailure(Throwable failure) {
                DebugThreePhaseCommitCohort.this.log.warn("Transaction {} failed with error \"{}\" - was allocated in the following context", new Object[]{DebugThreePhaseCommitCohort.this.transactionId, failure, DebugThreePhaseCommitCohort.this.debugContext});
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    public ListenableFuture<Boolean> canCommit() {
        return this.addFutureCallback(this.delegate.canCommit());
    }

    public ListenableFuture<Empty> preCommit() {
        return this.addFutureCallback(this.delegate.preCommit());
    }

    public ListenableFuture<? extends CommitInfo> commit() {
        return this.addFutureCallback(this.delegate.commit());
    }

    public ListenableFuture<Empty> abort() {
        return this.delegate.abort();
    }

    @Override
    List<Future<Object>> getCohortFutures() {
        return this.delegate.getCohortFutures();
    }

    @VisibleForTesting
    void setLogger(Logger logger) {
        this.log = logger;
    }
}

