/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionContextWrapper;
import org.opendaylight.controller.cluster.datastore.TransactionContext;
import org.opendaylight.controller.cluster.datastore.TransactionOperation;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import scala.concurrent.Future;

final class DirectTransactionContextWrapper
extends AbstractTransactionContextWrapper {
    private final TransactionContext transactionContext;

    DirectTransactionContextWrapper(@NonNull TransactionIdentifier identifier, @NonNull ActorUtils actorUtils, @NonNull String shardName, @NonNull TransactionContext transactionContext) {
        super(identifier, actorUtils, shardName);
        this.transactionContext = Objects.requireNonNull(transactionContext);
    }

    @Override
    TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    void maybeExecuteTransactionOperation(TransactionOperation op) {
        op.invoke(this.transactionContext, null);
    }

    @Override
    Future<ActorSelection> readyTransaction(Optional<SortedSet<String>> participatingShardNames) {
        return this.transactionContext.readyTransaction(null, participatingShardNames);
    }
}

