/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedLong;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.FrontendReadOnlyTransaction;
import org.opendaylight.controller.cluster.datastore.FrontendReadWriteTransaction;
import org.opendaylight.controller.cluster.datastore.FrontendTransaction;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionChain;
import org.opendaylight.controller.cluster.datastore.utils.MutableUnsignedLongSet;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;

final class LocalFrontendHistory
extends AbstractFrontendHistory {
    private final ShardDataTreeTransactionChain chain;

    private LocalFrontendHistory(String persistenceId, ShardDataTree tree, ShardDataTreeTransactionChain chain, Map<UnsignedLong, Boolean> closedTransactions, MutableUnsignedLongSet purgedTransactions) {
        super(persistenceId, tree, closedTransactions, purgedTransactions);
        this.chain = Objects.requireNonNull(chain);
    }

    static LocalFrontendHistory create(String persistenceId, ShardDataTree tree, ShardDataTreeTransactionChain chain) {
        return new LocalFrontendHistory(persistenceId, tree, chain, (Map<UnsignedLong, Boolean>)ImmutableMap.of(), MutableUnsignedLongSet.of());
    }

    static LocalFrontendHistory recreate(String persistenceId, ShardDataTree tree, ShardDataTreeTransactionChain chain, Map<UnsignedLong, Boolean> closedTransactions, MutableUnsignedLongSet purgedTransactions) {
        return new LocalFrontendHistory(persistenceId, tree, chain, new HashMap<UnsignedLong, Boolean>(closedTransactions), purgedTransactions.mutableCopy());
    }

    public LocalHistoryIdentifier getIdentifier() {
        return this.chain.getIdentifier();
    }

    @Override
    FrontendTransaction createOpenSnapshot(TransactionIdentifier id) {
        return FrontendReadOnlyTransaction.create(this, this.chain.newReadOnlyTransaction(id));
    }

    @Override
    FrontendTransaction createOpenTransaction(TransactionIdentifier id) {
        return FrontendReadWriteTransaction.createOpen(this, this.chain.newReadWriteTransaction(id));
    }

    @Override
    FrontendTransaction createReadyTransaction(TransactionIdentifier id, DataTreeModification mod) {
        return FrontendReadWriteTransaction.createReady(this, id, mod);
    }

    @Override
    ShardDataTreeCohort createFailedCohort(TransactionIdentifier id, DataTreeModification mod, Exception failure) {
        return this.chain.createFailedCohort(id, mod, failure);
    }

    @Override
    ShardDataTreeCohort createReadyCohort(TransactionIdentifier id, DataTreeModification mod, Optional<SortedSet<String>> participatingShardNames) {
        return this.chain.createReadyCohort(id, mod, participatingShardNames);
    }
}

