/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.LocalThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.LocalTransactionFactory;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.SnapshotBackedTransactions;
import org.opendaylight.mdsal.dom.spi.store.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.api.ReadOnlyDataTree;

final class LocalTransactionFactoryImpl
extends SnapshotBackedWriteTransaction.TransactionReadyPrototype<TransactionIdentifier>
implements LocalTransactionFactory {
    private final ActorSelection leader;
    private final ReadOnlyDataTree dataTree;
    private final ActorUtils actorUtils;

    LocalTransactionFactoryImpl(ActorUtils actorUtils, ActorSelection leader, ReadOnlyDataTree dataTree) {
        this.leader = Objects.requireNonNull(leader);
        this.dataTree = Objects.requireNonNull(dataTree);
        this.actorUtils = actorUtils;
    }

    ReadOnlyDataTree getDataTree() {
        return this.dataTree;
    }

    @Override
    public DOMStoreReadTransaction newReadOnlyTransaction(TransactionIdentifier identifier) {
        return SnapshotBackedTransactions.newReadTransaction((Object)identifier, (boolean)false, (DataTreeSnapshot)this.dataTree.takeSnapshot());
    }

    @Override
    public DOMStoreReadWriteTransaction newReadWriteTransaction(TransactionIdentifier identifier) {
        return SnapshotBackedTransactions.newReadWriteTransaction((Object)identifier, (boolean)false, (DataTreeSnapshot)this.dataTree.takeSnapshot(), (SnapshotBackedWriteTransaction.TransactionReadyPrototype)this);
    }

    @Override
    public DOMStoreWriteTransaction newWriteOnlyTransaction(TransactionIdentifier identifier) {
        return SnapshotBackedTransactions.newWriteTransaction((Object)identifier, (boolean)false, (DataTreeSnapshot)this.dataTree.takeSnapshot(), (SnapshotBackedWriteTransaction.TransactionReadyPrototype)this);
    }

    protected void transactionAborted(SnapshotBackedWriteTransaction<TransactionIdentifier> tx) {
    }

    protected DOMStoreThreePhaseCommitCohort transactionReady(SnapshotBackedWriteTransaction<TransactionIdentifier> tx, DataTreeModification tree, Exception readyError) {
        return new LocalThreePhaseCommitCohort(this.actorUtils, this.leader, tx, tree, readyError);
    }

    @Override
    public LocalThreePhaseCommitCohort onTransactionReady(DOMStoreWriteTransaction tx, Exception operationError) {
        Preconditions.checkArgument((boolean)(tx instanceof SnapshotBackedWriteTransaction));
        if (operationError != null) {
            return new LocalThreePhaseCommitCohort(this.actorUtils, this.leader, (SnapshotBackedWriteTransaction<TransactionIdentifier>)((SnapshotBackedWriteTransaction)tx), operationError);
        }
        return (LocalThreePhaseCommitCohort)tx.ready();
    }
}

