/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props;
import java.util.Optional;
import java.util.function.Consumer;
import org.opendaylight.controller.cluster.datastore.AbstractShardDataTreeNotificationPublisherActorProxy;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeChangeListenerPublisher;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeChangePublisherActor;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

class ShardDataTreeChangeListenerPublisherActorProxy
extends AbstractShardDataTreeNotificationPublisherActorProxy
implements ShardDataTreeChangeListenerPublisher {
    ShardDataTreeChangeListenerPublisherActorProxy(ActorContext actorContext, String actorName, String logContext) {
        super(actorContext, actorName, logContext);
    }

    @Override
    public void registerTreeChangeListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener, Optional<DataTreeCandidate> currentState, Consumer<ListenerRegistration<DOMDataTreeChangeListener>> onRegistration) {
        ShardDataTreeChangePublisherActor.RegisterListener regMessage = new ShardDataTreeChangePublisherActor.RegisterListener(treeId, listener, currentState, onRegistration);
        this.log.debug("{}: Sending {} to publisher actor {}", new Object[]{this.logContext(), regMessage, this.publisherActor()});
        this.publisherActor().tell((Object)regMessage, ActorRef.noSender());
    }

    @Override
    protected Props props() {
        return ShardDataTreeChangePublisherActor.props(this.actorName(), this.logContext());
    }
}

