/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeNotificationPublisher;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

public class ShardDataTreeNotificationPublisherActor<T extends ShardDataTreeNotificationPublisher>
extends AbstractUntypedActor {
    private final T publisher;
    private final Stopwatch timer = Stopwatch.createUnstarted();
    private final String name;
    private final String logContext;

    protected ShardDataTreeNotificationPublisherActor(T publisher, String name, String logContext) {
        this.publisher = publisher;
        this.name = name;
        this.logContext = logContext;
    }

    protected T publisher() {
        return this.publisher;
    }

    protected String logContext() {
        return this.logContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReceive(Object message) {
        if (message instanceof PublishNotifications) {
            PublishNotifications toPublish = (PublishNotifications)message;
            this.timer.start();
            try {
                this.publisher.publishChanges(toPublish.candidate);
            }
            catch (Throwable throwable) {
                long elapsedTime = this.timer.elapsed(TimeUnit.MILLISECONDS);
                if (elapsedTime >= ShardDataTreeNotificationPublisher.PUBLISH_DELAY_THRESHOLD_IN_MS) {
                    this.LOG.warn("{}: Generation of change events for {} took longer than expected. Elapsed time: {}", new Object[]{this.logContext, this.name, this.timer});
                } else {
                    this.LOG.debug("{}: Elapsed time for generation of change events for {}: {}", new Object[]{this.logContext, this.name, this.timer});
                }
                this.timer.reset();
                throw throwable;
            }
            long elapsedTime = this.timer.elapsed(TimeUnit.MILLISECONDS);
            if (elapsedTime >= ShardDataTreeNotificationPublisher.PUBLISH_DELAY_THRESHOLD_IN_MS) {
                this.LOG.warn("{}: Generation of change events for {} took longer than expected. Elapsed time: {}", new Object[]{this.logContext, this.name, this.timer});
            } else {
                this.LOG.debug("{}: Elapsed time for generation of change events for {}: {}", new Object[]{this.logContext, this.name, this.timer});
            }
            this.timer.reset();
        }
    }

    static class PublishNotifications {
        private final DataTreeCandidate candidate;

        PublishNotifications(DataTreeCandidate candidate) {
            this.candidate = candidate;
        }
    }
}

