/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.actors.ShardSnapshotActor;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.io.InputOutputStreamFactory;
import org.opendaylight.controller.cluster.raft.RaftActorSnapshotCohort;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.slf4j.Logger;

final class ShardSnapshotCohort
implements RaftActorSnapshotCohort {
    private static final FrontendType SNAPSHOT_APPLY = FrontendType.forName((String)"snapshot-apply");
    private final InputOutputStreamFactory streamFactory;
    private final ActorRef snapshotActor;
    private final ShardDataTree store;
    private final String logId;
    private final Logger log;

    ShardSnapshotCohort(InputOutputStreamFactory streamFactory, LocalHistoryIdentifier applyHistoryId, ActorRef snapshotActor, ShardDataTree store, Logger log, String logId) {
        this.streamFactory = Objects.requireNonNull(streamFactory);
        this.snapshotActor = Objects.requireNonNull(snapshotActor);
        this.store = Objects.requireNonNull(store);
        this.log = log;
        this.logId = logId;
    }

    static ShardSnapshotCohort create(ActorContext actorContext, MemberName memberName, ShardDataTree store, Logger log, String logId, DatastoreContext context) {
        LocalHistoryIdentifier applyHistoryId = new LocalHistoryIdentifier(ClientIdentifier.create((FrontendIdentifier)FrontendIdentifier.create((MemberName)memberName, (FrontendType)SNAPSHOT_APPLY), (long)0L), 0L);
        String snapshotActorName = "shard-" + memberName.getName() + ":snapshot-read";
        InputOutputStreamFactory streamFactory = context.isUseLz4Compression() ? InputOutputStreamFactory.lz4((String)"256KB") : InputOutputStreamFactory.simple();
        ActorRef snapshotActor = actorContext.actorOf(ShardSnapshotActor.props(streamFactory), snapshotActorName);
        return new ShardSnapshotCohort(streamFactory, applyHistoryId, snapshotActor, store, log, logId);
    }

    public void createSnapshot(ActorRef actorRef, Optional<OutputStream> installSnapshotStream) {
        ShardDataTreeSnapshot snapshot = this.store.takeStateSnapshot();
        this.log.debug("{}: requesting serialization of snapshot {}", (Object)this.logId, (Object)snapshot);
        ShardSnapshotActor.requestSnapshot(this.snapshotActor, snapshot, installSnapshotStream, actorRef);
    }

    public void applySnapshot(Snapshot.State snapshotState) {
        if (!(snapshotState instanceof ShardSnapshotState)) {
            this.log.debug("{}: applySnapshot ignoring snapshot: {}", (Object)this.logId, (Object)snapshotState);
        }
        ShardDataTreeSnapshot snapshot = ((ShardSnapshotState)snapshotState).getSnapshot();
        this.log.info("{}: Applying snapshot", (Object)this.logId);
        try {
            this.store.applySnapshot(snapshot);
        }
        catch (Exception e) {
            this.log.error("{}: Failed to apply snapshot {}", new Object[]{this.logId, snapshot, e});
            return;
        }
        this.log.info("{}: Done applying snapshot", (Object)this.logId);
    }

    public Snapshot.State deserializeSnapshot(ByteSource snapshotBytes) throws IOException {
        try (ObjectInputStream in = new ObjectInputStream(this.streamFactory.createInputStream(snapshotBytes));){
            ShardSnapshotState shardSnapshotState = ShardDataTreeSnapshot.deserialize(in);
            return shardSnapshotState;
        }
    }
}

