/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Optional;
import java.util.SortedSet;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.AbstractRead;
import org.opendaylight.yangtools.concepts.AbstractSimpleIdentifiable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;

abstract class TransactionContext
extends AbstractSimpleIdentifiable<TransactionIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionContext.class);
    private final short transactionVersion;
    private long modificationCount = 0L;
    private boolean handOffComplete;

    TransactionContext(TransactionIdentifier transactionIdentifier) {
        this(transactionIdentifier, 12);
    }

    TransactionContext(TransactionIdentifier transactionIdentifier, short transactionVersion) {
        super((Object)transactionIdentifier);
        this.transactionVersion = transactionVersion;
    }

    final short getTransactionVersion() {
        return this.transactionVersion;
    }

    final void incrementModificationCount() {
        ++this.modificationCount;
    }

    final void logModificationCount() {
        LOG.debug("Total modifications on Tx {} = [ {} ]", this.getIdentifier(), (Object)this.modificationCount);
    }

    final void operationHandOffComplete() {
        this.handOffComplete = true;
    }

    final boolean isOperationHandOffComplete() {
        return this.handOffComplete;
    }

    boolean usesOperationLimiting() {
        return false;
    }

    abstract void executeDelete(YangInstanceIdentifier var1, Boolean var2);

    abstract void executeMerge(YangInstanceIdentifier var1, NormalizedNode var2, Boolean var3);

    abstract void executeWrite(YangInstanceIdentifier var1, NormalizedNode var2, Boolean var3);

    abstract <T> void executeRead(AbstractRead<T> var1, SettableFuture<T> var2, Boolean var3);

    abstract Future<ActorSelection> readyTransaction(Boolean var1, Optional<SortedSet<String>> var2);

    abstract Future<Object> directCommit(Boolean var1);

    abstract void closeTransaction();
}

