/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.TransactionContext;
import org.opendaylight.controller.cluster.datastore.TransactionOperation;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

abstract class TransactionModificationOperation
extends TransactionOperation {
    private final YangInstanceIdentifier path;

    TransactionModificationOperation(YangInstanceIdentifier path) {
        this.path = Objects.requireNonNull(path);
    }

    final YangInstanceIdentifier path() {
        return this.path;
    }

    static final class WriteOperation
    extends AbstractDataOperation {
        WriteOperation(YangInstanceIdentifier path, NormalizedNode data) {
            super(path, data);
        }

        @Override
        protected void invoke(TransactionContext transactionContext, Boolean havePermit) {
            transactionContext.executeWrite(this.path(), this.data(), havePermit);
        }
    }

    static final class MergeOperation
    extends AbstractDataOperation {
        MergeOperation(YangInstanceIdentifier path, NormalizedNode data) {
            super(path, data);
        }

        @Override
        protected void invoke(TransactionContext transactionContext, Boolean havePermit) {
            transactionContext.executeMerge(this.path(), this.data(), havePermit);
        }
    }

    static final class DeleteOperation
    extends TransactionModificationOperation {
        DeleteOperation(YangInstanceIdentifier path) {
            super(path);
        }

        @Override
        protected void invoke(TransactionContext transactionContext, Boolean havePermit) {
            transactionContext.executeDelete(this.path(), havePermit);
        }
    }

    private static abstract class AbstractDataOperation
    extends TransactionModificationOperation {
        private final NormalizedNode data;

        AbstractDataOperation(YangInstanceIdentifier path, NormalizedNode data) {
            super(path);
            this.data = Objects.requireNonNull(data);
        }

        final NormalizedNode data() {
            return this.data;
        }
    }
}

