/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.actors;

import akka.actor.ActorRef;
import akka.actor.Props;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActorWithMetering;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.io.InputOutputStreamFactory;
import org.opendaylight.controller.cluster.raft.base.messages.CaptureSnapshotReply;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;

public final class ShardSnapshotActor
extends AbstractUntypedActorWithMetering {
    private static final String ACTOR_NAME_FOR_METERING = "shard-snapshot";
    private final InputOutputStreamFactory streamFactory;

    private ShardSnapshotActor(InputOutputStreamFactory streamFactory) {
        super(ACTOR_NAME_FOR_METERING);
        this.streamFactory = Objects.requireNonNull(streamFactory);
    }

    protected void handleReceive(Object message) {
        if (message instanceof SerializeSnapshot) {
            this.onSerializeSnapshot((SerializeSnapshot)message);
        } else {
            this.unknownMessage(message);
        }
    }

    private void onSerializeSnapshot(SerializeSnapshot request) {
        Optional<OutputStream> installSnapshotStream = request.getInstallSnapshotStream();
        if (installSnapshotStream.isPresent()) {
            try (ObjectOutputStream out = this.getOutputStream(installSnapshotStream.orElseThrow());){
                request.getSnapshot().serialize(out);
            }
            catch (IOException e) {
                this.LOG.error("Error serializing snapshot", (Throwable)e);
            }
        }
        request.getReplyTo().tell((Object)new CaptureSnapshotReply((Snapshot.State)new ShardSnapshotState(request.getSnapshot()), installSnapshotStream), ActorRef.noSender());
    }

    private ObjectOutputStream getOutputStream(OutputStream outputStream) throws IOException {
        return new ObjectOutputStream(this.streamFactory.wrapOutputStream(outputStream));
    }

    public static void requestSnapshot(ActorRef snapshotActor, ShardDataTreeSnapshot snapshot, Optional<OutputStream> installSnapshotStream, ActorRef replyTo) {
        snapshotActor.tell((Object)new SerializeSnapshot(snapshot, installSnapshotStream, replyTo), ActorRef.noSender());
    }

    public static Props props(InputOutputStreamFactory streamFactory) {
        return Props.create(ShardSnapshotActor.class, (Object[])new Object[]{streamFactory});
    }

    private static final class SerializeSnapshot {
        private final ShardDataTreeSnapshot snapshot;
        private final Optional<OutputStream> installSnapshotStream;
        private final ActorRef replyTo;

        SerializeSnapshot(ShardDataTreeSnapshot snapshot, Optional<OutputStream> installSnapshotStream, ActorRef replyTo) {
            this.snapshot = Objects.requireNonNull(snapshot);
            this.installSnapshotStream = Objects.requireNonNull(installSnapshotStream);
            this.replyTo = Objects.requireNonNull(replyTo);
        }

        ShardDataTreeSnapshot getSnapshot() {
            return this.snapshot;
        }

        Optional<OutputStream> getInstallSnapshotStream() {
            return this.installSnapshotStream;
        }

        ActorRef getReplyTo() {
            return this.replyTo;
        }
    }
}

