/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.typesafe.config.Config;
import java.util.Map;
import org.opendaylight.controller.cluster.datastore.config.AbstractModuleShardConfigProvider;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ModuleConfig;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfigProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ModuleShardConfigProvider.class})
public class FileModuleShardConfigProvider
extends AbstractModuleShardConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FileModuleShardConfigProvider.class);
    private final String moduleShardsConfigPath;
    private final String modulesConfigPath;

    public FileModuleShardConfigProvider() {
        this("./configuration/initial/module-shards.conf", "./configuration/initial/modules.conf");
    }

    public FileModuleShardConfigProvider(String moduleShardsConfigPath, String modulesConfigPath) {
        this.moduleShardsConfigPath = moduleShardsConfigPath;
        this.modulesConfigPath = modulesConfigPath;
    }

    @Override
    public Map<String, ModuleConfig.Builder> retrieveModuleConfigs(Configuration configuration) {
        Config moduleShardsConfig = FileModuleShardConfigProvider.loadConfigFromPath(this.moduleShardsConfigPath);
        Config modulesConfig = FileModuleShardConfigProvider.loadConfigFromPath(this.modulesConfigPath);
        Map<String, ModuleConfig.Builder> moduleConfigMap = FileModuleShardConfigProvider.readModuleShardsConfig(moduleShardsConfig);
        FileModuleShardConfigProvider.readModulesConfig(modulesConfig, moduleConfigMap, configuration);
        return moduleConfigMap;
    }

    @Activate
    void activate() {
        LOG.info("Shard configuration provider started");
    }

    @Deactivate
    void deactivate() {
        LOG.info("Shard configuration provider stopped");
    }
}

