/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;

public class ForwardedReadyTransaction {
    private final TransactionIdentifier transactionId;
    private final ReadWriteShardDataTreeTransaction transaction;
    private final boolean doImmediateCommit;
    private final short txnClientVersion;
    private final @Nullable SortedSet<String> participatingShardNames;

    public ForwardedReadyTransaction(TransactionIdentifier transactionId, short txnClientVersion, ReadWriteShardDataTreeTransaction transaction, boolean doImmediateCommit, Optional<SortedSet<String>> participatingShardNames) {
        this.transactionId = Objects.requireNonNull(transactionId);
        this.transaction = Objects.requireNonNull(transaction);
        this.txnClientVersion = txnClientVersion;
        this.doImmediateCommit = doImmediateCommit;
        this.participatingShardNames = Objects.requireNonNull(participatingShardNames).orElse(null);
    }

    public TransactionIdentifier getTransactionId() {
        return this.transactionId;
    }

    public ReadWriteShardDataTreeTransaction getTransaction() {
        return this.transaction;
    }

    public short getTxnClientVersion() {
        return this.txnClientVersion;
    }

    public boolean isDoImmediateCommit() {
        return this.doImmediateCommit;
    }

    public Optional<SortedSet<String>> getParticipatingShardNames() {
        return Optional.ofNullable(this.participatingShardNames);
    }

    public String toString() {
        return "ForwardedReadyTransaction [transactionId=" + this.transactionId + ", transaction=" + this.transaction + ", doImmediateCommit=" + this.doImmediateCommit + ", participatingShardNames=" + this.participatingShardNames + ", txnClientVersion=" + this.txnClientVersion + "]";
    }
}

