/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;

public final class ReadyLocalTransaction {
    private final DataTreeModification modification;
    private final TransactionIdentifier transactionId;
    private final boolean doCommitOnReady;
    private final @Nullable SortedSet<String> participatingShardNames;
    private short remoteVersion = (short)12;

    public ReadyLocalTransaction(TransactionIdentifier transactionId, DataTreeModification modification, boolean doCommitOnReady, Optional<SortedSet<String>> participatingShardNames) {
        this.transactionId = Objects.requireNonNull(transactionId);
        this.modification = Objects.requireNonNull(modification);
        this.doCommitOnReady = doCommitOnReady;
        this.participatingShardNames = Objects.requireNonNull(participatingShardNames).orElse(null);
    }

    public TransactionIdentifier getTransactionId() {
        return this.transactionId;
    }

    public DataTreeModification getModification() {
        return this.modification;
    }

    public boolean isDoCommitOnReady() {
        return this.doCommitOnReady;
    }

    public short getRemoteVersion() {
        return this.remoteVersion;
    }

    public void setRemoteVersion(short remoteVersion) {
        this.remoteVersion = remoteVersion;
    }

    public Optional<SortedSet<String>> getParticipatingShardNames() {
        return Optional.ofNullable(this.participatingShardNames);
    }
}

