/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.persisted.PayloadVersion;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractVersionedShardDataTreeSnapshot
extends ShardDataTreeSnapshot {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractVersionedShardDataTreeSnapshot.class);

    AbstractVersionedShardDataTreeSnapshot() {
    }

    static @NonNull ShardSnapshotState versionedDeserialize(ObjectInput in) throws IOException {
        PayloadVersion version = PayloadVersion.readFrom(in);
        switch (version) {
            case SODIUM_SR1: 
            case MAGNESIUM: {
                return new ShardSnapshotState(AbstractVersionedShardDataTreeSnapshot.readSnapshot(in), true);
            }
            case CHLORINE_SR2: {
                return new ShardSnapshotState(AbstractVersionedShardDataTreeSnapshot.readSnapshot(in), false);
            }
        }
        throw new IOException("Encountered unhandled version " + version);
    }

    private static @NonNull ShardDataTreeSnapshot readSnapshot(ObjectInput in) throws IOException {
        try {
            return (ShardDataTreeSnapshot)in.readObject();
        }
        catch (ClassNotFoundException e) {
            LOG.error("Failed to serialize data tree snapshot", (Throwable)e);
            throw new IOException("Snapshot failed to deserialize", e);
        }
    }

    @Override
    public final Optional<NormalizedNode> getRootNode() {
        return Optional.of((NormalizedNode)Verify.verifyNotNull((Object)this.rootNode(), (String)"Snapshot %s returned non-present root node", (Object[])new Object[]{this.getClass()}));
    }

    abstract @NonNull NormalizedNode rootNode();

    abstract @NonNull PayloadVersion version();

    private void versionedSerialize(ObjectOutput out, PayloadVersion version) throws IOException {
        switch (version) {
            case SODIUM_SR1: 
            case MAGNESIUM: 
            case CHLORINE_SR2: {
                out.writeObject(this);
                return;
            }
            case TEST_FUTURE_VERSION: 
            case TEST_PAST_VERSION: {
                break;
            }
            default: {
                throw new IOException("Invalid payload version in snapshot");
            }
        }
        throw new IOException("Encountered unhandled version" + version);
    }

    @Override
    public void serialize(ObjectOutput out) throws IOException {
        PayloadVersion version = this.version();
        version.writeTo(out);
        this.versionedSerialize(out, version);
    }
}

