/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendHistoryMetadata;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.WritableObject;

public final class FrontendClientMetadata
implements Identifiable<ClientIdentifier>,
WritableObject {
    private final @NonNull ImmutableList<FrontendHistoryMetadata> currentHistories;
    private final @NonNull ImmutableUnsignedLongSet purgedHistories;
    private final @NonNull ClientIdentifier identifier;

    public FrontendClientMetadata(ClientIdentifier identifier, ImmutableUnsignedLongSet purgedHistories, Collection<FrontendHistoryMetadata> currentHistories) {
        this.identifier = Objects.requireNonNull(identifier);
        this.purgedHistories = Objects.requireNonNull(purgedHistories);
        this.currentHistories = ImmutableList.copyOf(currentHistories);
    }

    public ImmutableList<FrontendHistoryMetadata> getCurrentHistories() {
        return this.currentHistories;
    }

    public ImmutableUnsignedLongSet getPurgedHistories() {
        return this.purgedHistories;
    }

    public ClientIdentifier getIdentifier() {
        return this.identifier;
    }

    public void writeTo(DataOutput out) throws IOException {
        this.identifier.writeTo(out);
        this.purgedHistories.writeTo(out);
        out.writeInt(this.currentHistories.size());
        for (FrontendHistoryMetadata h : this.currentHistories) {
            h.writeTo(out);
        }
    }

    public static FrontendClientMetadata readFrom(DataInput in) throws IOException {
        ClientIdentifier id = ClientIdentifier.readFrom((DataInput)in);
        ImmutableUnsignedLongSet purgedHistories = ImmutableUnsignedLongSet.readFrom(in);
        int currentSize = in.readInt();
        ImmutableList.Builder currentBuilder = ImmutableList.builderWithExpectedSize((int)currentSize);
        for (int i = 0; i < currentSize; ++i) {
            currentBuilder.add((Object)FrontendHistoryMetadata.readFrom(in));
        }
        return new FrontendClientMetadata(id, purgedHistories, (Collection<FrontendHistoryMetadata>)currentBuilder.build());
    }

    public String toString() {
        return MoreObjects.toStringHelper(FrontendClientMetadata.class).add("identifer", (Object)this.identifier).add("current", this.currentHistories).add("purged", (Object)this.purgedHistories).toString();
    }
}

