/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.opendaylight.controller.cluster.datastore.persisted.PT;
import org.opendaylight.controller.cluster.raft.persisted.LegacySerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class PurgeTransactionPayload
extends AbstractIdentifiablePayload<TransactionIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeTransactionPayload.class);
    private static final long serialVersionUID = 1L;
    private static final int PROXY_SIZE = PurgeTransactionPayload.externalizableProxySize(PT::new);

    PurgeTransactionPayload(TransactionIdentifier transactionId, byte[] serialized) {
        super(transactionId, serialized);
    }

    public static PurgeTransactionPayload create(TransactionIdentifier transactionId, int initialSerializedBufferCapacity) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)initialSerializedBufferCapacity);
        try {
            transactionId.writeTo((DataOutput)out);
        }
        catch (IOException e) {
            LOG.error("Failed to serialize {}", (Object)transactionId, (Object)e);
            throw new IllegalStateException("Failed to serialize " + transactionId, e);
        }
        return new PurgeTransactionPayload(transactionId, out.toByteArray());
    }

    @Override
    protected PT externalizableProxy(byte[] serialized) {
        return new PT(serialized);
    }

    @Override
    protected int externalizableProxySize() {
        return PROXY_SIZE;
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static final class Proxy
    extends AbstractIdentifiablePayload.AbstractProxy<TransactionIdentifier> {
        private static final long serialVersionUID = 1L;

        @Override
        protected TransactionIdentifier readIdentifier(DataInput in) throws IOException {
            return TransactionIdentifier.readFrom((DataInput)in);
        }

        protected PurgeTransactionPayload createObject(TransactionIdentifier identifier, byte[] serialized) {
            return new Magnesium(identifier, serialized);
        }
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static final class Magnesium
    extends PurgeTransactionPayload
    implements LegacySerializable {
        private static final long serialVersionUID = 1L;

        Magnesium(TransactionIdentifier transactionId, byte[] serialized) {
            super(transactionId, serialized);
        }
    }
}

