/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.opendaylight.controller.cluster.datastore.persisted.SkipTransactionsPayload;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;

final class ST
implements AbstractIdentifiablePayload.SerialForm {
    private static final long serialVersionUID = 1L;
    private ImmutableUnsignedLongSet transactionIds;
    private LocalHistoryIdentifier identifier;
    private byte[] bytes;

    public ST() {
    }

    ST(byte[] bytes) {
        this.bytes = Objects.requireNonNull(bytes);
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public void readExternal(byte[] newBytes) throws IOException {
        this.bytes = Objects.requireNonNull(newBytes);
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])newBytes);
        this.identifier = LocalHistoryIdentifier.readFrom((DataInput)in);
        this.transactionIds = (ImmutableUnsignedLongSet)Verify.verifyNotNull((Object)ImmutableUnsignedLongSet.readFrom((DataInput)in));
    }

    @Override
    public Object readResolve() {
        return new SkipTransactionsPayload(this.identifier, this.bytes, this.transactionIds);
    }
}

