/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import akka.dispatch.OnComplete;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompositeOnComplete<T>
extends OnComplete<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeOnComplete.class);
    private final List<OnComplete<T>> onCompleteTasks = new ArrayList<OnComplete<T>>();

    public void addOnComplete(OnComplete<T> task) {
        this.onCompleteTasks.add(task);
    }

    protected void notifyOnCompleteTasks(Throwable failure, T result) {
        for (OnComplete<T> task : this.onCompleteTasks) {
            try {
                task.onComplete(failure, result);
            }
            catch (Throwable e) {
                LOG.error("Caught unexpected exception", e);
            }
        }
        this.onCompleteTasks.clear();
    }
}

