/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NormalizedNodeXMLOutput {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedNodeXMLOutput.class);
    private static final XMLOutputFactory XOF;

    private NormalizedNodeXMLOutput() {
    }

    public static void toStream(OutputStream outStream, NormalizedNode node) throws XMLStreamException, IOException {
        XMLStreamWriter xmlWriter = XOF.createXMLStreamWriter(outStream);
        IndentingXMLStreamWriter indenting = new IndentingXMLStreamWriter(xmlWriter);
        try (NormalizedNodeStreamWriter streamWriter = XMLStreamNormalizedNodeStreamWriter.createSchemaless((XMLStreamWriter)indenting);){
            NormalizedNodeWriter nodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)streamWriter);
            nodeWriter.write(node);
            nodeWriter.flush();
        }
    }

    public static void toFile(File file, NormalizedNode node) {
        try (FileOutputStream outStream = new FileOutputStream(file);){
            NormalizedNodeXMLOutput.toStream(outStream, node);
        }
        catch (IOException | XMLStreamException e) {
            LOG.error("Error writing NormalizedNode to file {}", (Object)file, (Object)e);
        }
    }

    static {
        XMLOutputFactory f = XMLOutputFactory.newFactory();
        f.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        XOF = f;
    }
}

