/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.websocket.internal;

import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.core.ContextClassLoaderSetupAction;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.extensions.PerMessageDeflateHandshake;
import io.undertow.websockets.jsr.ExtensionImpl;
import io.undertow.websockets.jsr.JsrWebSocketFilter;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.websocket.Extension;
import javax.websocket.server.ServerContainer;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.undertow.PaxWebUndertowExtension;
import org.ops4j.pax.web.service.undertow.UndertowSupport;
import org.ops4j.pax.web.service.undertow.configuration.model.ServletContainer;
import org.ops4j.pax.web.service.undertow.configuration.model.UndertowConfiguration;

public class WebSocketsExtension
implements PaxWebUndertowExtension {
    public void handleDeployment(DeploymentInfo deploymentInfo, UndertowConfiguration configuration, UndertowSupport support, OsgiContextModel osgiContextModel) {
        ServletContainer.Websockets wsConfig = null;
        if (configuration != null && configuration.getSubsystem() != null && configuration.getSubsystem().getServletContainer() != null) {
            wsConfig = configuration.getSubsystem().getServletContainer().getWebsockets();
        }
        WebSocketDeploymentInfo wsInfo = new WebSocketDeploymentInfo();
        if (wsConfig != null) {
            wsInfo.setDispatchToWorkerThread(wsConfig.isDispatchToWorker());
            wsInfo.setWorker(support.getWorker(wsConfig.getWorkerName()));
            wsInfo.setBuffers(support.getBufferPool(wsConfig.getBufferPoolName()));
            if (wsConfig.isPerMessageDeflate()) {
                PerMessageDeflateHandshake perMessageDeflate = new PerMessageDeflateHandshake(false, wsConfig.getDeflaterLevel());
                wsInfo.addExtension((ExtensionHandshake)perMessageDeflate);
            }
        } else {
            wsInfo.setDispatchToWorkerThread(true);
            wsInfo.setWorker(support.getWorker("default"));
            wsInfo.setBuffers(support.getBufferPool("default"));
        }
        ArrayList<ContextClassLoaderSetupAction> setup = new ArrayList<ContextClassLoaderSetupAction>();
        setup.add(new ContextClassLoaderSetupAction(deploymentInfo.getClassLoader()));
        setup.addAll(deploymentInfo.getThreadSetupActions());
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (ExtensionHandshake e : wsInfo.getExtensions()) {
            extensions.add(ExtensionImpl.create((WebSocketExtension)new WebSocketExtension(e.getName(), Collections.emptyList())));
        }
        ServerWebSocketContainer container = new ServerWebSocketContainer(deploymentInfo.getClassIntrospecter(), deploymentInfo.getClassLoader(), wsInfo.getWorker(), wsInfo.getBuffers(), setup, wsInfo.isDispatchToWorkerThread(), null, wsInfo.getReconnectHandler(), extensions);
        deploymentInfo.addServletContextAttribute(ServerContainer.class.getName(), (Object)container);
        deploymentInfo.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo.paxweb", (Object)wsInfo);
        EventListener proxy = support.proxiedServletContextListener((EventListener)((Object)new WebSocketListener()), osgiContextModel);
        deploymentInfo.addListener(Servlets.listener(WebSocketListener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)proxy)));
        deploymentInfo.addDeploymentCompleteListener((ServletContextListener)new WsCleanUpServletContextListener(container));
    }

    public void cleanDeployment(DeploymentInfo deploymentInfo) {
        deploymentInfo.getServletContextAttributes().remove(ServerContainer.class.getName());
        deploymentInfo.getServletContextAttributes().remove("io.undertow.websockets.jsr.WebSocketDeploymentInfo.paxweb");
        deploymentInfo.getListeners().removeIf(li -> li.getListenerClass() == WebSocketListener.class);
        deploymentInfo.getDeploymentCompleteListeners().removeIf(dcl -> dcl.getClass() == WsCleanUpServletContextListener.class);
    }

    private static class WsCleanUpServletContextListener
    implements ServletContextListener {
        private final ServerWebSocketContainer container;

        WsCleanUpServletContextListener(ServerWebSocketContainer container) {
            this.container = container;
        }

        public void contextInitialized(ServletContextEvent sce) {
            this.container.validateDeployment();
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }

    private static final class WebSocketListener
    implements ServletContextListener {
        private ServerWebSocketContainer container;

        private WebSocketListener() {
        }

        public void contextInitialized(ServletContextEvent sce) {
            ServletContext servletContext = sce.getServletContext();
            Object wsInfo = servletContext.getAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo.paxweb");
            servletContext.setAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", wsInfo);
            this.container = (ServerWebSocketContainer)servletContext.getAttribute(ServerContainer.class.getName());
            FilterRegistration.Dynamic filter = servletContext.addFilter("Undertow Web Socket Filter", JsrWebSocketFilter.class);
            servletContext.addListener(JsrWebSocketFilter.LogoutListener.class);
            filter.setAsyncSupported(true);
            filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
        }

        public void contextDestroyed(ServletContextEvent sce) {
            this.container.close();
        }
    }
}

