/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.query.QueryExpression;
import org.opendaylight.mdsal.binding.api.query.QueryResult;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultQuery;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeQueryOperations;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadOperations;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.query.DOMQuery;
import org.opendaylight.mdsal.dom.api.query.DOMQueryResult;
import org.opendaylight.mdsal.dom.spi.query.DOMQueryEvaluator;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractForwardedTransaction<T extends DOMDataTreeTransaction>
implements Delegator<T>,
Identifiable<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractForwardedTransaction.class);
    private final @NonNull AdapterContext adapterContext;
    private final @NonNull T delegate;

    AbstractForwardedTransaction(AdapterContext adapterContext, T delegateTx) {
        this.adapterContext = Objects.requireNonNull(adapterContext, "Codec must not be null");
        this.delegate = (DOMDataTreeTransaction)Objects.requireNonNull(delegateTx, "Delegate must not be null");
    }

    public final Object getIdentifier() {
        return this.delegate.getIdentifier();
    }

    public final T getDelegate() {
        return this.delegate;
    }

    protected final <S extends DOMDataTreeTransaction> S getDelegateChecked(Class<S> txType) {
        Preconditions.checkState((boolean)txType.isInstance(this.delegate));
        return (S)((DOMDataTreeTransaction)txType.cast(this.delegate));
    }

    protected final AdapterContext adapterContext() {
        return this.adapterContext;
    }

    protected final <D extends DataObject> @NonNull FluentFuture<Optional<D>> doRead(DOMDataTreeReadOperations readOps, LogicalDatastoreType store, InstanceIdentifier<D> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Invalid read of wildcarded path %s", path);
        CurrentAdapterSerializer codec = this.adapterContext.currentSerializer();
        YangInstanceIdentifier domPath = codec.toYangInstanceIdentifier(path);
        return readOps.read(store, domPath).transform(optData -> optData.map(domData -> (DataObject)codec.fromNormalizedNode(domPath, (NormalizedNode)domData).getValue()), MoreExecutors.directExecutor());
    }

    protected final @NonNull FluentFuture<Boolean> doExists(DOMDataTreeReadOperations readOps, LogicalDatastoreType store, InstanceIdentifier<?> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Invalid exists of wildcarded path %s", path);
        return readOps.exists(store, this.adapterContext.currentSerializer().toYangInstanceIdentifier(path));
    }

    protected static final <T extends DataObject> @NonNull FluentFuture<QueryResult<T>> doExecute(DOMDataTreeReadOperations readOps, @NonNull LogicalDatastoreType store, @NonNull QueryExpression<T> query) {
        FluentFuture fluentFuture;
        Preconditions.checkArgument((boolean)(query instanceof DefaultQuery), (String)"Unsupported query type %s", query);
        DefaultQuery defaultQuery = (DefaultQuery)query;
        DOMDataTreeReadOperations dOMDataTreeReadOperations = Objects.requireNonNull(readOps);
        if (dOMDataTreeReadOperations instanceof DOMDataTreeQueryOperations) {
            DOMDataTreeQueryOperations dtqOps = (DOMDataTreeQueryOperations)dOMDataTreeReadOperations;
            fluentFuture = dtqOps.execute(store, defaultQuery.asDOMQuery());
        } else {
            fluentFuture = AbstractForwardedTransaction.fallbackExecute(readOps, store, defaultQuery.asDOMQuery());
        }
        FluentFuture domFuture = fluentFuture;
        return domFuture.transform(defaultQuery::toQueryResult, MoreExecutors.directExecutor());
    }

    private static FluentFuture<DOMQueryResult> fallbackExecute(@NonNull DOMDataTreeReadOperations readOps, @NonNull LogicalDatastoreType store, @NonNull DOMQuery domQuery) {
        LOG.trace("Fallback evaluation of {} on {}", (Object)domQuery, (Object)readOps);
        return readOps.read(store, domQuery.getRoot()).transform(node -> node.map(data -> DOMQueryEvaluator.evaluateOn((DOMQuery)domQuery, (NormalizedNode)data)).orElse(DOMQueryResult.of()), MoreExecutors.directExecutor());
    }
}

