/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.api.ActionProviderService;
import org.opendaylight.mdsal.binding.api.ActionSpec;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingOperationFluentFuture;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionInstance;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionResult;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.mdsal.dom.spi.SimpleDOMActionResult;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public final class ActionProviderServiceAdapter
extends AbstractBindingAdapter<DOMActionProviderService>
implements ActionProviderService {
    private static final Logger LOG = LoggerFactory.getLogger(ActionProviderServiceAdapter.class);
    static final BindingDOMAdapterBuilder.Factory<ActionProviderService> BUILDER_FACTORY = Builder::new;

    ActionProviderServiceAdapter(AdapterContext adapterContext, DOMActionProviderService delegate) {
        super(adapterContext, delegate);
    }

    public <P extends DataObject, A extends Action<? extends InstanceIdentifier<P>, ?, ?>, S extends A> ObjectRegistration<S> registerImplementation(ActionSpec<A, P> spec, S implementation, LogicalDatastoreType datastore, Set<? extends InstanceIdentifier<P>> validNodes) {
        CurrentAdapterSerializer serializer = this.currentSerializer();
        SchemaNodeIdentifier.Absolute actionPath = serializer.getActionPath(spec);
        Impl impl = new Impl(this.adapterContext(), actionPath, spec.type(), (Action<?, ?, ?>)implementation);
        DOMActionInstance instance = validNodes.isEmpty() ? DOMActionInstance.of((SchemaNodeIdentifier.Absolute)actionPath, (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{new DOMDataTreeIdentifier(datastore, YangInstanceIdentifier.empty())}) : DOMActionInstance.of((SchemaNodeIdentifier.Absolute)actionPath, validNodes.stream().map(node -> serializer.toDOMDataTreeIdentifier(DataTreeIdentifier.create((LogicalDatastoreType)datastore, (InstanceIdentifier)node))).collect(Collectors.toUnmodifiableSet()));
        final ObjectRegistration reg = ((DOMActionProviderService)this.getDelegate()).registerActionImplementation((DOMActionImplementation)impl, instance);
        return new AbstractObjectRegistration<S>((Action)implementation){

            protected void removeRegistration() {
                reg.close();
            }
        };
    }

    private static final class Impl
    implements DOMActionImplementation {
        private final Class<? extends Action<?, ?, ?>> actionInterface;
        private final AdapterContext adapterContext;
        private final Action implementation;
        private final YangInstanceIdentifier.NodeIdentifier outputName;

        Impl(AdapterContext adapterContext, SchemaNodeIdentifier.Absolute actionPath, Class<? extends Action<?, ?, ?>> actionInterface, Action<?, ?, ?> implementation) {
            this.adapterContext = Objects.requireNonNull(adapterContext);
            this.outputName = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.operationOutputQName((QNameModule)actionPath.lastNodeIdentifier().getModule()));
            this.actionInterface = Objects.requireNonNull(actionInterface);
            this.implementation = Objects.requireNonNull(implementation);
        }

        public ListenableFuture<? extends DOMActionResult> invokeAction(SchemaNodeIdentifier.Absolute type, DOMDataTreeIdentifier path, ContainerNode input) {
            CurrentAdapterSerializer codec = this.adapterContext.currentSerializer();
            InstanceIdentifier instance = codec.fromYangInstanceIdentifier(path.getRootIdentifier());
            if (instance == null) {
                LOG.debug("Path {} is not representable in binding, rejecting invocation", (Object)path);
                return Futures.immediateFuture((Object)new SimpleDOMActionResult(List.of(RpcResultBuilder.newError((ErrorType)ErrorType.APPLICATION, (ErrorTag)ErrorTag.INVALID_VALUE, (String)"Supplied path cannot be represented"))));
            }
            if (instance.isWildcarded()) {
                LOG.debug("Path {} maps to a wildcard {}, rejecting invocation", (Object)path, (Object)instance);
                return Futures.immediateFuture((Object)new SimpleDOMActionResult(List.of(RpcResultBuilder.newError((ErrorType)ErrorType.APPLICATION, (ErrorTag)ErrorTag.INVALID_VALUE, (String)"Supplied path does not identify a concrete instance"))));
            }
            ListenableFuture userFuture = this.implementation.invoke(instance, codec.fromNormalizedNodeActionInput(this.actionInterface, input));
            if (userFuture instanceof BindingOperationFluentFuture) {
                return (BindingOperationFluentFuture)userFuture;
            }
            return new BindingOperationFluentFuture(userFuture, this.actionInterface, this.outputName, this.adapterContext);
        }
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<ActionProviderService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        protected ActionProviderService createInstance(ClassToInstanceMap<DOMService> delegates) {
            return new ActionProviderServiceAdapter(this.adapterContext(), (DOMActionProviderService)delegates.getInstance(DOMActionProviderService.class));
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMActionProviderService.class);
        }
    }
}

