/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.SingleBindingDOMNotificationAdapter;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

@VisibleForTesting
public class BindingDOMNotificationServiceAdapter
implements NotificationService {
    public static final BindingDOMAdapterBuilder.Factory<NotificationService> BUILDER_FACTORY = Builder::new;
    private final AdapterContext adapterContext;
    private final DOMNotificationService domNotifService;

    public BindingDOMNotificationServiceAdapter(AdapterContext adapterContext, DOMNotificationService domNotifService) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.domNotifService = domNotifService;
    }

    @Deprecated(since="10.0.0", forRemoval=true)
    public <T extends NotificationListener> ListenerRegistration<T> registerNotificationListener(T listener) {
        BindingDOMNotificationListenerAdapter domListener = new BindingDOMNotificationListenerAdapter(this.adapterContext, listener);
        return new ListenerRegistrationImpl<T>(listener, this.domNotifService.registerNotificationListener((DOMNotificationListener)domListener, domListener.getSupportedNotifications()));
    }

    public <N extends Notification<N> & DataObject> Registration registerListener(Class<N> type, NotificationService.Listener<N> listener, Executor executor) {
        SingleBindingDOMNotificationAdapter<N> domListener = new SingleBindingDOMNotificationAdapter<N>(this.adapterContext, type, listener, executor);
        return this.domNotifService.registerNotificationListener(domListener, domListener.getSupportedNotifications());
    }

    public Registration registerCompositeListener(NotificationService.CompositeListener listener, Executor executor) {
        Executor exec = Objects.requireNonNull(executor);
        HashMap listeners = new HashMap();
        for (NotificationService.CompositeListener.Component constituent : listener.constituents()) {
            SingleBindingDOMNotificationAdapter domListener = new SingleBindingDOMNotificationAdapter(this.adapterContext, constituent, exec);
            listeners.put(domListener.getSupportedNotifications().iterator().next(), domListener);
        }
        return this.domNotifService.registerNotificationListeners(listeners);
    }

    @Deprecated(since="10.0.0", forRemoval=true)
    private static final class ListenerRegistrationImpl<T extends NotificationListener>
    extends AbstractListenerRegistration<T> {
        private final ListenerRegistration<?> listenerRegistration;

        ListenerRegistrationImpl(T listener, ListenerRegistration<?> listenerRegistration) {
            super(listener);
            this.listenerRegistration = listenerRegistration;
        }

        protected void removeRegistration() {
            this.listenerRegistration.close();
        }
    }

    private static class Builder
    extends BindingDOMAdapterBuilder<NotificationService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        protected NotificationService createInstance(ClassToInstanceMap<DOMService> delegates) {
            DOMNotificationService domNotification = (DOMNotificationService)delegates.getInstance(DOMNotificationService.class);
            return new BindingDOMNotificationServiceAdapter(this.adapterContext(), domNotification);
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMNotificationService.class);
        }
    }
}

