/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.osgi;

import com.google.common.collect.Maps;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AdaptingTracker<D extends DOMService, B extends BindingService>
extends ServiceTracker<D, ComponentHolder<B>> {
    private static final Logger LOG = LoggerFactory.getLogger(AdaptingTracker.class);
    private final Function<D, B> bindingFactory;
    private final @NonNull Class<B> bindingClass;
    private final ComponentFactory<? extends B> componentFactory;

    AdaptingTracker(BundleContext ctx, Class<D> domClass, Class<B> bindingClass, Function<D, B> bindingFactory, ComponentFactory<? extends B> componentFactory) {
        super(ctx, domClass, null);
        this.bindingClass = Objects.requireNonNull(bindingClass);
        this.bindingFactory = Objects.requireNonNull(bindingFactory);
        this.componentFactory = Objects.requireNonNull(componentFactory);
    }

    public void open(boolean trackAllServices) {
        LOG.debug("Starting tracker for {}", (Object)this.bindingClass.getName());
        super.open(trackAllServices);
        LOG.debug("Tracker for {} started", (Object)this.bindingClass.getName());
    }

    public ComponentHolder<B> addingService(ServiceReference<D> reference) {
        if (reference == null) {
            LOG.debug("Null reference for {}, ignoring it", (Object)this.bindingClass.getName());
            return null;
        }
        if (reference.getProperty("odl.mdsal.binding.adapter.ignore") != null) {
            LOG.debug("Ignoring reference {} due to {}", reference, (Object)"odl.mdsal.binding.adapter.ignore");
            return null;
        }
        DOMService dom = (DOMService)this.context.getService(reference);
        if (dom == null) {
            LOG.debug("Could not get {} service from {}, ignoring it", (Object)this.bindingClass.getName(), reference);
            return null;
        }
        BindingService binding = (BindingService)this.bindingFactory.apply(dom);
        return new ComponentHolder<BindingService>(binding, this.componentFactory.newInstance(AdaptingTracker.referenceProperties(reference, binding)));
    }

    public void modifiedService(ServiceReference<D> reference, ComponentHolder<B> service) {
        if (service != null && reference != null) {
            service.component.dispose();
            service.component = this.componentFactory.newInstance(AdaptingTracker.referenceProperties(reference, service.binding));
        }
    }

    public void removedService(ServiceReference<D> reference, ComponentHolder<B> service) {
        if (service != null) {
            this.context.ungetService(reference);
            service.component.dispose();
            LOG.debug("Unregistered service {}", service);
        }
    }

    static Dictionary<String, Object> referenceProperties(ServiceReference<?> ref, BindingService service) {
        Object value;
        String[] keys = ref.getPropertyKeys();
        HashMap props = Maps.newHashMapWithExpectedSize((int)(keys.length + 1));
        for (String key : keys) {
            if (key.startsWith("odl.mdsal.binding.adapter.") || (value = ref.getProperty(key)) == null) continue;
            props.put(key, value);
        }
        for (String key : keys) {
            String newKey;
            if (!key.startsWith("odl.mdsal.binding.adapter.override.") || (value = ref.getProperty(key)) == null || (newKey = key.substring("odl.mdsal.binding.adapter.override.".length())).isEmpty()) continue;
            LOG.debug("Overriding property {}", (Object)newKey);
            props.put(newKey, value);
        }
        props.put("org.opendaylight.mdsal.binding.dom.adapter.osgi.AbstractAdaptedService.DELEGATE", service);
        return FrameworkUtil.asDictionary((Map)props);
    }

    static final class ComponentHolder<B extends BindingService> {
        final B binding;
        ComponentInstance<? extends B> component;

        ComponentHolder(B binding, ComponentInstance<? extends B> component) {
            this.binding = (BindingService)Objects.requireNonNull(binding);
            this.component = Objects.requireNonNull(component);
        }
    }
}

